/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.init;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigInit {
    private static final ForgeConfigSpec.Builder common_builder = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder server_builder = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder client_builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec common_config;
    public static final ForgeConfigSpec server_config;
    public static final ForgeConfigSpec client_config;
    public static ForgeConfigSpec.ConfigValue<Integer> showPlayerNameTags;
    public static ForgeConfigSpec.ConfigValue<Integer> showMobNameTags;
    public static ForgeConfigSpec.ConfigValue<Boolean> invulnerable;
    public static ForgeConfigSpec.ConfigValue<Boolean> canUseCommands;
    public static ForgeConfigSpec.ConfigValue<Boolean> canPickupItems;
    public static ForgeConfigSpec.ConfigValue<Double> maxHealth;
    public static ForgeConfigSpec.ConfigValue<Boolean> canDrown;
    public static ForgeConfigSpec.ConfigValue<Boolean> takesFireDamage;
    public static ForgeConfigSpec.ConfigValue<Boolean> takesWaterDamage;
    public static ForgeConfigSpec.ConfigValue<Boolean> takesFallDamage;
    public static ForgeConfigSpec.ConfigValue<Boolean> loop;
    public static ForgeConfigSpec.ConfigValue<Boolean> shouldPersist;
    public static ForgeConfigSpec.ConfigValue<String> chatPrefix;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableSystemMessages;
    public static ForgeConfigSpec.ConfigValue<String> formatterChar;

    public static void init(ForgeConfigSpec.Builder common, ForgeConfigSpec.Builder server, ForgeConfigSpec.Builder client) {
        common.comment("CosmicNPCs Config");
        common.push("Default NPC settings");
        showPlayerNameTags = common.comment("Defines the nametag visibility of npcs with a player model (0 = invisible, 1 = always visible, 2 = only visible when looked at)").define("cosmicnpcs.showPlayerNameTags", (Object)1);
        showMobNameTags = common.comment("Defines the nametag visibility of npcs with no player model (0 = invisible, 1 = always visible, 2 = only visible when looked at)").define("cosmicnpcs.showMobNameTags", (Object)0);
        invulnerable = common.comment("Defines if npcs should be invulnerable").define("cosmicnpcs.invulnerable", false);
        canUseCommands = common.comment("Defines if npcs should be able to execute commands").define("cosmicnpcs.canUseCommands", false);
        canPickupItems = common.comment("Defines if npcs should be able to pickup items").define("cosmicnpcs.canPickupItems", false);
        maxHealth = common.comment("Defines the maximum health points of npcs").define("cosmicnpcs.maxHealth", (Object)20.0);
        canDrown = common.comment("Defines if npcs should be able to drown").define("cosmicnpcs.canDrown", true);
        takesFireDamage = common.comment("Defines if npcs should take damage from fire or lava").define("cosmicnpcs.takesFireDamage", true);
        takesWaterDamage = common.comment("Defines if npcs should take damage from water or rain").define("cosmicnpcs.takesWaterDamage", false);
        takesFallDamage = common.comment("Defines if npcs should take fall damage").define("cosmicnpcs.takesFallDamage", true);
        loop = common.comment("Defines if npcs should repeat their play-backs after finishing").define("cosmicnpcs.loop", false);
        shouldPersist = common.comment("Defines if npcs should persist in the world after finishing the play-back").define("cosmicnpcs.shouldPersist", false);
        chatPrefix = common.comment("The prefix used for chat messages send by npcs").define("cosmicnpcs.chatPrefix", (Object)"<%s> ");
        common.pop();
        disableSystemMessages = common.comment("(EXPERIMENTAL) if this is enabled, npcs no longer send system chat messages. Doesn't work on multiplayer servers!").define("cosmicnpcs.disableSystemMessages", true);
        formatterChar = common.comment("The char used for formatting npc names").define("cosmicnpcs.formatterChar", (Object)"$");
    }

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CosmicNPCs.LOGGER.info("Loading config:" + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        CosmicNPCs.LOGGER.info("Built config:" + path);
        file.load();
        CosmicNPCs.LOGGER.info("Loaded config:" + path);
        config.setConfig((CommentedConfig)file);
    }

    static {
        ConfigInit.init(common_builder, server_builder, client_builder);
        common_config = common_builder.build();
        server_config = server_builder.build();
        client_config = client_builder.build();
    }
}

