/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CAbstractEyesLayer<T extends LivingEntity, M extends EntityModel<T>>
extends EyesLayer<T, M> {
    private String layerTexture;
    private EyeType eyeTextureType;

    public CAbstractEyesLayer(RenderLayerParent<T, M> rendererIn, CosmicNPCEntity npc, EyeType eyeTextureType) {
        super(rendererIn);
        this.layerTexture = npc.getSettings().m_128461_("Layer");
        this.eyeTextureType = eyeTextureType;
    }

    public RenderType m_5708_() {
        return RenderType.m_110488_((ResourceLocation)this.getLayerTexture());
    }

    public ResourceLocation getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return this.eyeTextureType.getResourceLocation();
    }

    public static enum EyeType {
        ENDERMAN(new ResourceLocation("textures/entity/enderman/enderman_eyes.png")),
        SPIDER(new ResourceLocation("textures/entity/spider_eyes.png")),
        PHANTOM(new ResourceLocation("textures/entity/phantom_eyes.png"));

        private ResourceLocation resourceLocation;

        private EyeType(ResourceLocation loc) {
            this.resourceLocation = loc;
        }

        private ResourceLocation getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

