/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public class CComponentArgument
implements ArgumentType<Component> {
    private static final Collection<String> EXAMPLES = Arrays.asList("\"hello world\"", "\"\"", "\"{\"text\":\"hello world\"}", "[\"\"]");
    public static final DynamicCommandExceptionType ERROR_INVALID_JSON = new DynamicCommandExceptionType(p_87121_ -> Component.m_237110_((String)"argument.component.invalid", (Object[])new Object[]{p_87121_}));

    private CComponentArgument() {
    }

    public static Component getComponent(CommandContext<CommandSourceStack> p_87118_, String p_87119_) {
        return (Component)p_87118_.getArgument(p_87119_, Component.class);
    }

    public static CComponentArgument textComponent() {
        return new CComponentArgument();
    }

    public Component parse(StringReader reader) throws CommandSyntaxException {
        String[] args = StringUtils.split((String)reader.getRemaining());
        String argument = args[0];
        if (argument.startsWith("\"")) {
            return Component.m_237113_((String)reader.readString());
        }
        if (!argument.startsWith("{")) {
            return Component.m_237113_((String)reader.readUnquotedString());
        }
        try {
            MutableComponent component = Component.Serializer.m_130699_((StringReader)reader);
            reader.setCursor(reader.getCursor() - 1);
            if (component == null) {
                throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)reader, (Object)"empty");
            }
            return component;
        }
        catch (Exception exception) {
            String s = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            throw ERROR_INVALID_JSON.createWithContext((ImmutableStringReader)reader, (Object)s);
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

