/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.storage.LevelResource;

public class RecordThread
implements Runnable {
    public Thread t;
    Player player;
    public Boolean capture = false;
    RandomAccessFile in;
    Boolean lastTickSwipe = false;
    int[] itemsEquipped = new int[6];
    CompoundTag[] equipedItemsData = new CompoundTag[6];
    List<NPCAction> eventList;

    public RecordThread(Player _player, String capname) {
        Path path = _player.m_9236_().m_7654_().m_129843_(new LevelResource("cosmicnpcs/recordings"));
        File file = new File("" + path.resolve(capname));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            this.in = new RandomAccessFile(path + "/" + capname + ".ccap", "rw");
            this.in.setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.player = _player;
        this.capture = true;
        this.eventList = CosmicNPCs.instance.getActionListForPlayer(this.player);
        this.t = new Thread((Runnable)this, "NPC Record Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            this.in.writeShort(60417);
            while (this.capture.booleanValue()) {
                this.trackAndWriteMovement();
                this.trackSwing();
                this.trackHeldItem();
                this.trackHeldItemOffhand();
                this.trackArmor();
                this.writeActions();
                Thread.sleep(25L);
                if (!this.player.m_21224_()) continue;
                this.capture = false;
                CosmicNPCs.instance.recordThreads.remove(this.player);
                MutableComponent msg = Component.m_237113_((String)"Stopped recording ").m_7220_(this.player.m_5446_()).m_130946_(". RIP.");
                this.player.m_213846_((Component)msg);
            }
            this.in.close();
        }
        catch (InterruptedException e) {
            System.out.println("Child interrupted.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Exiting child thread.");
    }

    private void trackAndWriteMovement() throws IOException {
        this.in.writeFloat(this.player.f_20885_);
        this.in.writeFloat(this.player.m_146908_());
        this.in.writeFloat(this.player.m_146909_());
        this.in.writeDouble(this.player.m_20185_());
        this.in.writeDouble(this.player.m_20186_());
        this.in.writeDouble(this.player.m_20189_());
        this.in.writeDouble(this.player.m_20184_().f_82479_);
        this.in.writeDouble(this.player.m_20184_().f_82480_);
        this.in.writeDouble(this.player.m_20184_().f_82481_);
        this.in.writeFloat(this.player.f_19789_);
        this.in.writeBoolean(this.player.f_19812_);
        this.in.writeBoolean(this.player.m_6144_());
        this.in.writeBoolean(this.player.m_20142_());
        this.in.writeBoolean(this.player.m_20096_());
        this.in.writeBoolean(this.player.m_21255_());
        this.in.writeBoolean(this.player.m_6069_());
        if (this.player.m_6117_()) {
            this.in.writeBoolean(this.player.m_6117_());
            this.in.writeInt(this.player.m_7655_() == InteractionHand.MAIN_HAND ? 0 : 1);
        } else {
            this.in.writeBoolean(this.player.m_6117_());
            this.in.writeInt(0);
        }
    }

    private void trackArmor() {
        for (int ci = 1; ci < 5; ++ci) {
            NPCAction ma;
            ItemStack playerArmorPiece = (ItemStack)this.player.m_150109_().f_35975_.get(ci - 1);
            if (playerArmorPiece != null) {
                if (Item.m_41393_((Item)playerArmorPiece.m_41720_()) == this.itemsEquipped[ci] && playerArmorPiece.serializeNBT().equals((Object)this.equipedItemsData[ci])) continue;
                this.itemsEquipped[ci] = Item.m_41393_((Item)playerArmorPiece.m_41720_());
                this.equipedItemsData[ci] = playerArmorPiece.serializeNBT();
                ma = new NPCAction(4);
                ma.armorSlot = ci;
                ma.armorId = this.itemsEquipped[ci];
                ma.armorDmg = playerArmorPiece.m_41773_();
                playerArmorPiece.m_41739_(ma.itemData);
                this.eventList.add(ma);
                continue;
            }
            if (this.itemsEquipped[ci] == -1) continue;
            this.itemsEquipped[ci] = -1;
            this.equipedItemsData[ci] = new CompoundTag();
            ma = new NPCAction(4);
            ma.armorSlot = ci;
            ma.armorId = this.itemsEquipped[ci];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItem() {
        ItemStack playerHeldItem = this.player.m_21120_(InteractionHand.MAIN_HAND);
        if (!playerHeldItem.m_41619_()) {
            if (Item.m_41393_((Item)playerHeldItem.m_41720_()) != this.itemsEquipped[0] || !playerHeldItem.serializeNBT().equals((Object)this.equipedItemsData[0])) {
                this.itemsEquipped[0] = Item.m_41393_((Item)playerHeldItem.m_41720_());
                this.equipedItemsData[0] = playerHeldItem.serializeNBT();
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 0;
                ma.armorId = this.itemsEquipped[0];
                ma.armorDmg = playerHeldItem.m_41773_();
                playerHeldItem.m_41739_(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[0] != -1) {
            this.itemsEquipped[0] = -1;
            this.equipedItemsData[0] = new CompoundTag();
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 0;
            ma.armorId = this.itemsEquipped[0];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItemOffhand() {
        ItemStack playerHeldItem = this.player.m_21120_(InteractionHand.OFF_HAND);
        if (!playerHeldItem.m_41619_()) {
            if (Item.m_41393_((Item)playerHeldItem.m_41720_()) != this.itemsEquipped[5] || !playerHeldItem.serializeNBT().equals((Object)this.equipedItemsData[5])) {
                this.itemsEquipped[5] = Item.m_41393_((Item)playerHeldItem.m_41720_());
                this.equipedItemsData[5] = playerHeldItem.serializeNBT();
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 5;
                ma.armorId = this.itemsEquipped[5];
                ma.armorDmg = playerHeldItem.m_41773_();
                playerHeldItem.m_41739_(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[5] != -1) {
            this.itemsEquipped[5] = -1;
            this.equipedItemsData[0] = new CompoundTag();
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 5;
            ma.armorId = this.itemsEquipped[5];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackSwing() {
        if (this.player.f_20913_ == -1 && this.player.f_20911_) {
            this.eventList.add(new NPCAction(2));
        }
    }

    private void writeActions() throws IOException {
        if (this.eventList.size() > 0) {
            this.in.writeBoolean(true);
            NPCAction ma = this.eventList.get(0);
            this.in.writeByte(ma.type);
            switch (ma.type) {
                case 1: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    NbtIo.m_128941_((CompoundTag)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 4: {
                    this.in.writeInt(ma.armorSlot);
                    this.in.writeInt(ma.armorId);
                    this.in.writeInt(ma.armorDmg);
                    if (ma.armorId == -1) break;
                    NbtIo.m_128941_((CompoundTag)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 5: {
                    this.in.writeInt(ma.arrowCharge);
                    break;
                }
                case 7: {
                    this.in.writeInt(ma.stateId);
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    if (!(Block.m_49803_((int)ma.stateId).m_60734_() instanceof SignBlock)) break;
                    NbtIo.m_128941_((CompoundTag)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 8: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 9: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    this.in.writeInt(ma.metaData);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    this.in.writeByte((byte)ma.handType.ordinal());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 6: {
                    CosmicNPCs.instance.recordThreads.remove(this.player);
                    MutableComponent msg = Component.m_237113_((String)"Stopped recording ").m_7220_(this.player.m_5446_()).m_130946_(". Bye!");
                    this.player.m_213846_((Component)msg);
                    this.capture = false;
                    break;
                }
            }
            this.eventList.remove(0);
        } else {
            this.in.writeBoolean(false);
        }
    }
}

