/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.math.NumberUtils;

@OnlyIn(value=Dist.CLIENT)
public class CLeatherHorseArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<Horse, HorseModel<Horse>> {
    private final HorseModel<Horse> model;
    private ItemStack armor;
    private int color;

    public CLeatherHorseArmorLayer(RenderLayerParent<Horse, HorseModel<Horse>> p_i232476_1_, EntityModelSet modelSet, CosmicNPCEntity npc) {
        super(p_i232476_1_);
        this.model = new HorseModel(modelSet.m_171103_(ModelLayers.f_171187_));
        String armorString = npc.getSettings().m_128461_("Armor");
        this.armor = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(armorString)));
        String colorString = npc.getSettings().m_128461_("Color");
        this.color = NumberUtils.toInt((String)colorString);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Horse entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = this.armor;
        if (itemstack.m_41720_() instanceof HorseArmorItem) {
            float f2;
            float f1;
            float f;
            HorseArmorItem horsearmoritem = (HorseArmorItem)itemstack.m_41720_();
            ((HorseModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((AbstractHorse)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_((AbstractHorse)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (horsearmoritem instanceof DyeableHorseArmorItem && this.color != 0) {
                int i = this.color;
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                f2 = (float)(i & 0xFF) / 255.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)horsearmoritem.m_41367_()));
            this.model.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, f, f1, f2, 1.0f);
        }
    }
}

