/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs;

import de.namensammler.cosmicnpcs.core.init.ArgumentTypesInit;
import de.namensammler.cosmicnpcs.core.init.ConfigInit;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.init.KeybindsInit;
import de.namensammler.cosmicnpcs.core.networking.CosmicNPCsMessages;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCFolderPack;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cosmicnpcs")
public class CosmicNPCs {
    public static CosmicNPCs instance;
    public static final Logger LOGGER;
    public static final String MODID = "cosmicnpcs";
    public static String[] storedCommands;
    public static int commandCounter;
    public Map<Player, NPCRecorder> recordThreads = Collections.synchronizedMap(new HashMap());

    public CosmicNPCs() {
        instance = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        EntityTypesInit.ENTITY_TYPES.register(bus);
        ArgumentTypesInit.ARGUMENT_TYPES.register(bus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addPackFinders);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigInit.common_config);
        ConfigInit.loadConfig(ConfigInit.common_config, FMLPaths.CONFIGDIR.get().resolve("cosmicnpcs-common.toml").toString());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CosmicNPCsMessages.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CosmicNPCs.loadCommandData();
    }

    private void serverSetup(FMLDedicatedServerSetupEvent event) {
        ConfigInit.disableSystemMessages.set((Object)false);
    }

    private void registerAttributes(EntityAttributeCreationEvent event) {
        EntityTypesInit.registerAttributes(event);
    }

    private void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            Pack.Info packInfo = new Pack.Info(NPCFolderPack.DESCRIPTION, 12, 12, PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of(), false);
            Pack pack = Pack.create((String)"npctextures", (Component)NPCFolderPack.DESCRIPTION, (boolean)true, (Pack.ResourcesSupplier)new NPCFolderPack.NPCResourcesSupplier(), (Pack.Info)packInfo, (Pack.Position)Pack.Position.BOTTOM, (boolean)true, (PackSource)PackSource.BUILT_IN);
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }

    public static void safeCommandData() {
        CompoundTag data = new CompoundTag();
        data.putInt("counter", commandCounter);
        data.put("commands", (Tag)new CompoundTag());
        for (int i = 0; i < storedCommands.length; ++i) {
            if (storedCommands[i] == null) continue;
            data.getCompound("commands").putString("cmd_" + i, storedCommands[i]);
        }
        File file = new File("config/cosmicnpcs/commands.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            NbtIo.writeCompressed((CompoundTag)data, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
    }

    public static void loadCommandData() {
        CompoundTag data = new CompoundTag();
        try {
            data = NbtIo.readCompressed((File)new File("config/cosmicnpcs/commands.dat"));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
        if (data.getInt("counter") != 0) {
            commandCounter = data.getInt("counter");
        }
        for (int i = 0; i < 99; ++i) {
            CosmicNPCs.storedCommands[i] = data.getCompound("commands").getString("cmd_" + i);
        }
    }

    public List<NPCAction> getActionListForPlayer(Player ep) {
        NPCRecorder aRecorder = this.recordThreads.get(ep);
        if (aRecorder == null) {
            return null;
        }
        return aRecorder.eventsList;
    }

    public void broadcastMsg(String msg) {
        List temp = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
        for (ServerPlayer player : temp) {
            MutableComponent cmp = Component.literal((String)("[CosmicNPCs]: " + msg));
            player.sendSystemMessage((Component)cmp);
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        storedCommands = new String[99];
        commandCounter = 1;
    }

    @Mod.EventBusSubscriber(modid="cosmicnpcs", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            KeybindsInit.register(event);
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            EntityTypesInit.registerEntityRenderers(event);
        }
    }
}

