/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CCommandSuggestionHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final Style EMPTY_ERROR_STYLE = Style.EMPTY.withColor(ChatFormatting.RED);
    private static final Style EMPTY_PASS_STYLE = Style.EMPTY.withColor(ChatFormatting.GRAY);
    private static final List<Style> COMMAND_COLOR_STYLES = (List)Stream.of(ChatFormatting.AQUA, ChatFormatting.YELLOW, ChatFormatting.GREEN, ChatFormatting.LIGHT_PURPLE, ChatFormatting.GOLD).map(arg_0 -> ((Style)Style.EMPTY).withColor(arg_0)).collect(ImmutableList.toImmutableList());
    private final Minecraft mc;
    private final Screen screen;
    private final EditBox inputField;
    private final Font font;
    private final boolean commandsOnly;
    private final boolean hasCursor;
    private final int minAmountRendered;
    private final int maxAmountRendered;
    private final boolean isChat;
    private final int color;
    private final List<FormattedCharSequence> exceptionList = Lists.newArrayList();
    private int x;
    private int width;
    private ParseResults<SharedSuggestionProvider> parseResults;
    private CompletableFuture<com.mojang.brigadier.suggestion.Suggestions> suggestionsFuture;
    private Suggestions suggestions;
    private boolean autoSuggest;
    private boolean isApplyingSuggestion;
    private int yPos;

    public CCommandSuggestionHelper(Minecraft mc, Screen screen, EditBox inputField, Font font, boolean commandsOnly, boolean hasCursor, int minAmountRendered, int maxAmountRendered, int yPos, int color) {
        this.mc = mc;
        this.screen = screen;
        this.inputField = inputField;
        this.font = font;
        this.commandsOnly = commandsOnly;
        this.hasCursor = hasCursor;
        this.minAmountRendered = minAmountRendered;
        this.maxAmountRendered = maxAmountRendered;
        this.isChat = false;
        this.yPos = yPos;
        this.color = color;
        inputField.setFormatter(this::getParsedSuggestion);
    }

    public void shouldAutoSuggest(boolean autoSuggest) {
        this.autoSuggest = autoSuggest;
        if (!autoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions != null && this.suggestions.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.screen.getFocused() == this.inputField && keyCode == 258) {
            this.updateSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean onScroll(double delta) {
        return this.suggestions != null && this.suggestions.onScroll(Mth.clamp((double)delta, (double)-1.0, (double)1.0));
    }

    public boolean onClick(double mouseX, double mouseY, int mouseButton) {
        return this.suggestions != null && this.suggestions.onClick((int)mouseX, (int)mouseY, mouseButton);
    }

    public void updateSuggestions(boolean narrateFirstSuggestion) {
        com.mojang.brigadier.suggestion.Suggestions suggestions;
        if (this.suggestionsFuture != null && this.suggestionsFuture.isDone() && !(suggestions = this.suggestionsFuture.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.width(suggestion.getText()));
            }
            int j = Mth.clamp((int)this.inputField.getScreenX(suggestions.getRange().getStart()), (int)0, (int)(this.inputField.getScreenX(0) + this.inputField.getInnerWidth() - i));
            int k = this.yPos;
            this.suggestions = new Suggestions(j, k, i, this.getSuggestions(suggestions), narrateFirstSuggestion);
        }
    }

    private List<Suggestion> getSuggestions(com.mojang.brigadier.suggestion.Suggestions suggestions) {
        String s = this.inputField.getValue().substring(0, this.inputField.getCursorPosition());
        int i = CCommandSuggestionHelper.getLastWhitespace(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void init() {
        boolean flag;
        String s = this.inputField.getValue();
        if (this.parseResults != null && !this.parseResults.getReader().getString().equals(s)) {
            this.parseResults = null;
        }
        if (!this.isApplyingSuggestion) {
            this.inputField.setSuggestion((String)null);
            this.suggestions = null;
        }
        this.exceptionList.clear();
        StringReader stringreader = new StringReader(s);
        boolean bl = flag = stringreader.canRead() && stringreader.peek() == '/';
        if (flag) {
            stringreader.skip();
        }
        boolean flag1 = this.commandsOnly || flag;
        int i = this.inputField.getCursorPosition();
        if (flag1) {
            int j;
            CommandDispatcher commanddispatcher = this.mc.player.connection.getCommands();
            if (this.parseResults == null) {
                this.parseResults = commanddispatcher.parse(stringreader, (Object)this.mc.player.connection.getSuggestionsProvider());
            }
            int n = j = this.hasCursor ? stringreader.getCursor() : 1;
            if (!(i < j || this.suggestions != null && this.isApplyingSuggestion)) {
                this.suggestionsFuture = commanddispatcher.getCompletionSuggestions(this.parseResults, i);
                this.suggestionsFuture.thenRun(() -> {
                    if (this.suggestionsFuture.isDone()) {
                        this.recompileSuggestions();
                    }
                });
            }
        } else {
            String s1 = s.substring(0, i);
            int k = CCommandSuggestionHelper.getLastWhitespace(s1);
            Collection collection = this.mc.player.connection.getSuggestionsProvider().getOnlinePlayerNames();
            this.suggestionsFuture = SharedSuggestionProvider.suggest((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(s1, k));
        }
    }

    private static int getLastWhitespace(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static FormattedCharSequence parseException(CommandSyntaxException exception) {
        Component itextcomponent = ComponentUtils.fromMessage((Message)exception.getRawMessage());
        String s = exception.getContext();
        return s == null ? itextcomponent.getVisualOrderText() : Component.translatable((String)"command.context.parse_error", (Object[])new Object[]{itextcomponent, exception.getCursor(), s}).getVisualOrderText();
    }

    private void recompileSuggestions() {
        if (this.inputField.getCursorPosition() == this.inputField.getValue().length()) {
            if (this.suggestionsFuture.join().isEmpty() && !this.parseResults.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.parseResults.getExceptions().entrySet()) {
                    CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)((Object)entry.getValue());
                    if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(commandsyntaxexception));
                }
                if (i > 0) {
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.parseResults.getReader().canRead()) {
                this.exceptionList.add(CCommandSuggestionHelper.parseException(Commands.getParseException(this.parseResults)));
            }
        }
        this.x = 0;
        this.width = this.screen.width;
        if (this.exceptionList.isEmpty()) {
            this.applyFormattingToCommand(ChatFormatting.GRAY);
        }
        this.suggestions = null;
        if (this.autoSuggest && ((Boolean)this.mc.options.autoSuggestions().get()).booleanValue()) {
            this.updateSuggestions(false);
        }
    }

    private void applyFormattingToCommand(ChatFormatting formatting) {
        CommandContextBuilder commandcontextbuilder = this.parseResults.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.inputField.getCursorPosition());
        Map map = this.mc.player.connection.getCommands().getSmartUsage(suggestioncontext.parent, (Object)this.mc.player.connection.getSuggestionsProvider());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        Style style = Style.EMPTY.withColor(formatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(FormattedCharSequence.forward((String)((String)entry.getValue()), (Style)style));
            i = Math.max(i, this.font.width((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.exceptionList.addAll(list);
            this.x = Mth.clamp((int)this.inputField.getScreenX(suggestioncontext.startPos), (int)0, (int)(this.inputField.getScreenX(0) + this.inputField.getInnerWidth() - i));
            this.width = i;
        }
    }

    private FormattedCharSequence getParsedSuggestion(String command, int maxLength) {
        return this.parseResults != null ? CCommandSuggestionHelper.getFinalSuggestion(this.parseResults, command, maxLength) : FormattedCharSequence.forward((String)command, (Style)Style.EMPTY);
    }

    @Nullable
    private static String getMatchedSuggestionText(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    private static FormattedCharSequence getFinalSuggestion(ParseResults<SharedSuggestionProvider> provider, String command, int maxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = provider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= COMMAND_COLOR_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - maxLength, 0)) >= command.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - maxLength, command.length());
            if (l <= 0) continue;
            list.add(FormattedCharSequence.forward((String)command.substring(i, k), (Style)EMPTY_PASS_STYLE));
            list.add(FormattedCharSequence.forward((String)command.substring(k, l), (Style)COMMAND_COLOR_STYLES.get(j)));
            i = l;
        }
        if (provider.getReader().canRead() && (i1 = Math.max(provider.getReader().getCursor() - maxLength, 0)) < command.length()) {
            int j1 = Math.min(i1 + provider.getReader().getRemainingLength(), command.length());
            list.add(FormattedCharSequence.forward((String)command.substring(i, i1), (Style)EMPTY_PASS_STYLE));
            list.add(FormattedCharSequence.forward((String)command.substring(i1, j1), (Style)EMPTY_ERROR_STYLE));
            i = j1;
        }
        list.add(FormattedCharSequence.forward((String)command.substring(i), (Style)EMPTY_PASS_STYLE));
        return FormattedCharSequence.composite((List)list);
    }

    public void drawSuggestionList(GuiGraphics guigraphics, int mouseX, int mouseY) {
        if (this.suggestions != null) {
            this.suggestions.drawSuggestions(guigraphics, mouseX, mouseY);
        } else {
            int i = 0;
            for (FormattedCharSequence FormattedCharSequence2 : this.exceptionList) {
                int j = this.yPos + 12 * i;
                ++i;
            }
        }
    }

    public String getSuggestionMessage() {
        return this.suggestions != null ? "\n" + this.suggestions.getCurrentSuggestionMessage() : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public class Suggestions {
        private final Rect2i suggestionRenderBox;
        private final String originalInputText;
        private final List<Suggestion> suggestions;
        private int lowestDisplayedSuggestionIndex;
        private int selectedIndex;
        private Vec2 lastMousePosition = Vec2.ZERO;
        private boolean changeSelectionOnNextTabInput;
        private int lastObtainedSuggestionMessageIndex;

        private Suggestions(int x, int y, int width, List<Suggestion> suggestions, boolean narrateFirstSuggestion) {
            int i = x - 1;
            int j = CCommandSuggestionHelper.this.isChat ? y - 3 - Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12 : y;
            this.suggestionRenderBox = new Rect2i(i, j, width + 1, Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12);
            this.originalInputText = CCommandSuggestionHelper.this.inputField.getValue();
            this.lastObtainedSuggestionMessageIndex = narrateFirstSuggestion ? -1 : 0;
            this.suggestions = suggestions;
            this.selectSuggestion(0);
        }

        public void drawSuggestions(GuiGraphics guigraphics, int mouseX, int mouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered);
            int j = -5592406;
            boolean flag = this.lowestDisplayedSuggestionIndex > 0;
            boolean flag1 = this.suggestions.size() > this.lowestDisplayedSuggestionIndex + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMousePosition.x != (float)mouseX || this.lastMousePosition.y != (float)mouseY;
            if (flag3) {
                this.lastMousePosition = new Vec2((float)mouseX, (float)mouseY);
            }
            if (flag2) {
                guigraphics.fill(this.suggestionRenderBox.getX(), this.suggestionRenderBox.getY() - 1, this.suggestionRenderBox.getX() + this.suggestionRenderBox.getWidth(), this.suggestionRenderBox.getY(), CCommandSuggestionHelper.this.color);
                guigraphics.fill(this.suggestionRenderBox.getX(), this.suggestionRenderBox.getY() + this.suggestionRenderBox.getHeight(), this.suggestionRenderBox.getX() + this.suggestionRenderBox.getWidth(), this.suggestionRenderBox.getY() + this.suggestionRenderBox.getHeight() + 1, CCommandSuggestionHelper.this.color);
                if (flag) {
                    for (int k = 0; k < this.suggestionRenderBox.getWidth(); ++k) {
                        if (k % 2 != 0) continue;
                        guigraphics.fill(this.suggestionRenderBox.getX() + k, this.suggestionRenderBox.getY() - 1, this.suggestionRenderBox.getX() + k + 1, this.suggestionRenderBox.getY(), -1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.suggestionRenderBox.getWidth(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        guigraphics.fill(this.suggestionRenderBox.getX() + i1, this.suggestionRenderBox.getY() + this.suggestionRenderBox.getHeight(), this.suggestionRenderBox.getX() + i1 + 1, this.suggestionRenderBox.getY() + this.suggestionRenderBox.getHeight() + 1, -1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestions.get(l + this.lowestDisplayedSuggestionIndex);
                guigraphics.fill(this.suggestionRenderBox.getX(), this.suggestionRenderBox.getY() + 12 * l, this.suggestionRenderBox.getX() + this.suggestionRenderBox.getWidth(), this.suggestionRenderBox.getY() + 12 * l + 12, CCommandSuggestionHelper.this.color);
                if (mouseX > this.suggestionRenderBox.getX() && mouseX < this.suggestionRenderBox.getX() + this.suggestionRenderBox.getWidth() && mouseY > this.suggestionRenderBox.getY() + 12 * l && mouseY < this.suggestionRenderBox.getY() + 12 * l + 12) {
                    if (flag3) {
                        this.selectSuggestion(l + this.lowestDisplayedSuggestionIndex);
                    }
                    flag4 = true;
                }
                guigraphics.drawString(CCommandSuggestionHelper.this.font, suggestion.getText(), this.suggestionRenderBox.getX() + 1, this.suggestionRenderBox.getY() + 2 + 12 * l, l + this.lowestDisplayedSuggestionIndex == this.selectedIndex ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestions.get(this.selectedIndex).getTooltip()) != null) {
                guigraphics.renderTooltip(CCommandSuggestionHelper.this.font, ComponentUtils.fromMessage((Message)message), mouseX, mouseY);
            }
        }

        public boolean onClick(int mouseX, int mouseY, int mouseButton) {
            if (!this.suggestionRenderBox.contains(mouseX, mouseY)) {
                return false;
            }
            int i = (mouseY - this.suggestionRenderBox.getY()) / 12 + this.lowestDisplayedSuggestionIndex;
            if (i >= 0 && i < this.suggestions.size()) {
                this.selectSuggestion(i);
                this.applySuggestionToInput();
            }
            return true;
        }

        public boolean onScroll(double delta) {
            int j;
            int i = (int)(CCommandSuggestionHelper.this.mc.mouseHandler.xpos() * (double)CCommandSuggestionHelper.this.mc.getWindow().getGuiScaledWidth() / (double)CCommandSuggestionHelper.this.mc.getWindow().getScreenWidth());
            if (this.suggestionRenderBox.contains(i, j = (int)(CCommandSuggestionHelper.this.mc.mouseHandler.ypos() * (double)CCommandSuggestionHelper.this.mc.getWindow().getGuiScaledHeight() / (double)CCommandSuggestionHelper.this.mc.getWindow().getScreenHeight()))) {
                this.lowestDisplayedSuggestionIndex = Mth.clamp((int)((int)((double)this.lowestDisplayedSuggestionIndex - delta)), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
                return true;
            }
            return false;
        }

        public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                this.changeSelection(-1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 264) {
                this.changeSelection(1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 258) {
                if (this.changeSelectionOnNextTabInput) {
                    this.changeSelection(Screen.hasShiftDown() ? -1 : 1);
                }
                this.applySuggestionToInput();
                return true;
            }
            if (keyCode == 256) {
                this.clearSuggestions();
                return true;
            }
            return false;
        }

        public void changeSelection(int change) {
            this.selectSuggestion(this.selectedIndex + change);
            int i = this.lowestDisplayedSuggestionIndex;
            int j = this.lowestDisplayedSuggestionIndex + CCommandSuggestionHelper.this.maxAmountRendered - 1;
            if (this.selectedIndex < i) {
                this.lowestDisplayedSuggestionIndex = Mth.clamp((int)this.selectedIndex, (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            } else if (this.selectedIndex > j) {
                this.lowestDisplayedSuggestionIndex = Mth.clamp((int)(this.selectedIndex + CCommandSuggestionHelper.this.minAmountRendered - CCommandSuggestionHelper.this.maxAmountRendered), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            }
        }

        public void selectSuggestion(int index) {
            this.selectedIndex = index;
            if (this.selectedIndex < 0) {
                this.selectedIndex += this.suggestions.size();
            }
            if (this.selectedIndex >= this.suggestions.size()) {
                this.selectedIndex -= this.suggestions.size();
            }
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.inputField.setSuggestion(CCommandSuggestionHelper.getMatchedSuggestionText(CCommandSuggestionHelper.this.inputField.getValue(), suggestion.apply(this.originalInputText)));
            if (CCommandSuggestionHelper.this.mc.getNarrator().isActive() && this.lastObtainedSuggestionMessageIndex != this.selectedIndex) {
                CCommandSuggestionHelper.this.mc.getNarrator().sayNow(this.getCurrentSuggestionMessage());
            }
        }

        public void applySuggestionToInput() {
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = true;
            CCommandSuggestionHelper.this.inputField.setValue(suggestion.apply(this.originalInputText));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            CCommandSuggestionHelper.this.inputField.setCursorPosition(i);
            CCommandSuggestionHelper.this.inputField.setHighlightPos(i);
            this.selectSuggestion(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = false;
            this.changeSelectionOnNextTabInput = true;
        }

        private Component getCurrentSuggestionMessage() {
            this.lastObtainedSuggestionMessageIndex = this.selectedIndex;
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            Message message = suggestion.getTooltip();
            return message != null ? Component.translatable((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText(), message.getString()}) : Component.translatable((String)"narration.suggestion", (Object[])new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText()});
        }

        public void clearSuggestions() {
            CCommandSuggestionHelper.this.suggestions = null;
        }
    }
}

