/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.client.gui.CCommandSuggestionHelper;
import de.namensammler.cosmicnpcs.client.gui.button.CCheckboxButton;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class CommandScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("cosmicnpcs:textures/gui/command_screen.png");
    private static final int TEXTURE_WIDTH = 176;
    private static final int TEXTURE_HEIGHT = 83;
    public static int page = 1;
    protected Button doneButton;
    protected Button prevPageButton;
    protected Button nextPageButton;
    protected Button clearPageButton;
    protected CCheckboxButton startHereButton;
    protected EditBox textField;
    private CCommandSuggestionHelper suggestionHelper;

    public CommandScreen(Component titleIn) {
        super(titleIn);
    }

    public void tick() {
        if (CosmicNPCs.commandCounter == page) {
            this.startHereButton.setChecked(true);
        } else {
            this.startHereButton.setChecked(false);
        }
        this.nextPageButton.active = page != 99;
        this.prevPageButton.active = page != 1;
        if (this.textField.isFocused()) {
            this.setFocused((GuiEventListener)this.textField);
        }
    }

    protected void init() {
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.done"), button -> {
            CosmicNPCs.storedCommands[CommandScreen.page - 1] = this.textField.getValue();
            this.minecraft.setScreen((Screen)null);
        }).bounds(this.width / 2 - 25, 147, 50, 20).build());
        this.prevPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)"<"), button -> {
            CosmicNPCs.storedCommands[CommandScreen.page - 1] = this.textField.getValue();
            if (page > 1) {
                this.textField.setValue(CosmicNPCs.storedCommands[--page - 1]);
            }
        }).bounds(this.width / 2 - 80, 147, 20, 20).build());
        this.nextPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.literal((String)">"), button -> {
            CosmicNPCs.storedCommands[CommandScreen.page - 1] = this.textField.getValue();
            if (page < 99) {
                this.textField.setValue(CosmicNPCs.storedCommands[++page - 1]);
            }
        }).bounds(this.width / 2 + 60, 147, 20, 20).build());
        this.clearPageButton = (Button)this.addRenderableWidget((GuiEventListener)new Button.Builder((Component)Component.translatable((String)"gui.command_screen.clear_button"), button -> {
            this.textField.setValue("");
            if (CommandScreen.hasControlDown()) {
                for (int i = 0; i < 99; ++i) {
                    CosmicNPCs.storedCommands[i] = "";
                }
                CosmicNPCs.commandCounter = 1;
            }
        }).bounds(this.width / 2 + 52, 94, 32, 11).build());
        this.startHereButton = (CCheckboxButton)this.addRenderableWidget((GuiEventListener)new CCheckboxButton(this.width / 2 - 80, 132, (Component)Component.translatable((String)""), CosmicNPCs.commandCounter == page));
        this.textField = new EditBox(this.font, this.width / 2 - 83, 107, 166, 20, (Component)Component.translatable((String)"gui.command_screen.textfield")){

            protected MutableComponent createNarrationMessage() {
                return super.createNarrationMessage().append(CommandScreen.this.suggestionHelper.getSuggestionMessage());
            }
        };
        this.addWidget((GuiEventListener)this.textField);
        this.textField.setMaxLength(32500);
        this.textField.setResponder(this::onEdited);
        this.suggestionHelper = new CCommandSuggestionHelper(this.minecraft, this, this.textField, this.font, true, true, 0, 7, 128, Integer.MIN_VALUE);
        this.suggestionHelper.init();
        this.textField.setValue(CosmicNPCs.storedCommands[page - 1]);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.textField.getValue();
        this.init(minecraft, width, height);
        this.textField.setValue(s);
        this.suggestionHelper.init();
    }

    public void render(GuiGraphics guigraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guigraphics);
        super.render(guigraphics, mouseX, mouseY, partialTicks);
        int pageCountPosX = this.width / 2 - 9;
        if (page >= 10) {
            pageCountPosX -= 3;
        }
        guigraphics.drawString(this.font, Component.translatable((String)("-" + page + "-")).getString(), pageCountPosX, 132, 0, false);
        guigraphics.drawString(this.font, Component.translatable((String)"gui.command_screen").getString(), this.width / 2 - 36, 96, 0, false);
        this.textField.render(guigraphics, mouseX, mouseY, partialTicks);
        this.suggestionHelper.drawSuggestionList(guigraphics, mouseX, mouseY);
        if (this.clearPageButton.isHoveredOrFocused() && CommandScreen.hasControlDown()) {
            guigraphics.drawCenteredString(this.font, "Clear All", this.width / 2 + 68, 84, Color.RED.getRGB());
        }
    }

    public void renderTransparentBackground(GuiGraphics guigraphics) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_LOCATION);
        int i = (this.width - 176) / 2;
        int j = 90;
        guigraphics.blit(BACKGROUND_LOCATION, i, j, 0, 0, 176, 83);
    }

    public void removed() {
        CosmicNPCs.safeCommandData();
        page = 1;
    }

    private void onEdited(String p_214185_1_) {
        this.suggestionHelper.init();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggestionHelper.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return keyCode == 257 || keyCode == 335;
    }

    public boolean mouseScrolled(double p_94686_, double p_94687_, double p_94688_, double delta) {
        return this.suggestionHelper.onScroll(delta) ? true : super.mouseScrolled(p_94686_, p_94687_, p_94688_, delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.suggestionHelper.onClick(mouseX, mouseY, button) ? true : super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

