/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cpw.mods.modlauncher.api.INameMappingService;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class CustomLivingRenderer
extends LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> {
    CosmicNPCEntity npc;
    public float modelShadowSize;

    public CustomLivingRenderer(EntityRendererProvider.Context rendererManager, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> modelEntityRenderer, CosmicNPCEntity npc, List<RenderLayer<LivingEntity, EntityModel<LivingEntity>>> layerList) {
        super(rendererManager, modelEntityRenderer.getModel(), 0.5f);
        this.npc = npc;
        for (int i = 0; i < layerList.size(); ++i) {
            this.addLayer(layerList.get(i));
        }
    }

    public ResourceLocation getTextureLocation(LivingEntity entity) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/main/" + this.npc.getTextureName() + ".png");
        if (this.npc.getTextureName() != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/main/" + this.npc.getTextureName() + ".png");
        }
        return this.entityRenderDispatcher.getRenderer((Entity)entity).getTextureLocation((Entity)entity);
    }

    public void render(LivingEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Direction direction;
        boolean shouldSit;
        LivingEntityRenderer modelRenderer = (LivingEntityRenderer)this.entityRenderDispatcher.getRenderer((Entity)entityIn);
        matrixStackIn.pushPose();
        this.model.attackTime = this.getAttackAnim(entityIn, partialTicks);
        boolean isChild = this.npc.getSettings().getBoolean("IsChild");
        this.model.riding = shouldSit = entityIn.isPassenger() && entityIn.getVehicle() != null && entityIn.getVehicle().shouldRiderSit();
        this.model.young = isChild;
        float f = Mth.rotLerp((float)partialTicks, (float)entityIn.yBodyRotO, (float)entityIn.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)entityIn.yHeadRotO, (float)entityIn.yHeadRot);
        float f2 = f1 - f;
        if (shouldSit && entityIn.getVehicle() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.getVehicle();
            f = Mth.rotLerp((float)partialTicks, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot());
        if (entityIn.getPose() == Pose.SLEEPING && (direction = entityIn.getBedOrientation()) != null) {
            float f4 = entityIn.getEyeHeight(Pose.STANDING) - 0.1f;
            matrixStackIn.translate((double)((float)(-direction.getStepX()) * f4), 0.0, (double)((float)(-direction.getStepZ()) * f4));
        }
        float f7 = (float)entityIn.tickCount + partialTicks;
        try {
            Method handleRotationFloatMethod = modelRenderer.getClass().getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"getBob"), entityIn.getClass(), Float.TYPE);
            handleRotationFloatMethod.setAccessible(true);
            f7 = ((Float)handleRotationFloatMethod.invoke((Object)modelRenderer, entityIn, Float.valueOf(partialTicks))).floatValue();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException handleRotationFloatMethod) {
            // empty catch block
        }
        try {
            Method applyRotationsMethod = modelRenderer.getClass().getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"setupRotations"), entityIn.getClass(), PoseStack.class, Float.TYPE, Float.TYPE, Float.TYPE);
            applyRotationsMethod.setAccessible(true);
            applyRotationsMethod.invoke((Object)modelRenderer, entityIn, matrixStackIn, Float.valueOf(f7), Float.valueOf(f), Float.valueOf(partialTicks));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.setupRotations(entityIn, matrixStackIn, f7, f, partialTicks);
        }
        matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
        try {
            Method preRenderCallbackMethod = modelRenderer.getClass().getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"scale"), entityIn.getClass(), PoseStack.class, Float.TYPE);
            preRenderCallbackMethod.setAccessible(true);
            preRenderCallbackMethod.invoke((Object)modelRenderer, entityIn, matrixStackIn, Float.valueOf(partialTicks));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException preRenderCallbackMethod) {
            // empty catch block
        }
        matrixStackIn.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.isAlive()) {
            f8 = entityIn.walkAnimation.speed(partialTicks);
            f5 = entityIn.walkAnimation.position(partialTicks);
            if (isChild) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        this.model.prepareMobModel((Entity)entityIn, f5, f8, partialTicks);
        this.model.setupAnim((Entity)entityIn, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible(entityIn);
        boolean flag1 = !flag && !entityIn.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)entityIn);
        RenderType rendertype = this.getRenderType(entityIn, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(rendertype);
            int i = CustomLivingRenderer.getOverlayCoords((LivingEntity)entityIn, (float)this.getWhiteOverlayProgress(entityIn, partialTicks));
            this.model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!entityIn.isSpectator()) {
            for (RenderLayer layerrenderer : this.layers) {
                layerrenderer.render(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.popPose();
        if (this.shouldShowName(entityIn)) {
            this.renderNameTag((Entity)entityIn, entityIn.getDisplayName(), matrixStackIn, bufferIn, packedLightIn);
        }
    }

    protected boolean shouldShowName(LivingEntity entity) {
        return super.shouldShowName(entity) && (entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity);
    }
}

