/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.math.NumberUtils;

@OnlyIn(value=Dist.CLIENT)
public class CLeatherHorseArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<Horse, HorseModel<Horse>> {
    private final HorseModel<Horse> model;
    private ItemStack armor;
    private int color;

    public CLeatherHorseArmorLayer(RenderLayerParent<Horse, HorseModel<Horse>> p_i232476_1_, EntityModelSet modelSet, CosmicNPCEntity npc) {
        super(p_i232476_1_);
        this.model = new HorseModel(modelSet.bakeLayer(ModelLayers.HORSE_ARMOR));
        String armorString = npc.getSettings().getString("Armor");
        this.armor = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(armorString)));
        String colorString = npc.getSettings().getString("Color");
        this.color = NumberUtils.toInt((String)colorString);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Horse entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = this.armor;
        if (itemstack.getItem() instanceof HorseArmorItem) {
            float f2;
            float f1;
            float f;
            HorseArmorItem horsearmoritem = (HorseArmorItem)itemstack.getItem();
            ((HorseModel)this.getParentModel()).copyPropertiesTo(this.model);
            this.model.prepareMobModel((AbstractHorse)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.model.setupAnim((AbstractHorse)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (horsearmoritem instanceof DyeableHorseArmorItem && this.color != 0) {
                int i = this.color;
                f = (float)(i >> 16 & 0xFF) / 255.0f;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                f2 = (float)(i & 0xFF) / 255.0f;
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)horsearmoritem.getTexture()));
            this.model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, f, f1, f2, 1.0f);
        }
    }
}

