/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CSnowmanHeadLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<SnowGolem, SnowGolemModel<SnowGolem>> {
    private ItemStack headBlock;

    public CSnowmanHeadLayer(RenderLayerParent<SnowGolem, SnowGolemModel<SnowGolem>> p_i50922_1_, CosmicNPCEntity npc) {
        super(p_i50922_1_);
        String head = npc.getSettings().getString("Head");
        this.headBlock = new ItemStack((ItemLike)Blocks.CARVED_PUMPKIN);
        if (!head.equals("default")) {
            this.headBlock = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(head)));
        }
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, SnowGolem entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.isInvisible() && this.headBlock != ItemStack.EMPTY) {
            matrixStackIn.pushPose();
            ((SnowGolemModel)this.getParentModel()).getHead().translateAndRotate(matrixStackIn);
            float f = 0.625f;
            matrixStackIn.translate(0.0, -0.34375, 0.0);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
            matrixStackIn.scale(0.625f, -0.625f, -0.625f);
            ItemStack itemstack = this.headBlock;
            Minecraft.getInstance().getItemRenderer().renderStatic((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.HEAD, false, matrixStackIn, bufferIn, entitylivingbaseIn.level(), packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)entitylivingbaseIn, (float)0.0f), entitylivingbaseIn.getId());
            matrixStackIn.popPose();
        }
    }
}

