/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.core.CCAPJson;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayTickThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class CCAPCommand {
    public CCAPCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ccap").requires(sender -> sender.hasPermission(2))).then(Commands.literal((String)"generate-json").then(Commands.argument((String)"rec-file", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.REC_FILES).executes(command -> this.generateJson((CommandContext<CommandSourceStack>)command)))));
    }

    public int generateJson(CommandContext<CommandSourceStack> context) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String fileName = StringArgumentType.getString(context, (String)"rec-file");
        File file = PlayTickThread.getRecFile((Level)((CommandSourceStack)context.getSource()).getLevel(), fileName);
        if (!file.exists()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Can't find " + fileName + ".ccap file!")));
            return 1;
        }
        String filePath = file.getPath().concat(".json");
        try {
            BufferedWriter writer = Files.newBufferedWriter(Paths.get(filePath, new String[0]), new OpenOption[0]);
            CCAPJson ccapJson = new CCAPJson();
            PlayTickThread player = new PlayTickThread((Level)((CommandSourceStack)context.getSource()).getLevel(), StringArgumentType.getString(context, (String)"rec-file"));
            player.readRecFile(Integer.MAX_VALUE);
            player.in.close();
            for (NPCAction action : player.ccapData.actionList) {
                if (action.type == 1) {
                    List<CCAPJson.Message> list = ccapJson.chatMessages;
                    CCAPJson cCAPJson = ccapJson;
                    Objects.requireNonNull(cCAPJson);
                    list.add(new CCAPJson.Message(cCAPJson, action.timeStamp, action.message));
                }
                if (action.type != 14) continue;
                List<CCAPJson.Message> list = ccapJson.commands;
                CCAPJson cCAPJson = ccapJson;
                Objects.requireNonNull(cCAPJson);
                list.add(new CCAPJson.Message(cCAPJson, action.timeStamp, action.message));
            }
            ccapJson.duration = (int)player.ticks;
            gson.toJson((Object)ccapJson, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

