/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.common.command.argument.CComponentArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntityArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class NPCModifyCommand {
    public NPCModifyCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modify-npc").requires(sender -> sender.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)CEntityArgument.entity()).then(Commands.literal((String)"settings").then(Commands.argument((String)"settings", (ArgumentType)CompoundTagArgument.compoundTag()).executes(command -> this.modifySetting((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"data").then(Commands.argument((String)"replay-data", (ArgumentType)CompoundTagArgument.compoundTag()).executes(command -> this.modifyReplayData((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"nbt").then(Commands.argument((String)"nbt", (ArgumentType)CompoundTagArgument.compoundTag()).executes(command -> this.modifyNBT((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"name").then(Commands.argument((String)"name", (ArgumentType)CComponentArgument.textComponent()).executes(command -> this.modifyName((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"texture").then(Commands.argument((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(command -> this.modifyTexture((CommandContext<CommandSourceStack>)command))))).then(Commands.literal((String)"model").then(Commands.argument((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(command -> this.modifyModel((CommandContext<CommandSourceStack>)command))))));
    }

    public int modifyName(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        Component name = CComponentArgument.getComponent(context, "name");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            npc.setNPCName(name);
            if (npc.hasCustomName()) {
                npc.setCustomName(npc.getNPCName());
            }
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyTexture(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        String texture = StringArgumentType.getString(context, (String)"texture");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            npc.setTextureName(texture);
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyModel(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        ResourceLocation model = CEntitySummonArgument.getEntityId(context, "model");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            npc.setModel(model);
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifySetting(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        CompoundTag newSettings = CompoundTagArgument.getCompoundTag(context, (String)"settings");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            CompoundTag oldSettings = npc.getSettings();
            oldSettings = oldSettings.merge(newSettings);
            npc.setSettings(new CompoundTag());
            npc.setSettings(oldSettings);
            this.updateNPCSettings(npc);
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyReplayData(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        CompoundTag newData = CompoundTagArgument.getCompoundTag(context, (String)"replay-data");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            CompoundTag oldData = npc.getReplayData();
            oldData = oldData.merge(newData);
            npc.setReplayData(new CompoundTag());
            npc.setReplayData(oldData.merge(newData));
        }
        this.sendFeedback(context);
        return 0;
    }

    public int modifyNBT(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        CompoundTag newNbt = CompoundTagArgument.getCompoundTag(context, (String)"nbt");
        if (entity != null && entity instanceof CosmicNPCEntity) {
            CosmicNPCEntity npc = (CosmicNPCEntity)entity;
            CompoundTag oldNbt = new CompoundTag();
            npc.addAdditionalSaveData(oldNbt);
            CompoundTag tag = oldNbt.merge(newNbt);
            npc.readAdditionalSaveData(new CompoundTag());
            npc.readAdditionalSaveData(tag);
            this.updateNPCSettings(npc);
        }
        this.sendFeedback(context);
        return 0;
    }

    private void sendFeedback(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"entity");
        if (!(entity instanceof CosmicNPCEntity)) {
            Player player;
            if (entity instanceof Player && CosmicNPCs.instance.recordThreads.get(player = (Player)entity) != null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"NPC-Data was modified"), false);
                return;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Command can only be used on NPCs"));
            return;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"NPC-Data was modified"), false);
    }

    private void updateNPCSettings(CosmicNPCEntity npc) {
        if (npc.getSettings().getInt("ShowNameTag") >= 1) {
            npc.setCustomName(npc.getNPCName());
        } else {
            npc.setCustomName(null);
        }
        if (npc.getSettings().getInt("ShowNameTag") == 1) {
            npc.setCustomNameVisible(true);
        } else {
            npc.setCustomNameVisible(false);
        }
        npc.setInvulnerable(npc.getSettings().getBoolean("Invulnerable"));
        npc.getAttribute(Attributes.MAX_HEALTH).setBaseValue(npc.getSettings().getDouble("Health"));
        if (npc.getMaxHealth() > npc.getHealth()) {
            npc.setHealth(npc.getMaxHealth());
        }
    }
}

