/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCRecorder;
import de.namensammler.cosmicnpcs.core.npcsystem.RecordThread;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NPCRecordCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"npc-rec").requires(sender -> sender.hasPermission(2))).then(Commands.argument((String)"file name", (ArgumentType)StringArgumentType.string()).executes(context -> NPCRecordCommand.record(StringArgumentType.getString((CommandContext)context, (String)"file name"), ((CommandSourceStack)context.getSource()).getPlayerOrException(), (CommandSourceStack)context.getSource())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int record(String fileNameIn, ServerPlayer player, CommandSourceStack source) {
        NPCRecorder aRecorder = CosmicNPCs.instance.recordThreads.get(player);
        if (aRecorder != null) {
            aRecorder.recordThread.capture = false;
            source.sendSuccess(() -> Component.literal((String)("Stopped recording " + player.getDisplayName().getString() + " to file " + aRecorder.fileName + ".ccap")), true);
            CosmicNPCs.instance.recordThreads.remove(player);
            return 1;
        }
        Map<Player, NPCRecorder> map = CosmicNPCs.instance.recordThreads;
        synchronized (map) {
            for (NPCRecorder ar : CosmicNPCs.instance.recordThreads.values()) {
                if (!ar.fileName.equals(fileNameIn.toLowerCase())) continue;
                source.sendFailure((Component)Component.literal((String)("'" + ar.fileName + ".ccap' is already being recorded to?")));
            }
        }
        if (aRecorder == null) {
            source.sendSuccess(() -> Component.literal((String)("Started recording " + player.getDisplayName().getString() + " to file " + fileNameIn + ".ccap")), true);
            NPCRecorder mcr = new NPCRecorder();
            mcr.fileName = fileNameIn.toLowerCase();
            CosmicNPCs.instance.recordThreads.put((Player)player, mcr);
            mcr.recordThread = new RecordThread((Player)player, fileNameIn);
            return 1;
        }
        return 0;
    }
}

