/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class SuggestionProviders {
    public static final SuggestionProvider<CommandSourceStack> REC_FILES = (context, builder) -> {
        File recFolder;
        Path path = ((CommandSourceStack)context.getSource()).getLevel().getServer().getWorldPath(new LevelResource("cosmicnpcs/recordings"));
        String command = context.getInput();
        String fileArgument = command.substring(command.indexOf(" ") + 1);
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<File> files1 = new ArrayList<File>();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            for (File file : SuggestionProviders.getAllFiles(files1, path.toFile())) {
                int index = file.getPath().indexOf("recordings") + 11;
                Object fileName = file.getPath().substring(index).replaceAll(".ccap", "").replaceAll(".json", "");
                if (((String)fileName).contains("/")) {
                    fileName = "'" + (String)fileName + "'";
                }
                files.add((String)fileName);
            }
        }
        if (!(recFolder = new File("" + path)).exists()) {
            recFolder.mkdirs();
        }
        return SharedSuggestionProvider.suggest(files, (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> TEXTURE_FILES = (context, builder) -> {
        File textureFolder = new File("config/cosmicnpcs/resources/textures/main");
        if (!textureFolder.exists()) {
            textureFolder.mkdir();
        }
        String[] filenames = textureFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".png");
            }
        });
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = filenames[i].replaceAll(".png", "");
        }
        ArrayList<String> models = new ArrayList<String>(Arrays.asList(filenames));
        models.add("default");
        return SharedSuggestionProvider.suggest(models, (SuggestionsBuilder)builder);
    };
    public static final SuggestionProvider<CommandSourceStack> NPC_MODELS = (context, builder) -> {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        models.add(new ResourceLocation("minecraft:player"));
        models.add(new ResourceLocation("minecraft:player_slim"));
        for (ResourceLocation location : BuiltInRegistries.ENTITY_TYPE.keySet()) {
            if (location.toString().equals("cosmicnpcs:cosmic_npc") || !(((EntityType)BuiltInRegistries.ENTITY_TYPE.get(location)).create((Level)((CommandSourceStack)context.getSource()).getLevel()) instanceof LivingEntity)) continue;
            models.add(location);
        }
        return SharedSuggestionProvider.suggestResource(models, (SuggestionsBuilder)builder);
    };

    public static ArrayList<File> getAllFiles(ArrayList<File> fileList, File mainFolder) {
        File[] files;
        for (File file : files = mainFolder.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            SuggestionProviders.getAllFiles(fileList, file);
        }
        return fileList;
    }
}

