/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import de.namensammler.cosmicnpcs.core.CCAPJson;
import de.namensammler.cosmicnpcs.core.init.ConfigInit;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayTickThread;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Crypt;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CosmicNPCEntity
extends LivingEntity {
    public static final EntityDimensions STANDING_DIMENSIONS = EntityDimensions.scalable((float)0.6f, (float)1.8f);
    private static final Map<Pose, EntityDimensions> POSES = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)STANDING_DIMENSIONS).put((Object)Pose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.scalable((float)0.6f, (float)1.5f)).put((Object)Pose.DYING, (Object)EntityDimensions.fixed((float)0.2f, (float)0.2f)).build();
    private static final EntityDataAccessor<Component> NPC_NAME = SynchedEntityData.defineId(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPONENT);
    private static final EntityDataAccessor<String> TEXTURE_NAME = SynchedEntityData.defineId(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> MODEL_NAME = SynchedEntityData.defineId(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> SETTINGS = SynchedEntityData.defineId(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<CompoundTag> REPLAY_DATA = SynchedEntityData.defineId(CosmicNPCEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public boolean isReplayActive;
    private FakePlayer fakePlayer;
    public Entity modelEntity;
    protected ItemStack lastActiveItemStack = ItemStack.EMPTY;
    public List<NPCAction> eventsList = Collections.synchronizedList(new ArrayList());
    public CCAPJson ccapJson = new CCAPJson();
    public final Inventory inventory = new Inventory((Player)this.fakePlayer);

    public CosmicNPCEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
        if (!this.level().isClientSide()) {
            this.fakePlayer = new FakePlayer((ServerLevel)this.level(), new GameProfile(this.uuid, "NPCFakePlayer"));
        }
        CompoundTag data = new CompoundTag();
        data.putInt("ReplaysCompleted", 0);
        data.putInt("TimelinePos", 0);
        data.putString("CurrentReplay", "");
        data.putString("NextReplay", "");
        this.entityData.define(NPC_NAME, (Object)Component.literal((String)"CosmicNPC"));
        this.entityData.define(TEXTURE_NAME, (Object)"default");
        this.entityData.define(MODEL_NAME, (Object)"minecraft:player");
        this.entityData.define(SETTINGS, (Object)new CompoundTag());
        this.entityData.define(REPLAY_DATA, (Object)data);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.ATTACK_SPEED).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_KNOCKBACK);
    }

    public void setNPCName(Component npcName) {
        if (npcName.getString().contains((CharSequence)ConfigInit.formatterChar.get())) {
            npcName = Component.literal((String)npcName.getString().replace((CharSequence)ConfigInit.formatterChar.get(), "\u00a7"));
        }
        this.entityData.set(NPC_NAME, (Object)npcName);
    }

    public Component getNPCName() {
        return (Component)this.entityData.get(NPC_NAME);
    }

    public void setTextureName(String textureName) {
        this.entityData.set(TEXTURE_NAME, (Object)textureName.toLowerCase(Locale.ROOT));
    }

    public String getTextureName() {
        return (String)this.entityData.get(TEXTURE_NAME);
    }

    public void setModel(ResourceLocation model) {
        this.entityData.set(MODEL_NAME, (Object)model.toString());
    }

    public ResourceLocation getModel() {
        return new ResourceLocation((String)this.entityData.get(MODEL_NAME));
    }

    public void setSettings(CompoundTag settings) {
        this.entityData.set(SETTINGS, (Object)settings);
    }

    public CompoundTag getSettings() {
        return (CompoundTag)this.entityData.get(SETTINGS);
    }

    public void setReplayData(CompoundTag data) {
        this.entityData.set(REPLAY_DATA, (Object)data);
    }

    public CompoundTag getReplayData() {
        return (CompoundTag)this.entityData.get(REPLAY_DATA);
    }

    public void setElytraFlying(boolean isElytraFlying) {
        this.setSharedFlag(7, isElytraFlying);
    }

    private void replayShootArrow(NPCAction ma) {
        float f = (float)ma.arrowCharge / 20.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        ArrowItem arrow = (ArrowItem)new ItemStack((ItemLike)Items.ARROW).getItem();
        AbstractArrow entityarrow = arrow.createArrow(this.level(), this.getUseItem(), (LivingEntity)this);
        entityarrow.shootFromRotation((Entity)this, this.getXRot(), this.getYRot(), 0.0f, f * 3.0f, 1.0f);
        if (f == 1.0f) {
            entityarrow.setCritArrow(true);
        }
        this.level().addFreshEntity((Entity)entityarrow);
        this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 1.0f, 1.0f / (this.random.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
    }

    private void sendChatMessage(String message) {
        List temp = ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers();
        for (ServerPlayer player : temp) {
            MutableComponent prefix = Component.translatable((String)this.getSettings().getString("ChatPrefix").replace((CharSequence)ConfigInit.formatterChar.get(), "\u00a7"), (Object[])new Object[]{this.getNPCName()});
            prefix.append(message);
            if (((Boolean)ConfigInit.disableSystemMessages.get()).booleanValue()) {
                try {
                    SignedMessageChain.Decoder decoder = SignedMessageChain.Decoder.unsigned((UUID)player.getUUID());
                    PlayerChatMessage playerMsg = decoder.unpack(null, new SignedMessageBody(prefix.getString(), Instant.now(), Crypt.SaltSupplier.getLong(), LastSeenMessages.EMPTY));
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.CHAT_TYPE, (ResourceLocation)new ResourceLocation("cosmicnpcs", "cchat"));
                    ChatType.Bound chatType = ((ChatType)player.level().registryAccess().registryOrThrow(Registries.CHAT_TYPE).getOrThrow(key)).bind((Component)Component.empty());
                    player.sendChatMessage(OutgoingChatMessage.create((PlayerChatMessage)playerMsg), false, chatType);
                }
                catch (SignedMessageChain.DecodeException e) {
                    e.printStackTrace();
                }
                continue;
            }
            player.sendSystemMessage((Component)prefix);
        }
    }

    private void executeCommand(String message) {
        if (this.getSettings().getBoolean("UseCommands") || message.startsWith("/modify-npc")) {
            this.getServer().getCommands().performPrefixedCommand(this.createCommandSourceStack().withSuppressedOutput().withPermission(2), message);
        }
    }

    private void processActions(NPCAction ma) {
        switch (ma.type) {
            case 1: {
                this.sendChatMessage(ma.message);
                break;
            }
            case 2: {
                this.swing(InteractionHand.MAIN_HAND);
                LivingEntity mop = this.GetTargetEntityLiving(5);
                if (mop == null) break;
                this.doHurtTarget((Entity)mop);
                this.attack((Entity)mop);
                break;
            }
            case 4: {
                if (ma.armorId == -1) {
                    this.setItemSlot(this.getEquipmentSlotById(ma.armorSlot), ItemStack.EMPTY);
                    break;
                }
                ItemStack loadedEquip = ItemStack.of((CompoundTag)ma.itemData);
                this.setItemSlot(this.getEquipmentSlotById(ma.armorSlot), loadedEquip);
                break;
            }
            case 3: {
                ItemStack droppedItem = ItemStack.of((CompoundTag)ma.itemData);
                double d0 = this.getEyeY() - (double)0.3f;
                ItemEntity itementity = new ItemEntity(this.level(), this.getX(), d0, this.getZ(), droppedItem);
                itementity.setPickUpDelay(40);
                float f7 = 0.3f;
                float f8 = Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180)));
                float f2 = Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180)));
                float f3 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
                float f4 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
                float f5 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f6 = 0.02f * this.random.nextFloat();
                itementity.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                this.level().addFreshEntity((Entity)itementity);
                break;
            }
            case 5: {
                this.replayShootArrow(ma);
                break;
            }
            case 8: {
                BlockState block = this.level().getBlockState(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                if (block == Blocks.AIR.defaultBlockState()) break;
                this.level().levelEvent(2001, new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Block.getId((BlockState)block));
                this.level().setBlockAndUpdate(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), Blocks.AIR.defaultBlockState());
                block.getBlock().playerWillDestroy(this.level(), new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block, (Player)this.fakePlayer);
                break;
            }
            case 7: {
                BlockEntity blockEntity;
                BlockState block = Block.stateById((int)ma.stateId);
                this.level().setBlockAndUpdate(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), block);
                if (block.getBlock() instanceof DoorBlock) {
                    BlockState upperDoor = (BlockState)block.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                    this.level().setBlockAndUpdate(new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), upperDoor);
                }
                if (block.getBlock() instanceof SignBlock && (blockEntity = this.level().getBlockEntity(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord))) instanceof SignBlockEntity) {
                    SignBlockEntity sign = (SignBlockEntity)blockEntity;
                    sign.load(ma.itemData);
                }
                SoundType soundtype = block.getBlock().getSoundType(block, (LevelReader)this.level(), new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), (Entity)this);
                this.level().playSound(null, new BlockPos(ma.xCoord, ma.yCoord + 1, ma.zCoord), soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                break;
            }
            case 9: {
                BlockState aBlock = this.level().getBlockState(new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord));
                if (aBlock == Blocks.AIR.defaultBlockState()) break;
                aBlock.use(this.level(), (Player)this.fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(this.getLookAngle(), this.getDirection(), new BlockPos(ma.xCoord, ma.yCoord, ma.zCoord), false));
                break;
            }
            case 10: {
                this.fakePlayer.containerMenu.removed((Player)this.fakePlayer);
                this.fakePlayer.containerMenu = this.fakePlayer.inventoryMenu;
                break;
            }
            case 11: {
                this.getItemInHand(ma.handType).getItem().use(this.level(), (Player)this.fakePlayer, ma.handType);
                this.lastActiveItemStack = this.getItemInHand(ma.handType);
                break;
            }
            case 12: {
                this.lastActiveItemStack.finishUsingItem(this.level(), (LivingEntity)this);
                this.lastActiveItemStack = ItemStack.EMPTY;
                break;
            }
            case 13: {
                this.lastActiveItemStack.getItem().releaseUsing(this.lastActiveItemStack, this.level(), (LivingEntity)this.fakePlayer, 0);
                this.lastActiveItemStack = ItemStack.EMPTY;
                break;
            }
            case 14: {
                this.executeCommand(ma.message);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            String currentReplay = this.getReplayData().getString("CurrentReplay");
            String nextReplay = this.getReplayData().getString("NextReplay");
            if (!this.isReplayActive) {
                if (!currentReplay.equals("") && PlayTickThread.doesRecFileExist(this.level(), currentReplay)) {
                    PlayTickThread.register(new PlayTickThread(this, currentReplay));
                    this.isReplayActive = true;
                } else if (!nextReplay.equals("") && PlayTickThread.doesRecFileExist(this.level(), nextReplay)) {
                    this.getReplayData().putString("CurrentReplay", nextReplay);
                    this.getReplayData().putString("NextReplay", "");
                    PlayTickThread.register(new PlayTickThread(this, nextReplay));
                    this.isReplayActive = true;
                }
            }
        }
        if (this.modelEntity != null) {
            this.modelEntity.tick();
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (data.equals(SETTINGS) && this.modelEntity != null) {
            ((LivingEntity)this.modelEntity).readAdditionalSaveData(this.getSettings().getCompound("EntityData"));
        }
        super.onSyncedDataUpdated(data);
    }

    public void aiStep() {
        super.aiStep();
        if (this.eventsList.size() > 0) {
            NPCAction ma = this.eventsList.remove(0);
            this.processActions(ma);
        }
        this.updatePose();
        this.updateSwingTime();
        if (this.fakePlayer != null) {
            this.fakePlayer.setPos(this.getX(), this.getY(), this.getZ());
            this.fakePlayer.setYRot(this.getYRot());
            this.fakePlayer.setXRot(this.getXRot());
            this.fakePlayer.yHeadRot = this.yHeadRot;
            this.fakePlayer.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.of((CompoundTag)this.getMainHandItem().serializeNBT()));
            this.fakePlayer.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.of((CompoundTag)this.getOffhandItem().serializeNBT()));
        }
        this.level().getProfiler().push("looting");
        if (!this.level().isClientSide && this.getSettings().getBoolean("PickupItems") && this.isAlive() && !this.dead) {
            for (ItemEntity itementity : this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(1.0, 0.0, 1.0))) {
                if (itementity.isRemoved() || itementity.getItem().isEmpty() || itementity.hasPickUpDelay()) continue;
                ItemStack itemstack = itementity.getItem();
                this.onItemPickup(itementity);
                this.take((Entity)itementity, itemstack.getCount());
                itementity.discard();
            }
        }
        this.level().getProfiler().pop();
    }

    public float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        switch (poseIn) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return POSES.getOrDefault(poseIn, STANDING_DIMENSIONS);
    }

    protected void updatePose() {
        if (this.canEnterPose(Pose.SWIMMING)) {
            Pose pose = this.isFallFlying() ? Pose.FALL_FLYING : (this.isSleeping() ? Pose.SLEEPING : (this.isSwimming() ? Pose.SWIMMING : (this.isAutoSpinAttack() ? Pose.SPIN_ATTACK : (this.isShiftKeyDown() ? Pose.CROUCHING : Pose.STANDING))));
            Pose pose1 = !(this.isSpectator() || this.isPassenger() || this.canEnterPose(pose)) ? (this.canEnterPose(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING) : pose;
            this.setPose(pose1);
        }
    }

    protected boolean canEnterPose(Pose p_20176_) {
        return this.level().noCollision((Entity)this, this.getBoundingBoxForPose(p_20176_).deflate(1.0E-7));
    }

    protected AABB getBoundingBoxForPose(Pose p_20218_) {
        EntityDimensions entitydimensions = this.getDimensions(p_20218_);
        float f = entitydimensions.width / 2.0f;
        Vec3 vec3 = new Vec3(this.getX() - (double)f, this.getY(), this.getZ() - (double)f);
        Vec3 vec31 = new Vec3(this.getX() + (double)f, this.getY() + (double)entitydimensions.height, this.getZ() + (double)f);
        return new AABB(vec3, vec31);
    }

    protected float tickHeadTurn(float f2, float f3) {
        boolean flag;
        float f = Mth.wrapDegrees((float)(f2 - this.yBodyRot));
        this.yBodyRot += f * 0.3f;
        float f1 = Mth.wrapDegrees((float)(this.getYRot() - this.yBodyRot));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.yBodyRot = this.getYRot() - f1;
        if (f1 * f1 > 2500.0f) {
            this.yBodyRot += f1 * 0.2f;
        }
        if (flag) {
            f3 *= -1.0f;
        }
        return f3;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("NPCName", Component.Serializer.toJson((Component)this.getNPCName()));
        compound.putString("TextureName", this.getTextureName());
        compound.putString("Model", this.getModel().toString());
        compound.put("Settings", (Tag)this.getSettings());
        compound.put("ReplayData", (Tag)this.getReplayData());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (!compound.getString("NPCName").equals("")) {
            this.setNPCName((Component)Component.Serializer.fromJsonLenient((String)compound.getString("NPCName")));
        }
        this.setTextureName(compound.getString("TextureName"));
        this.setModel(new ResourceLocation(compound.getString("Model")));
        this.setSettings(compound.getCompound("Settings"));
        this.setReplayData(compound.getCompound("ReplayData"));
    }

    public LivingEntity GetTargetEntityLiving(int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        LivingEntity target = null;
        AABB area = new AABB(this.getX() - (double)scanRadius, this.getY() - (double)scanRadius, this.getZ() - (double)scanRadius, this.getX() + (double)scanRadius, this.getY() + (double)scanRadius, this.getZ() + (double)scanRadius);
        List lst = this.level().getEntities((Entity)this, area);
        for (int i = 0; i < lst.size(); ++i) {
            Entity ent = (Entity)lst.get(i);
            if (!(ent instanceof LivingEntity) || ent == null || ent.getBoundingBox() == null) continue;
            float distance = this.distanceTo(ent) + 0.1f;
            float angle = this.yHeadRot;
            float pitch = this.getXRot();
            Vec3 look = this.getLookAngle();
            Vec3 targetVec = new Vec3(this.getX() + look.x * (double)distance, (double)(this.getEyeHeight() / 2.0f) + this.getY() + look.y * (double)distance, this.getZ() + look.z * (double)distance);
            if (!ent.getBoundingBox().contains(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (LivingEntity)ent;
        }
        return target;
    }

    public EquipmentSlot getEquipmentSlotById(int Id) {
        switch (Id) {
            case 0: {
                return EquipmentSlot.MAINHAND;
            }
            case 1: {
                return EquipmentSlot.FEET;
            }
            case 2: {
                return EquipmentSlot.LEGS;
            }
            case 3: {
                return EquipmentSlot.CHEST;
            }
            case 4: {
                return EquipmentSlot.HEAD;
            }
            case 5: {
                return EquipmentSlot.OFFHAND;
            }
        }
        return EquipmentSlot.LEGS;
    }

    public void attack(Entity targetEntity) {
        if (targetEntity.isAttackable() && !targetEntity.skipAttackInteraction((Entity)this)) {
            float f = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.getDamageBonus((ItemStack)this.getMainHandItem(), (MobType)((LivingEntity)targetEntity).getMobType()) : EnchantmentHelper.getDamageBonus((ItemStack)this.getMainHandItem(), (MobType)MobType.UNDEFINED);
            float f2 = 1.0f;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.getKnockbackBonus((LivingEntity)this);
                if (this.isSprinting() && flag) {
                    this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, this.getSoundSource(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.fallDistance > 0.0f && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.hasEffect(MobEffects.BLINDNESS) && !this.isPassenger() && targetEntity instanceof LivingEntity;
                flag2 = flag2 && !this.isSprinting();
                f += f1;
                boolean flag3 = false;
                double d0 = this.walkDist - this.walkDistO;
                if (flag && !flag2 && !flag1 && this.onGround() && d0 < (double)this.getSpeed() && (itemstack = this.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.getFireAspect((LivingEntity)this);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).getHealth();
                    if (j > 0 && !targetEntity.isOnFire()) {
                        flag4 = true;
                        targetEntity.setSecondsOnFire(1);
                    }
                }
                Vec3 vector3d = targetEntity.getDeltaMovement();
                boolean flag5 = targetEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).knockback((double)((float)i * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.push((double)(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        this.setSprinting(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.getSweepingDamageRatio((LivingEntity)this) * f;
                        for (LivingEntity livingentity : this.level().getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                            if (livingentity == this || livingentity == targetEntity || this.isAlliedTo((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).isMarker() || !(this.distanceToSqr((Entity)livingentity) < 9.0)) continue;
                            livingentity.knockback((double)0.4f, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                            livingentity.hurt(this.damageSources().mobAttack((LivingEntity)this), f3);
                        }
                        this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
                    }
                    if (targetEntity instanceof ServerPlayer && targetEntity.hurtMarked) {
                        ((ServerPlayer)targetEntity).connection.send((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                        targetEntity.hurtMarked = false;
                        targetEntity.setDeltaMovement(vector3d);
                    }
                    if (flag2) {
                        this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, this.getSoundSource(), 1.0f, 1.0f);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, this.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, this.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    this.setLastHurtMob(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.doPostHurtEffects((LivingEntity)((LivingEntity)targetEntity), (Entity)this);
                    }
                    EnchantmentHelper.doPostDamageEffects((LivingEntity)this, (Entity)targetEntity);
                    ItemStack itemstack1 = this.getMainHandItem();
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPart) {
                        entity = ((EnderDragonPart)targetEntity).parentMob;
                    }
                    if (!this.level().isClientSide && !itemstack1.isEmpty() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.copy();
                        itemstack1.hurtEnemy((LivingEntity)entity, (Player)this.fakePlayer);
                        if (itemstack1.isEmpty()) {
                            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).getHealth();
                        if (j > 0) {
                            targetEntity.setSecondsOnFire(j * 4);
                        }
                        if (this.level() instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, targetEntity.getX(), targetEntity.getY(0.5), targetEntity.getZ(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.clearFire();
                    }
                }
            }
        }
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.inventory.armor;
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            return this.inventory.getSelected();
        }
        if (slotIn == EquipmentSlot.OFFHAND) {
            return (ItemStack)this.inventory.offhand.get(0);
        }
        return slotIn.getType() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.inventory.armor.get(slotIn.getIndex()) : ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            this.inventory.items.set(this.inventory.selected, (Object)stack);
        } else if (slotIn == EquipmentSlot.OFFHAND) {
            this.inventory.offhand.set(0, (Object)stack);
        } else if (slotIn.getType() == EquipmentSlot.Type.ARMOR) {
            this.inventory.armor.set(slotIn.getIndex(), (Object)stack);
        }
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public boolean canBreatheUnderwater() {
        return !this.getSettings().getBoolean("CanDrown");
    }

    public boolean isSensitiveToWater() {
        return this.getSettings().getBoolean("WaterSensitive");
    }

    public boolean fireImmune() {
        return !this.getSettings().getBoolean("FireDamage");
    }

    public boolean causeFallDamage(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return this.getSettings().getBoolean("FallDamage") ? super.causeFallDamage(p_147187_, p_147188_, p_147189_) : false;
    }
}

