/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.events;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.networking.CosmicNPCsMessages;
import de.namensammler.cosmicnpcs.core.networking.packet.DeltaMovementC2SPacket;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.IOException;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@Mod.EventBusSubscriber(modid="cosmicnpcs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent.RightClickBlock event) {
        List<NPCAction> aList;
        if (!event.getLevel().isClientSide && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntity())) != null) {
            NPCAction ma = new NPCAction(9);
            ma.xCoord = event.getPos().getX();
            ma.yCoord = event.getPos().getY();
            ma.zCoord = event.getPos().getZ();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onBreakEvent(BlockEvent.BreakEvent event) {
        List<NPCAction> aList;
        if (!event.getLevel().isClientSide() && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(8);
            ma.xCoord = event.getPos().getX();
            ma.yCoord = event.getPos().getY();
            ma.zCoord = event.getPos().getZ();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        List<NPCAction> aList;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!event.getLevel().isClientSide() && (aList = CosmicNPCs.instance.getActionListForPlayer((Player)event.getEntity())) != null) {
            BlockEntity blockEntity;
            NPCAction ma = new NPCAction(7);
            Block block = event.getPlacedBlock().getBlock();
            ma.stateId = Block.getId((BlockState)event.getPlacedBlock());
            ma.xCoord = event.getPos().getX();
            ma.yCoord = event.getPos().getY();
            ma.zCoord = event.getPos().getZ();
            if (block instanceof SignBlock && (blockEntity = event.getLevel().getBlockEntity(event.getPos())) instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)blockEntity;
                ma.itemData = sign.getUpdateTag();
            }
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onArrowLooseEvent(ArrowLooseEvent event) throws IOException {
        List<NPCAction> aList;
        if (!event.getLevel().isClientSide && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntity())) != null) {
            NPCAction ma = new NPCAction(5);
            ma.arrowCharge = event.getCharge();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemTossEvent(ItemTossEvent event) throws IOException {
        List<NPCAction> aList;
        if (!event.getPlayer().level().isClientSide && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(3);
            event.getEntity().getItem().save(ma.itemData);
            aList.add(ma);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onServerChatEvent(ServerChatEvent event) {
        List<NPCAction> aList;
        if (!event.getPlayer().level().isClientSide && (aList = CosmicNPCs.instance.getActionListForPlayer((Player)event.getPlayer())) != null) {
            NPCAction ma = new NPCAction(1);
            ma.message = event.getRawText();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onGuiClosing(PlayerContainerEvent.Close event) {
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntity());
        if (aList != null) {
            NPCAction ma = new NPCAction(10);
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        List<NPCAction> aList;
        if (!event.getLevel().isClientSide && (aList = CosmicNPCs.instance.getActionListForPlayer(event.getEntity())) != null) {
            NPCAction ma = new NPCAction(11);
            ma.handType = event.getHand();
            aList.add(ma);
        }
    }

    @SubscribeEvent
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (!event.getEntity().level().isClientSide) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
            if (aList != null) {
                NPCAction ma = new NPCAction(12);
                aList.add(ma);
            }
        }
    }

    @SubscribeEvent
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (!event.getEntity().level().isClientSide) {
            if (!(event.getEntity() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getEntity();
            List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
            if (aList != null) {
                NPCAction ma = new NPCAction(13);
                aList.add(ma);
            }
        }
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) {
        if (!(((CommandSourceStack)event.getParseResults().getContext().getSource()).getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)((CommandSourceStack)event.getParseResults().getContext().getSource()).getEntity();
        List<NPCAction> aList = CosmicNPCs.instance.getActionListForPlayer(player);
        if (aList != null) {
            NPCAction ma = new NPCAction(14);
            ma.message = event.getParseResults().getReader().getString();
            aList.add(ma);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (CosmicNPCs.instance.recordThreads.get(event.player) != null && event.player.level().isClientSide()) {
            CosmicNPCsMessages.sendToServer(new DeltaMovementC2SPacket(event.player.getDeltaMovement()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        CosmicNPCs.safeCommandData();
    }
}

