/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;

public class NPCFolderPack
extends PathPackResources {
    public static final String PACK_ID = "npctextures";
    public static final Path PATH = Path.of("config/cosmicnpcs/resources", new String[0]);
    public static final Component DESCRIPTION = Component.literal((String)"NPC Resources");
    public static final boolean IS_BUILTIN = true;

    public NPCFolderPack() {
        super(PACK_ID, PATH, true);
        new File(PATH + "/textures/main").mkdirs();
        new File(PATH + "/textures/layers").mkdirs();
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        File file1 = new File(PATH.toString(), location.getPath());
        if (!file1.isFile()) {
            return null;
        }
        return IoSupplier.create((Path)file1.toPath());
    }

    public Set<String> getNamespaces(PackType type) {
        return Collections.singleton(this.packId());
    }

    public static class NPCResourcesSupplier
    implements Pack.ResourcesSupplier {
        public PackResources openPrimary(String p_294153_) {
            return new NPCFolderPack();
        }

        public PackResources openFull(String p_295004_, Pack.Info p_294301_) {
            PackResources packresources = this.openPrimary(p_295004_);
            List list = p_294301_.overlays();
            if (list.isEmpty()) {
                return packresources;
            }
            ArrayList<NPCFolderPack> list1 = new ArrayList<NPCFolderPack>(list.size());
            for (String s : list) {
                Path path = PATH.resolve(s);
                list1.add(new NPCFolderPack());
            }
            return new CompositePackResources(packresources, list1);
        }
    }
}

