/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CCheckboxButton
extends AbstractButton {
    private static final ResourceLocation CHECKBOX_TEXTURE = new ResourceLocation("cosmicnpcs", "textures/gui/checkbox.png");
    private boolean selected;
    private final OnValueChange onValueChange;

    public CCheckboxButton(int x, int y, Component message, Font font, boolean selected, OnValueChange onValueChange) {
        super(x, y, CCheckboxButton.boxSize(font) + 4 + font.width((FormattedText)message), CCheckboxButton.boxSize(font), message);
        this.selected = selected;
        this.onValueChange = onValueChange;
    }

    private static int boxSize(Font p_309147_) {
        return 11;
    }

    public void onPress() {
        this.selected = !this.selected;
        this.onValueChange.onValueChange(this, this.selected);
    }

    public boolean selected() {
        return this.selected;
    }

    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    public void updateWidgetNarration(NarrationElementOutput p_260253_) {
        p_260253_.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                p_260253_.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                p_260253_.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics p_283124_, int p_282925_, int p_282705_, float p_282612_) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        Font font = minecraft.font;
        p_283124_.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        if (this.selected) {
            p_283124_.drawCenteredString(font, "x", this.getX() + CCheckboxButton.boxSize(font) / 2 + 1, this.getY() + 1, 0xE0E0E0);
        }
        int i = CCheckboxButton.boxSize(font);
        int j = this.getX() + i + 4;
        int k = this.getY() + (this.height >> 1) - 4;
        p_283124_.blit(CHECKBOX_TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, i, i, 64, 64);
        p_283124_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        p_283124_.drawString(font, this.getMessage(), j, k, 0xE0E0E0 | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnValueChange {
        public static final OnValueChange NOP = (p_309046_, p_309014_) -> {};

        public void onValueChange(CCheckboxButton var1, boolean var2);
    }
}

