/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.namensammler.cosmicnpcs.client.renderer.entity.CustomLivingRenderer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CAbstractEyesLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CDrownedOuterLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CEnergyLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CHumanoidArmorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLeatherHorseArmorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLlamaDecorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CMooshroomMushroomLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CPlayerItemInHandLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSheepWoolLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSlimeGelLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSnowmanHeadLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CStrayClothingLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CVillagerLevelPendantLayer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.MushroomCowRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.SnowGolemRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.WitherBossRenderer;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.DrownedOuterLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.EnderEyesLayer;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.LlamaDecorLayer;
import net.minecraft.client.renderer.entity.layers.MushroomCowMushroomLayer;
import net.minecraft.client.renderer.entity.layers.PhantomEyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SheepFurLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.client.renderer.entity.layers.SnowGolemHeadLayer;
import net.minecraft.client.renderer.entity.layers.SpiderEyesLayer;
import net.minecraft.client.renderer.entity.layers.StrayClothingLayer;
import net.minecraft.client.renderer.entity.layers.VillagerProfessionLayer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class CosmicNPCRenderer
extends LivingEntityRenderer<CosmicNPCEntity, PlayerModel<CosmicNPCEntity>> {
    private Map<String, CustomLivingRenderer> modelRenderers = new HashMap<String, CustomLivingRenderer>();
    private static PlayerModel player_model;
    private static PlayerModel player_model_slim;
    private static final ResourceLocation STEVE_TEXTURE;
    private static final ResourceLocation ALEX_TEXTURE;
    private static EntityRendererProvider.Context renderContext;

    public CosmicNPCRenderer(EntityRendererProvider.Context renderContext) {
        super(renderContext, (EntityModel)new PlayerModel(renderContext.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        player_model = new PlayerModel(renderContext.bakeLayer(ModelLayers.PLAYER), false);
        player_model_slim = new PlayerModel(renderContext.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.addLayer((RenderLayer)new CHumanoidArmorLayer(false, this, new HumanoidArmorModel(renderContext.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidArmorModel(renderContext.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), renderContext.getModelManager()));
        this.addLayer((RenderLayer)new CHumanoidArmorLayer(true, this, new HumanoidArmorModel(renderContext.bakeLayer(ModelLayers.PLAYER_SLIM_INNER_ARMOR)), new HumanoidArmorModel(renderContext.bakeLayer(ModelLayers.PLAYER_SLIM_OUTER_ARMOR)), renderContext.getModelManager()));
        this.addLayer((RenderLayer)new CPlayerItemInHandLayer(this, renderContext.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, renderContext.getModelSet(), renderContext.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, renderContext.getModelSet()));
        CosmicNPCRenderer.renderContext = renderContext;
    }

    protected void scale(CosmicNPCEntity entitylivingbaseIn, PoseStack poseStack, float partialTickTime) {
        poseStack.scale(0.9375f, 0.9375f, 0.9375f);
    }

    public ResourceLocation getTextureLocation(CosmicNPCEntity npc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/main/" + npc.getTextureName() + ".png");
        if (npc.getTextureName() != "default" && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/main/" + npc.getTextureName() + ".png");
        }
        return npc.getModel().equals((Object)new ResourceLocation("minecraft:player_slim")) ? ALEX_TEXTURE : STEVE_TEXTURE;
    }

    public void render(CosmicNPCEntity npc, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (npc.getModel().equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            this.model = player_model_slim;
            this.shadowRadius = 0.5f;
            this.setModelProperties(npc);
            super.render((LivingEntity)npc, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        } else if (npc.getModel().equals((Object)new ResourceLocation("minecraft:player"))) {
            this.model = player_model;
            this.shadowRadius = 0.5f;
            this.setModelProperties(npc);
            super.render((LivingEntity)npc, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        } else {
            EntityType.byString((String)npc.getModel().toString()).ifPresent(entityType -> {
                Class<?> modelEntityClass = null;
                if (npc.modelEntity != null) {
                    modelEntityClass = npc.modelEntity.getClass();
                }
                if (entityType.create(npc.level()).getClass() != modelEntityClass) {
                    npc.modelEntity = entityType.create(npc.level());
                    try {
                        ((LivingEntity)npc.modelEntity).readAdditionalSaveData(npc.getSettings().getCompound("EntityData"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    npc.modelEntity.refreshDimensions();
                }
                if (npc.modelEntity instanceof LivingEntity) {
                    LivingEntity modelEntity = (LivingEntity)npc.modelEntity;
                    if (this.entityRenderDispatcher.getRenderer((Entity)(modelEntity = this.copyEntityData(modelEntity, npc))) instanceof LivingEntityRenderer) {
                        LivingEntityRenderer modelEntityRenderer = (LivingEntityRenderer)this.entityRenderDispatcher.getRenderer((Entity)modelEntity);
                        String npc_ID = npc.getTextureName() + npc.getModel().toString() + npc.getSettings().toString();
                        if (!this.modelRenderers.containsKey(npc_ID)) {
                            this.modelRenderers.put(npc_ID, new CustomLivingRenderer(renderContext, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)modelEntityRenderer, npc, this.getLayers(modelEntityRenderer, npc)));
                        }
                        if (this.modelRenderers.containsKey(npc_ID)) {
                            CustomLivingRenderer customRenderer = this.modelRenderers.get(npc_ID);
                            this.shadowRadius = customRenderer.modelShadowSize;
                            customRenderer.npc = npc;
                            if (npc.getSettings().getBoolean("IsChild")) {
                                this.shadowRadius *= 0.5f;
                            }
                            customRenderer.render(modelEntity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
                        }
                    }
                }
            });
        }
    }

    private LivingEntity copyEntityData(LivingEntity modelEntity, CosmicNPCEntity npc) {
        modelEntity.swingingArm = npc.swingingArm;
        modelEntity.attackAnim = npc.attackAnim;
        modelEntity.oAttackAnim = npc.oAttackAnim;
        modelEntity.tickCount = npc.tickCount;
        modelEntity.setId(npc.getId());
        modelEntity.absMoveTo(npc.getX(), npc.getY(), npc.getZ(), npc.getYRot(), npc.getXRot());
        modelEntity.setDeltaMovement(npc.getDeltaMovement());
        modelEntity.yRotO = npc.yRotO;
        modelEntity.xRotO = npc.xRotO;
        modelEntity.yHeadRot = npc.yHeadRot;
        modelEntity.yHeadRotO = npc.yHeadRotO;
        modelEntity.yBodyRot = npc.yBodyRot;
        modelEntity.yBodyRotO = npc.yBodyRotO;
        modelEntity.walkAnimation.setSpeed(npc.walkAnimation.speed());
        modelEntity.hurtTime = npc.hurtTime;
        modelEntity.setOnGround(npc.onGround());
        modelEntity.setItemSlot(EquipmentSlot.MAINHAND, npc.getMainHandItem());
        modelEntity.setItemSlot(EquipmentSlot.OFFHAND, npc.getOffhandItem());
        modelEntity.setItemSlot(EquipmentSlot.HEAD, npc.getItemBySlot(EquipmentSlot.HEAD));
        modelEntity.setItemSlot(EquipmentSlot.CHEST, npc.getItemBySlot(EquipmentSlot.CHEST));
        modelEntity.setItemSlot(EquipmentSlot.LEGS, npc.getItemBySlot(EquipmentSlot.LEGS));
        modelEntity.setItemSlot(EquipmentSlot.FEET, npc.getItemBySlot(EquipmentSlot.FEET));
        modelEntity.setPose(npc.getPose());
        modelEntity.setShiftKeyDown(npc.isShiftKeyDown());
        modelEntity.setCustomName(npc.getCustomName());
        modelEntity.setCustomNameVisible(npc.isCustomNameVisible());
        modelEntity.setInvisible(npc.isInvisible());
        try {
            Field positionField = null;
            Field speedOldField = null;
            positionField = ObfuscationReflectionHelper.findField(WalkAnimationState.class, (String)"position");
            speedOldField = ObfuscationReflectionHelper.findField(WalkAnimationState.class, (String)"speedOld");
            positionField.setAccessible(true);
            speedOldField.setAccessible(true);
            positionField.setFloat(modelEntity.walkAnimation, positionField.getFloat(npc.walkAnimation));
            speedOldField.setFloat(modelEntity.walkAnimation, speedOldField.getFloat(npc.walkAnimation));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        String npc_ID = npc.getTextureName() + npc.getModel().toString() + npc.getSettings().toString();
        CustomLivingRenderer customRenderer = null;
        if (this.modelRenderers.containsKey(npc_ID)) {
            customRenderer = this.modelRenderers.get(npc_ID);
        }
        if (modelEntity instanceof EnderMan) {
            EnderMan enderman = (EnderMan)modelEntity;
            if (customRenderer != null && customRenderer.getModel() instanceof EndermanModel) {
                EndermanModel model = (EndermanModel)customRenderer.getModel();
                if (enderman.getMainHandItem().getItem() instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)enderman.getMainHandItem().getItem();
                    enderman.swingTime = 0;
                    enderman.swinging = false;
                    enderman.setCarriedBlock(blockItem.getBlock().defaultBlockState());
                    model.carrying = true;
                } else {
                    enderman.setCarriedBlock(null);
                    model.carrying = false;
                }
            }
            return enderman;
        }
        if (modelEntity instanceof Mob) {
            Mob mobEntity = (Mob)modelEntity;
            mobEntity.setBaby(npc.getSettings().getBoolean("IsChild"));
            if (npc.getMainHandItem().getItem() instanceof BowItem && npc.isUsingItem()) {
                mobEntity.setAggressive(true);
            }
            return mobEntity;
        }
        return modelEntity;
    }

    private List<RenderLayer<LivingEntity, EntityModel<LivingEntity>>> getLayers(LivingEntityRenderer renderer, CosmicNPCEntity npc) {
        List layerRenderers = Lists.newArrayList();
        ArrayList newLayerRenderers = Lists.newArrayList();
        try {
            Field layerRenderersField = null;
            layerRenderersField = ObfuscationReflectionHelper.findField(LivingEntityRenderer.class, (String)"layers");
            layerRenderersField.setAccessible(true);
            layerRenderers = (List)layerRenderersField.get(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < layerRenderers.size(); ++i) {
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(VillagerProfessionLayer.class)) {
                newLayerRenderers.add(new CVillagerLevelPendantLayer(renderer, (ReloadableResourceManager)Minecraft.getInstance().getResourceManager(), "villager", npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SheepFurLayer.class)) {
                SheepRenderer sheepRenderer = (SheepRenderer)renderer;
                newLayerRenderers.add(new CSheepWoolLayer(sheepRenderer, renderContext.getModelSet(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(EnderEyesLayer.class)) {
                EndermanRenderer endermanRenderer = (EndermanRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(endermanRenderer, npc, CAbstractEyesLayer.EyeType.ENDERMAN));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SpiderEyesLayer.class)) {
                SpiderRenderer spiderRenderer = (SpiderRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(spiderRenderer, npc, CAbstractEyesLayer.EyeType.SPIDER));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(PhantomEyesLayer.class)) {
                PhantomRenderer phantomRenderer = (PhantomRenderer)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(phantomRenderer, npc, CAbstractEyesLayer.EyeType.PHANTOM));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(StrayClothingLayer.class)) {
                StrayRenderer strayRenderer = (StrayRenderer)renderer;
                newLayerRenderers.add(new CStrayClothingLayer(strayRenderer, renderContext.getModelSet(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(DrownedOuterLayer.class)) {
                DrownedRenderer drownedRenderer = (DrownedRenderer)renderer;
                newLayerRenderers.add(new CDrownedOuterLayer(drownedRenderer, renderContext.getModelSet(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(MushroomCowMushroomLayer.class)) {
                MushroomCowRenderer mooshroomRenderer = (MushroomCowRenderer)renderer;
                newLayerRenderers.add(new CMooshroomMushroomLayer(mooshroomRenderer, npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(LlamaDecorLayer.class)) {
                LlamaRenderer llamaRenderer = (LlamaRenderer)renderer;
                newLayerRenderers.add(new CLlamaDecorLayer((RenderLayerParent<Llama, LlamaModel<Llama>>)llamaRenderer, renderContext.getModelSet(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(CreeperPowerLayer.class)) {
                CreeperRenderer creeperRenderer = (CreeperRenderer)renderer;
                newLayerRenderers.add(new CEnergyLayer(creeperRenderer, renderContext.getModelSet(), npc, CEnergyLayer.Type.CREEPER));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(WitherArmorLayer.class)) {
                WitherBossRenderer witherRenderer = (WitherBossRenderer)renderer;
                newLayerRenderers.add(new CEnergyLayer(witherRenderer, renderContext.getModelSet(), npc, CEnergyLayer.Type.WITHER));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(HorseArmorLayer.class)) {
                HorseRenderer horseRenderer = (HorseRenderer)renderer;
                newLayerRenderers.add(new CLeatherHorseArmorLayer((RenderLayerParent<Horse, HorseModel<Horse>>)horseRenderer, renderContext.getModelSet(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SlimeOuterLayer.class)) {
                newLayerRenderers.add(new CSlimeGelLayer(renderer, renderContext.getModelSet(), npc));
                continue;
            }
            if (((RenderLayer)layerRenderers.get(i)).getClass().equals(SnowGolemHeadLayer.class)) {
                SnowGolemRenderer snowmanRenderer = (SnowGolemRenderer)renderer;
                newLayerRenderers.add(new CSnowmanHeadLayer((RenderLayerParent<SnowGolem, SnowGolemModel<SnowGolem>>)snowmanRenderer, npc));
                continue;
            }
            newLayerRenderers.add((RenderLayer)layerRenderers.get(i));
        }
        return newLayerRenderers;
    }

    private float getShadowSize(LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        float shadowSize = 0.5f;
        try {
            Field shadowSizeField = null;
            shadowSizeField = ObfuscationReflectionHelper.findField(EntityRenderer.class, (String)"shadowRadius");
            shadowSizeField.setAccessible(true);
            shadowSize = shadowSizeField.getFloat(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
        return shadowSize;
    }

    private void setModelProperties(CosmicNPCEntity p_117819_) {
        PlayerModel playermodel = (PlayerModel)this.getModel();
        if (p_117819_.isSpectator()) {
            playermodel.setAllVisible(false);
            playermodel.head.visible = true;
            playermodel.hat.visible = true;
        } else {
            playermodel.setAllVisible(true);
            playermodel.crouching = p_117819_.isCrouching();
            HumanoidModel.ArmPose humanoidmodel$armpose = CosmicNPCRenderer.getArmPose(p_117819_, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose humanoidmodel$armpose1 = CosmicNPCRenderer.getArmPose(p_117819_, InteractionHand.OFF_HAND);
            if (humanoidmodel$armpose.isTwoHanded()) {
                HumanoidModel.ArmPose armPose = humanoidmodel$armpose1 = p_117819_.getOffhandItem().isEmpty() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (p_117819_.getMainArm() == HumanoidArm.RIGHT) {
                playermodel.rightArmPose = humanoidmodel$armpose;
                playermodel.leftArmPose = humanoidmodel$armpose1;
            } else {
                playermodel.rightArmPose = humanoidmodel$armpose1;
                playermodel.leftArmPose = humanoidmodel$armpose;
            }
        }
    }

    private static HumanoidModel.ArmPose getArmPose(CosmicNPCEntity player, InteractionHand handSide) {
        ItemStack itemstack = player.getItemInHand(handSide);
        if (itemstack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (player.getUsedItemHand() == handSide && player.getUseItemRemainingTicks() > 0) {
            UseAnim useanim = itemstack.getUseAnimation();
            if (useanim == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if (useanim == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if (useanim == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if (useanim == UseAnim.CROSSBOW && handSide == player.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if (useanim == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
        } else if (!player.swinging && itemstack.is(Items.CROSSBOW) && CrossbowItem.isCharged((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void setupRotations(CosmicNPCEntity p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.getSwimAmount(p_117806_);
        if (p_117802_.isFallFlying()) {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.getFallFlyingTicks() + p_117806_;
            float f2 = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.isAutoSpinAttack()) {
                p_117803_.mulPose(Axis.XP.rotationDegrees(f2 * (-90.0f - p_117802_.getXRot())));
            }
            Vec3 vec3 = p_117802_.getViewVector(p_117806_);
            Vec3 vec31 = p_117802_.getDeltaMovement();
            double d0 = vec31.horizontalDistanceSqr();
            double d1 = vec3.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.x * vec3.x + vec31.z * vec3.z) / Math.sqrt(d0 * d1);
                double d3 = vec31.x * vec3.z - vec31.z * vec3.x;
                p_117803_.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = p_117802_.isInWater() ? -90.0f - p_117802_.getXRot() : -90.0f;
            float f4 = Mth.lerp((float)f, (float)0.0f, (float)f3);
            p_117803_.mulPose(Axis.XP.rotationDegrees(f4));
            if (p_117802_.isVisuallySwimming()) {
                p_117803_.translate(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.setupRotations((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }

    protected boolean shouldShowName(CosmicNPCEntity entity) {
        return super.shouldShowName((LivingEntity)entity) && (entity.shouldShowName() || entity.hasCustomName() && entity == this.entityRenderDispatcher.crosshairPickEntity);
    }

    static {
        STEVE_TEXTURE = new ResourceLocation("textures/entity/player/wide/steve.png");
        ALEX_TEXTURE = new ResourceLocation("textures/entity/player/slim/alex.png");
    }
}

