/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CMooshroomMushroomLayer<T extends MushroomCow>
extends RenderLayer<T, CowModel<T>> {
    BlockState block;

    public CMooshroomMushroomLayer(RenderLayerParent<T, CowModel<T>> rendererIn, CosmicNPCEntity npc) {
        super(rendererIn);
        ResourceLocation loc = new ResourceLocation(npc.getSettings().getString("MushroomBlock"));
        this.block = Blocks.RED_MUSHROOM.defaultBlockState();
        if (BuiltInRegistries.BLOCK.containsKey(loc)) {
            this.block = ((Block)BuiltInRegistries.BLOCK.get(loc)).defaultBlockState();
        }
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.isBaby() && !entitylivingbaseIn.isInvisible()) {
            BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
            BlockState blockstate = this.block;
            int i = LivingEntityRenderer.getOverlayCoords(entitylivingbaseIn, (float)0.0f);
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)0.2f, (double)-0.35f, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-48.0f));
            matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
            matrixStackIn.translate(-0.5, -0.5, -0.5);
            blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)0.2f, (double)-0.35f, 0.5);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(42.0f));
            matrixStackIn.translate((double)0.1f, 0.0, (double)-0.6f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-48.0f));
            matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
            matrixStackIn.translate(-0.5, -0.5, -0.5);
            blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            ((CowModel)this.getParentModel()).getHead().translateAndRotate(matrixStackIn);
            matrixStackIn.translate(0.0, (double)-0.7f, (double)-0.2f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-78.0f));
            matrixStackIn.scale(-1.0f, -1.0f, 1.0f);
            matrixStackIn.translate(-0.5, -0.5, -0.5);
            blockrendererdispatcher.renderSingleBlock(blockstate, matrixStackIn, bufferIn, packedLightIn, i);
            matrixStackIn.popPose();
        }
    }
}

