/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.metadata.animation.VillagerMetaDataSection;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CVillagerLevelPendantLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M>
implements ResourceManagerReloadListener {
    private static final Int2ObjectMap<ResourceLocation> LEVEL_LOCATIONS = (Int2ObjectMap)Util.make((Object)new Int2ObjectOpenHashMap(), p_215348_0_ -> {
        p_215348_0_.put(1, (Object)new ResourceLocation("stone"));
        p_215348_0_.put(2, (Object)new ResourceLocation("iron"));
        p_215348_0_.put(3, (Object)new ResourceLocation("gold"));
        p_215348_0_.put(4, (Object)new ResourceLocation("emerald"));
        p_215348_0_.put(5, (Object)new ResourceLocation("diamond"));
    });
    private final Object2ObjectMap<VillagerType, VillagerMetaDataSection.Hat> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<VillagerProfession, VillagerMetaDataSection.Hat> professionHatCache = new Object2ObjectOpenHashMap();
    private final ReloadableResourceManager resourceManager;
    private final String path;
    private String villagerTypeTexture;
    private String professionTexture;
    private String professionLevelTexture;

    public CVillagerLevelPendantLayer(RenderLayerParent<T, M> p_i50955_1_, ReloadableResourceManager p_i50955_2_, String p_i50955_3_, CosmicNPCEntity npc) {
        super(p_i50955_1_);
        this.resourceManager = p_i50955_2_;
        this.path = p_i50955_3_;
        CompoundTag settings = npc.getSettings();
        this.villagerTypeTexture = settings.getString("VillagerType");
        this.professionTexture = settings.getString("Profession");
        this.professionLevelTexture = settings.getString("ProfessionLevel");
        if (!settings.getString("Layer").equals("default")) {
            this.villagerTypeTexture = settings.getString("Layer");
        }
        p_i50955_2_.registerReloadListener((PreparableReloadListener)this);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.isInvisible()) {
            VillagerData villagerdata = ((VillagerDataHolder)entitylivingbaseIn).getVillagerData();
            VillagerType villagertype = villagerdata.getType();
            VillagerProfession villagerprofession = villagerdata.getProfession();
            VillagerMetaDataSection.Hat villagermetadatasection$hattype = this.getHatData(this.typeHatCache, "type", BuiltInRegistries.VILLAGER_TYPE, villagertype);
            VillagerMetaDataSection.Hat villagermetadatasection$hattype1 = this.getHatData(this.professionHatCache, "profession", BuiltInRegistries.VILLAGER_PROFESSION, villagerprofession);
            EntityModel m = this.getParentModel();
            ((VillagerHeadModel)m).hatVisible(villagermetadatasection$hattype1 == VillagerMetaDataSection.Hat.NONE || villagermetadatasection$hattype1 == VillagerMetaDataSection.Hat.PARTIAL && villagermetadatasection$hattype != VillagerMetaDataSection.Hat.FULL);
            ResourceLocation resourcelocation = this.getVillagerTypeTexture(this.villagerTypeTexture, BuiltInRegistries.VILLAGER_TYPE.getKey((Object)villagertype));
            CVillagerLevelPendantLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)resourcelocation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
            ((VillagerHeadModel)m).hatVisible(true);
            if (villagerprofession != VillagerProfession.NONE && !entitylivingbaseIn.isBaby()) {
                ResourceLocation resourcelocation1 = this.getProfessionTexture(this.professionTexture, BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)villagerprofession));
                CVillagerLevelPendantLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)resourcelocation1, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                if (villagerprofession != VillagerProfession.NITWIT) {
                    ResourceLocation resourcelocation2 = this.getProfessionLevelTexture(this.professionLevelTexture, (ResourceLocation)LEVEL_LOCATIONS.get(Mth.clamp((int)villagerdata.getLevel(), (int)1, (int)LEVEL_LOCATIONS.size())));
                    CVillagerLevelPendantLayer.renderColoredCutoutModel((EntityModel)m, (ResourceLocation)resourcelocation2, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    private ResourceLocation getResourceLocation(String p_215351_1_, ResourceLocation p_215351_2_) {
        return new ResourceLocation(p_215351_2_.getNamespace(), "textures/entity/" + this.path + "/" + p_215351_1_ + "/" + p_215351_2_.getPath() + ".png");
    }

    public <K> VillagerMetaDataSection.Hat getHatData(Object2ObjectMap<K, VillagerMetaDataSection.Hat> p_117659_, String p_117660_, DefaultedRegistry<K> p_117661_, K p_117662_) {
        return (VillagerMetaDataSection.Hat)p_117659_.computeIfAbsent(p_117662_, p_234880_ -> this.resourceManager.getResource(this.getResourceLocation(p_117660_, p_117661_.getKey(p_117662_))).flatMap(p_234875_ -> {
            try {
                return p_234875_.metadata().getSection((MetadataSectionSerializer)VillagerMetaDataSection.SERIALIZER).map(VillagerMetaDataSection::getHat);
            }
            catch (IOException ioexception) {
                return Optional.empty();
            }
        }).orElse(VillagerMetaDataSection.Hat.NONE));
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.professionHatCache.clear();
        this.typeHatCache.clear();
    }

    public ResourceLocation getVillagerTypeTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : BuiltInRegistries.VILLAGER_TYPE.entrySet()) {
            if (!((VillagerType)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.getResourceLocation("type", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("type", loc);
    }

    public ResourceLocation getProfessionTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : BuiltInRegistries.VILLAGER_PROFESSION.entrySet()) {
            if (!((VillagerProfession)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.getResourceLocation("profession", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("profession", loc);
    }

    public ResourceLocation getProfessionLevelTexture(String layerTexture, ResourceLocation loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new ResourceLocation("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("profession_level", loc);
    }
}

