/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.namensammler.cosmicnpcs.common.command.argument.CComponentArgument;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.init.ConfigInit;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayTickThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class NPCPlayCommand {
    public NPCPlayCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"npc-play").requires(sender -> sender.hasPermission(2))).then(Commands.argument((String)"file", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.REC_FILES).then(Commands.argument((String)"name", (ArgumentType)CComponentArgument.textComponent()).then(((RequiredArgumentBuilder)Commands.argument((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(context -> this.play((CommandContext<CommandSourceStack>)context, 0))).then(((RequiredArgumentBuilder)Commands.argument((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(context -> this.play((CommandContext<CommandSourceStack>)context, 1))).then(Commands.argument((String)"settings", (ArgumentType)CompoundTagArgument.compoundTag()).executes(context -> this.play((CommandContext<CommandSourceStack>)context, 2))))))));
    }

    private int play(CommandContext<CommandSourceStack> context, int type) throws CommandSyntaxException {
        String fileName = StringArgumentType.getString(context, (String)"file");
        Component npcName = CComponentArgument.getComponent(context, "name");
        String textureName = StringArgumentType.getString(context, (String)"texture");
        if (type == 0) {
            return this.play(context, fileName, npcName, textureName);
        }
        if (type == 1) {
            ResourceLocation model = CEntitySummonArgument.getEntityId(context, "model");
            return this.play(context, fileName, npcName, textureName, model);
        }
        if (type == 2) {
            ResourceLocation model = CEntitySummonArgument.getEntityId(context, "model");
            CompoundTag compound = CompoundTagArgument.getCompoundTag(context, (String)"settings");
            return this.play(context, fileName, npcName, textureName, model, compound);
        }
        return 0;
    }

    private int play(CommandContext<CommandSourceStack> context, String fileName, Component npcName, String textureName) {
        return this.play(context, fileName, npcName, textureName, new ResourceLocation("minecraft:player"), new CompoundTag());
    }

    private int play(CommandContext<CommandSourceStack> context, String fileName, Component npcName, String textureName, ResourceLocation model) {
        return this.play(context, fileName, npcName, textureName, model, new CompoundTag());
    }

    private int play(CommandContext<CommandSourceStack> context, String fileNameIn, Component npcName, String textureName, ResourceLocation model, CompoundTag compound) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        File file = PlayTickThread.getRecFile((Level)source.getLevel(), fileNameIn);
        if (!file.exists()) {
            source.sendFailure((Component)Component.literal((String)("Can't find " + fileNameIn + ".ccap file!")));
            return 0;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yawHead = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            short magic = in.readShort();
            int compatibility = PlayTickThread.getCompatibility(magic);
            if (compatibility == 0) {
                in.close();
                source.sendFailure((Component)Component.literal((String)(fileNameIn + ".ccap isn't compatible with this mod version. (" + magic + ")")));
            } else if (compatibility == -1) {
                in.close();
                source.sendFailure((Component)Component.literal((String)(fileNameIn + " isn't a .ccap file.")));
            }
            yawHead = in.readFloat();
            yaw = in.readFloat();
            pitch = in.readFloat();
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ServerLevel world = source.getLevel();
        CosmicNPCEntity npc = (CosmicNPCEntity)EntityTypesInit.COSMIC_NPC.get().create((Level)world);
        boolean isPlayerModel = false;
        if (model.equals((Object)new ResourceLocation("minecraft:player")) || model.equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            isPlayerModel = true;
        }
        CompoundTag settings = npc.getSettings();
        settings.putInt("ShowNameTag", compound.contains("ShowNameTag") ? compound.getInt("ShowNameTag") : (isPlayerModel ? (Integer)ConfigInit.showPlayerNameTags.get() : (Integer)ConfigInit.showMobNameTags.get()).intValue());
        settings.putBoolean("Invulnerable", compound.contains("Invulnerable") ? compound.getBoolean("Invulnerable") : ((Boolean)ConfigInit.invulnerable.get()).booleanValue());
        settings.putBoolean("UseCommands", compound.contains("UseCommands") ? compound.getBoolean("UseCommands") : ((Boolean)ConfigInit.canUseCommands.get()).booleanValue());
        settings.putBoolean("IsChild", compound.contains("IsChild") ? compound.getBoolean("IsChild") : false);
        settings.putString("Layer", compound.contains("Layer") ? compound.getString("Layer").toLowerCase(Locale.ROOT) : "default");
        settings.putBoolean("PickupItems", compound.contains("PickupItems") ? compound.getBoolean("PickupItems") : ((Boolean)ConfigInit.canPickupItems.get()).booleanValue());
        settings.putString("Tag", compound.contains("Tag") ? compound.getString("Tag") : "");
        settings.putDouble("Health", compound.contains("Health") ? compound.getDouble("Health") : ((Double)ConfigInit.maxHealth.get()).doubleValue());
        settings.putBoolean("CanDrown", compound.contains("CanDrown") ? compound.getBoolean("CanDrown") : ((Boolean)ConfigInit.canDrown.get()).booleanValue());
        settings.putBoolean("FireDamage", compound.contains("FireDamage") ? compound.getBoolean("FireDamage") : ((Boolean)ConfigInit.takesFireDamage.get()).booleanValue());
        settings.putBoolean("WaterSensitive", compound.contains("WaterSensitive") ? compound.getBoolean("WaterSensitive") : ((Boolean)ConfigInit.takesWaterDamage.get()).booleanValue());
        settings.putBoolean("FallDamage", compound.contains("FallDamage") ? compound.getBoolean("FallDamage") : ((Boolean)ConfigInit.takesFallDamage.get()).booleanValue());
        settings.putBoolean("Loop", compound.contains("Loop") ? compound.getBoolean("Loop") : ((Boolean)ConfigInit.loop.get()).booleanValue());
        settings.putBoolean("ShouldPersist", compound.contains("ShouldPersist") ? compound.getBoolean("ShouldPersist") : ((Boolean)ConfigInit.shouldPersist.get()).booleanValue());
        settings.putString("ChatPrefix", compound.contains("ChatPrefix") ? compound.getString("ChatPrefix") : (String)ConfigInit.chatPrefix.get());
        settings.put("EntityData", (Tag)(compound.contains("EntityData") ? compound.getCompound("EntityData") : new CompoundTag()));
        settings.putString("Color", compound.contains("Color") ? compound.getString("Color") : "default");
        settings.putString("MushroomBlock", compound.contains("MushroomBlock") ? compound.getString("MushroomBlock") : "default");
        settings.putBoolean("Charged", compound.contains("Charged") ? compound.getBoolean("Charged") : false);
        settings.putString("Armor", compound.contains("Armor") ? compound.getString("Armor") : "default");
        settings.putString("Head", compound.contains("Head") ? compound.getString("Head") : "default");
        npc.setPos(x, y, z);
        npc.yHeadRot = yawHead;
        npc.setYRot(yaw);
        npc.setXRot(pitch);
        npc.setNPCName(npcName);
        npc.setTextureName(textureName);
        npc.setModel(model);
        npc.setSettings(new CompoundTag());
        npc.setSettings(settings);
        if (settings.getInt("ShowNameTag") >= 1) {
            npc.setCustomName(npc.getNPCName());
        } else {
            npc.setCustomName(null);
        }
        if (settings.getInt("ShowNameTag") == 1) {
            npc.setCustomNameVisible(true);
        } else {
            npc.setCustomNameVisible(false);
        }
        npc.setInvulnerable(settings.getBoolean("Invulnerable"));
        npc.addTag(settings.getString("Tag"));
        npc.getAttribute(Attributes.MAX_HEALTH).setBaseValue(settings.getDouble("Health"));
        npc.setHealth(npc.getMaxHealth());
        world.addFreshEntity((Entity)npc);
        npc.getReplayData().putString("CurrentReplay", fileNameIn);
        npc.isReplayActive = true;
        PlayTickThread.register(new PlayTickThread(npc, fileNameIn).fromBeginning());
        return 0;
    }
}

