/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CEntitySummonArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:pig", "cow");
    public static final DynamicCommandExceptionType ENTITY_UNKNOWN_TYPE = new DynamicCommandExceptionType(p_211367_0_ -> Component.translatable((String)"argument.resource.not_found", (Object[])new Object[]{p_211367_0_}));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_RESOURCE = new Dynamic2CommandExceptionType((p_248525_, p_251552_) -> Component.translatable((String)"argument.resource.not_found", (Object[])new Object[]{p_248525_, p_251552_}));

    public static CEntitySummonArgument entitySummon() {
        return new CEntitySummonArgument();
    }

    public static ResourceLocation getEntityId(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        return CEntitySummonArgument.checkIfEntityExists((ResourceLocation)context.getArgument(name, ResourceLocation.class));
    }

    private static ResourceLocation checkIfEntityExists(ResourceLocation id) throws CommandSyntaxException {
        if (!id.equals((Object)new ResourceLocation("minecraft:player")) && !id.equals((Object)new ResourceLocation("minecraft:player_slim"))) {
            BuiltInRegistries.ENTITY_TYPE.getOptional(id).filter(entityType -> entityType.canSummon()).orElseThrow(() -> ERROR_UNKNOWN_RESOURCE.create((Object)id, (Object)Registries.ENTITY_TYPE.location()));
        }
        return id;
    }

    public ResourceLocation parse(StringReader p_parse_1_) throws CommandSyntaxException {
        return CEntitySummonArgument.checkIfEntityExists(ResourceLocation.read((StringReader)p_parse_1_));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

