/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.init;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.namensammler.cosmicnpcs.CosmicNPCs;
import java.io.File;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigInit {
    private static final ModConfigSpec.Builder common_builder = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder server_builder = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder client_builder = new ModConfigSpec.Builder();
    public static final ModConfigSpec common_config;
    public static final ModConfigSpec server_config;
    public static final ModConfigSpec client_config;
    public static ModConfigSpec.ConfigValue<Integer> showPlayerNameTags;
    public static ModConfigSpec.ConfigValue<Integer> showMobNameTags;
    public static ModConfigSpec.ConfigValue<Boolean> invulnerable;
    public static ModConfigSpec.ConfigValue<Boolean> canUseCommands;
    public static ModConfigSpec.ConfigValue<Boolean> canPickupItems;
    public static ModConfigSpec.ConfigValue<Double> maxHealth;
    public static ModConfigSpec.ConfigValue<Boolean> canDrown;
    public static ModConfigSpec.ConfigValue<Boolean> takesFireDamage;
    public static ModConfigSpec.ConfigValue<Boolean> takesWaterDamage;
    public static ModConfigSpec.ConfigValue<Boolean> takesFallDamage;
    public static ModConfigSpec.ConfigValue<Boolean> loop;
    public static ModConfigSpec.ConfigValue<Boolean> shouldPersist;
    public static ModConfigSpec.ConfigValue<String> chatPrefix;
    public static ModConfigSpec.ConfigValue<Boolean> disableSystemMessages;
    public static ModConfigSpec.ConfigValue<String> formatterChar;

    public static void init(ModConfigSpec.Builder common, ModConfigSpec.Builder server, ModConfigSpec.Builder client) {
        common.comment("CosmicNPCs Config");
        common.push("Default NPC settings");
        showPlayerNameTags = common.comment("Defines the nametag visibility of npcs with a player model (0 = invisible, 1 = always visible, 2 = only visible when looked at)").define("cosmicnpcs.showPlayerNameTags", (Object)1);
        showMobNameTags = common.comment("Defines the nametag visibility of npcs with no player model (0 = invisible, 1 = always visible, 2 = only visible when looked at)").define("cosmicnpcs.showMobNameTags", (Object)0);
        invulnerable = common.comment("Defines if npcs should be invulnerable").define("cosmicnpcs.invulnerable", false);
        canUseCommands = common.comment("Defines if npcs should be able to execute commands").define("cosmicnpcs.canUseCommands", false);
        canPickupItems = common.comment("Defines if npcs should be able to pickup items").define("cosmicnpcs.canPickupItems", false);
        maxHealth = common.comment("Defines the maximum health points of npcs").define("cosmicnpcs.maxHealth", (Object)20.0);
        canDrown = common.comment("Defines if npcs should be able to drown").define("cosmicnpcs.canDrown", true);
        takesFireDamage = common.comment("Defines if npcs should take damage from fire or lava").define("cosmicnpcs.takesFireDamage", true);
        takesWaterDamage = common.comment("Defines if npcs should take damage from water or rain").define("cosmicnpcs.takesWaterDamage", false);
        takesFallDamage = common.comment("Defines if npcs should take fall damage").define("cosmicnpcs.takesFallDamage", true);
        loop = common.comment("Defines if npcs should repeat their play-backs after finishing").define("cosmicnpcs.loop", false);
        shouldPersist = common.comment("Defines if npcs should persist in the world after finishing the play-back").define("cosmicnpcs.shouldPersist", false);
        chatPrefix = common.comment("The prefix used for chat messages send by npcs").define("cosmicnpcs.chatPrefix", (Object)"<%s> ");
        common.pop();
        disableSystemMessages = common.comment("(EXPERIMENTAL) if this is enabled, npcs no longer send system chat messages. Doesn't work on multiplayer servers!").define("cosmicnpcs.disableSystemMessages", true);
        formatterChar = common.comment("The char used for formatting npc names").define("cosmicnpcs.formatterChar", (Object)"$");
    }

    public static void loadConfig(ModConfigSpec config, String path) {
        CosmicNPCs.LOGGER.info("Loading config:" + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        CosmicNPCs.LOGGER.info("Built config:" + path);
        file.load();
        CosmicNPCs.LOGGER.info("Loaded config:" + path);
        config.setConfig((CommentedConfig)file);
    }

    static {
        ConfigInit.init(common_builder, server_builder, client_builder);
        common_config = common_builder.build();
        server_config = server_builder.build();
        client_config = client_builder.build();
    }
}

