/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.networking.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record DeltaMovementPacket(double deltaX, double deltaY, double deltaZ) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("cosmicnpcs", "delta_movement");

    public DeltaMovementPacket(FriendlyByteBuf buf) {
        this(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.deltaX());
        buf.writeDouble(this.deltaY());
        buf.writeDouble(this.deltaZ());
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class ClientPayloadHandler {
        private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

        public static ClientPayloadHandler getInstance() {
            return INSTANCE;
        }

        public void handleData(DeltaMovementPacket packet, PlayPayloadContext context) {
            context.workHandler().execute(() -> {
                ServerPlayer player = (ServerPlayer)context.player().get();
                Vec3 vec = new Vec3(packet.deltaX(), packet.deltaY(), packet.deltaZ());
                player.setDeltaMovement(vec);
                System.out.println("DELTA SEND!");
            });
        }
    }
}

