/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.storage.LevelResource;

public class RecordThread
implements Runnable {
    public Thread t;
    Player player;
    public Boolean capture = false;
    RandomAccessFile in;
    Boolean lastTickSwipe = false;
    int[] itemsEquipped = new int[6];
    CompoundTag[] equipedItemsData = new CompoundTag[6];
    List<NPCAction> eventList;

    public RecordThread(Player _player, String capname) {
        Path path = _player.level().getServer().getWorldPath(new LevelResource("cosmicnpcs/recordings"));
        File file = new File("" + path.resolve(capname));
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            this.in = new RandomAccessFile(path + "/" + capname + ".ccap", "rw");
            this.in.setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.player = _player;
        this.capture = true;
        this.eventList = CosmicNPCs.instance.getActionListForPlayer(this.player);
        this.t = new Thread((Runnable)this, "NPC Record Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            this.in.writeShort(60417);
            while (this.capture.booleanValue()) {
                this.trackAndWriteMovement();
                this.trackSwing();
                this.trackHeldItem();
                this.trackHeldItemOffhand();
                this.trackArmor();
                this.writeActions();
                Thread.sleep(25L);
                if (!this.player.isDeadOrDying()) continue;
                this.capture = false;
                CosmicNPCs.instance.recordThreads.remove(this.player);
                MutableComponent msg = Component.literal((String)"Stopped recording ").append(this.player.getDisplayName()).append(". RIP.");
                this.player.sendSystemMessage((Component)msg);
            }
            this.in.close();
        }
        catch (InterruptedException e) {
            System.out.println("Child interrupted.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Exiting child thread.");
    }

    private void trackAndWriteMovement() throws IOException {
        this.in.writeFloat(this.player.yHeadRot);
        this.in.writeFloat(this.player.getYRot());
        this.in.writeFloat(this.player.getXRot());
        this.in.writeDouble(this.player.getX());
        this.in.writeDouble(this.player.getY());
        this.in.writeDouble(this.player.getZ());
        this.in.writeDouble(this.player.getDeltaMovement().x);
        this.in.writeDouble(this.player.getDeltaMovement().y);
        this.in.writeDouble(this.player.getDeltaMovement().z);
        this.in.writeFloat(this.player.fallDistance);
        this.in.writeBoolean(this.player.hasImpulse);
        this.in.writeBoolean(this.player.isShiftKeyDown());
        this.in.writeBoolean(this.player.isSprinting());
        this.in.writeBoolean(this.player.onGround());
        this.in.writeBoolean(this.player.isFallFlying());
        this.in.writeBoolean(this.player.isSwimming());
        if (this.player.isUsingItem()) {
            this.in.writeBoolean(this.player.isUsingItem());
            this.in.writeInt(this.player.getUsedItemHand() == InteractionHand.MAIN_HAND ? 0 : 1);
        } else {
            this.in.writeBoolean(this.player.isUsingItem());
            this.in.writeInt(0);
        }
    }

    private void trackArmor() {
        for (int ci = 1; ci < 5; ++ci) {
            NPCAction ma;
            ItemStack playerArmorPiece = (ItemStack)this.player.getInventory().armor.get(ci - 1);
            if (playerArmorPiece != null) {
                if (Item.getId((Item)playerArmorPiece.getItem()) == this.itemsEquipped[ci] && playerArmorPiece.save(new CompoundTag()).equals((Object)this.equipedItemsData[ci])) continue;
                this.itemsEquipped[ci] = Item.getId((Item)playerArmorPiece.getItem());
                this.equipedItemsData[ci] = playerArmorPiece.save(new CompoundTag());
                ma = new NPCAction(4);
                ma.armorSlot = ci;
                ma.armorId = this.itemsEquipped[ci];
                ma.armorDmg = playerArmorPiece.getDamageValue();
                playerArmorPiece.save(ma.itemData);
                this.eventList.add(ma);
                continue;
            }
            if (this.itemsEquipped[ci] == -1) continue;
            this.itemsEquipped[ci] = -1;
            this.equipedItemsData[ci] = new CompoundTag();
            ma = new NPCAction(4);
            ma.armorSlot = ci;
            ma.armorId = this.itemsEquipped[ci];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItem() {
        ItemStack playerHeldItem = this.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!playerHeldItem.isEmpty()) {
            if (Item.getId((Item)playerHeldItem.getItem()) != this.itemsEquipped[0] || !playerHeldItem.save(new CompoundTag()).equals((Object)this.equipedItemsData[0])) {
                this.itemsEquipped[0] = Item.getId((Item)playerHeldItem.getItem());
                this.equipedItemsData[0] = playerHeldItem.save(new CompoundTag());
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 0;
                ma.armorId = this.itemsEquipped[0];
                ma.armorDmg = playerHeldItem.getDamageValue();
                playerHeldItem.save(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[0] != -1) {
            this.itemsEquipped[0] = -1;
            this.equipedItemsData[0] = new CompoundTag();
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 0;
            ma.armorId = this.itemsEquipped[0];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackHeldItemOffhand() {
        ItemStack playerHeldItem = this.player.getItemInHand(InteractionHand.OFF_HAND);
        if (!playerHeldItem.isEmpty()) {
            if (Item.getId((Item)playerHeldItem.getItem()) != this.itemsEquipped[5] || !playerHeldItem.save(new CompoundTag()).equals((Object)this.equipedItemsData[5])) {
                this.itemsEquipped[5] = Item.getId((Item)playerHeldItem.getItem());
                this.equipedItemsData[5] = playerHeldItem.save(new CompoundTag());
                NPCAction ma = new NPCAction(4);
                ma.armorSlot = 5;
                ma.armorId = this.itemsEquipped[5];
                ma.armorDmg = playerHeldItem.getDamageValue();
                playerHeldItem.save(ma.itemData);
                this.eventList.add(ma);
            }
        } else if (this.itemsEquipped[5] != -1) {
            this.itemsEquipped[5] = -1;
            this.equipedItemsData[0] = new CompoundTag();
            NPCAction ma = new NPCAction(4);
            ma.armorSlot = 5;
            ma.armorId = this.itemsEquipped[5];
            ma.armorDmg = 0;
            this.eventList.add(ma);
        }
    }

    private void trackSwing() {
        if (this.player.swingTime == -1 && this.player.swinging) {
            this.eventList.add(new NPCAction(2));
        }
    }

    private void writeActions() throws IOException {
        if (this.eventList.size() > 0) {
            this.in.writeBoolean(true);
            NPCAction ma = this.eventList.get(0);
            this.in.writeByte(ma.type);
            switch (ma.type) {
                case 1: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    NbtIo.write((CompoundTag)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 4: {
                    this.in.writeInt(ma.armorSlot);
                    this.in.writeInt(ma.armorId);
                    this.in.writeInt(ma.armorDmg);
                    if (ma.armorId == -1) break;
                    NbtIo.write((CompoundTag)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 5: {
                    this.in.writeInt(ma.arrowCharge);
                    break;
                }
                case 7: {
                    this.in.writeInt(ma.stateId);
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    if (!(Block.stateById((int)ma.stateId).getBlock() instanceof SignBlock)) break;
                    NbtIo.write((CompoundTag)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 8: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 9: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    this.in.writeInt(ma.metaData);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    this.in.writeByte((byte)ma.handType.ordinal());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 6: {
                    CosmicNPCs.instance.recordThreads.remove(this.player);
                    MutableComponent msg = Component.literal((String)"Stopped recording ").append(this.player.getDisplayName()).append(". Bye!");
                    this.player.sendSystemMessage((Component)msg);
                    this.capture = false;
                    break;
                }
            }
            this.eventList.remove(0);
        } else {
            this.in.writeBoolean(false);
        }
    }
}

