/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs;

import de.namensammler.cosmicnpcs.common.command.NPCPlayCommand;
import de.namensammler.cosmicnpcs.common.command.NPCRecordCommand;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.events.CommonEvents;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CosmicNPCs
implements ModInitializer {
    public static CosmicNPCs instance;
    public static final Logger LOGGER;
    public static final String MODID = "cosmicnpcs";
    public static String[] storedCommands;
    public static int commandCounter;
    public Map<class_1657, NPCRecorder> recordThreads = Collections.synchronizedMap(new HashMap());

    public CosmicNPCs() {
        instance = this;
    }

    public void onInitialize() {
        CommonEvents.init();
        EntityTypesInit.registerAttributes();
        CommandRegistrationCallback.EVENT.register(NPCRecordCommand::register);
        CommandRegistrationCallback.EVENT.register(NPCPlayCommand::register);
        class_2316.method_10017((String)"centity_summon", CEntitySummonArgument.class, (class_2314)new class_2319(CEntitySummonArgument::entitySummon));
    }

    public static void safeCommandData() {
        class_2487 data = new class_2487();
        data.method_10569("counter", commandCounter);
        data.method_10566("commands", (class_2520)new class_2487());
        for (int i = 0; i < storedCommands.length; ++i) {
            if (storedCommands[i] == null) continue;
            data.method_10562("commands").method_10582("cmd_" + i, storedCommands[i]);
        }
        File file = new File("config/cosmicnpcs/commands.dat");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            class_2507.method_10634((class_2487)data, (OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
    }

    public static void loadCommandData() {
        class_2487 data = new class_2487();
        try {
            data = class_2507.method_30613((File)new File("config/cosmicnpcs/commands.dat"));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.fillInStackTrace());
        }
        if (data.method_10550("counter") != 0) {
            commandCounter = data.method_10550("counter");
        }
        for (int i = 0; i < 99; ++i) {
            CosmicNPCs.storedCommands[i] = data.method_10562("commands").method_10558("cmd_" + i);
        }
    }

    public List<NPCAction> getActionListForPlayer(class_1657 ep) {
        NPCRecorder aRecorder = this.recordThreads.get(ep);
        if (aRecorder == null) {
            return null;
        }
        return aRecorder.eventsList;
    }

    static {
        LOGGER = LogManager.getLogger();
        storedCommands = new String[99];
        commandCounter = 1;
    }
}

