/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_768;

@Environment(value=EnvType.CLIENT)
public class CCommandSuggestionHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private static final class_2583 EMPTY_ERROR_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final class_2583 EMPTY_PASS_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final List<class_2583> COMMAND_COLOR_STYLES = (List)Stream.of(class_124.field_1075, class_124.field_1054, class_124.field_1060, class_124.field_1076, class_124.field_1065).map(arg_0 -> ((class_2583)class_2583.field_24360).method_10977(arg_0)).collect(ImmutableList.toImmutableList());
    private final class_310 mc;
    private final class_437 screen;
    private final class_342 inputField;
    private final class_327 font;
    private final boolean commandsOnly;
    private final boolean hasCursor;
    private final int minAmountRendered;
    private final int maxAmountRendered;
    private final boolean isChat;
    private final int color;
    private final List<class_5481> exceptionList = Lists.newArrayList();
    private int x;
    private int width;
    private ParseResults<class_2172> parseResults;
    private CompletableFuture<com.mojang.brigadier.suggestion.Suggestions> suggestionsFuture;
    private Suggestions suggestions;
    private boolean autoSuggest;
    private boolean isApplyingSuggestion;
    private int yPos;

    public CCommandSuggestionHelper(class_310 mc, class_437 screen, class_342 inputField, class_327 font, boolean commandsOnly, boolean hasCursor, int minAmountRendered, int maxAmountRendered, int yPos, int color) {
        this.mc = mc;
        this.screen = screen;
        this.inputField = inputField;
        this.font = font;
        this.commandsOnly = commandsOnly;
        this.hasCursor = hasCursor;
        this.minAmountRendered = minAmountRendered;
        this.maxAmountRendered = maxAmountRendered;
        this.isChat = false;
        this.yPos = yPos;
        this.color = color;
        inputField.method_1854(this::getParsedSuggestion);
    }

    public void shouldAutoSuggest(boolean autoSuggest) {
        this.autoSuggest = autoSuggest;
        if (!autoSuggest) {
            this.suggestions = null;
        }
    }

    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions != null && this.suggestions.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.screen.method_25399() == this.inputField && keyCode == 258) {
            this.updateSuggestions(true);
            return true;
        }
        return false;
    }

    public boolean onScroll(double delta) {
        return this.suggestions != null && this.suggestions.onScroll(class_3532.method_15350((double)delta, (double)-1.0, (double)1.0));
    }

    public boolean onClick(double mouseX, double mouseY, int mouseButton) {
        return this.suggestions != null && this.suggestions.onClick((int)mouseX, (int)mouseY, mouseButton);
    }

    public void updateSuggestions(boolean narrateFirstSuggestion) {
        com.mojang.brigadier.suggestion.Suggestions suggestions;
        if (this.suggestionsFuture != null && this.suggestionsFuture.isDone() && !(suggestions = this.suggestionsFuture.join()).isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                i = Math.max(i, this.font.method_1727(suggestion.getText()));
            }
            int j = class_3532.method_15340((int)this.inputField.method_1889(suggestions.getRange().getStart()), (int)0, (int)(this.inputField.method_1889(0) + this.inputField.method_1859() - i));
            int k = this.yPos;
            this.suggestions = new Suggestions(j, k, i, this.getSuggestions(suggestions), narrateFirstSuggestion);
        }
    }

    private List<Suggestion> getSuggestions(com.mojang.brigadier.suggestion.Suggestions suggestions) {
        String s = this.inputField.method_1882().substring(0, this.inputField.method_1881());
        int i = CCommandSuggestionHelper.getLastWhitespace(s);
        String s1 = s.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (!suggestion.getText().startsWith(s1) && !suggestion.getText().startsWith("minecraft:" + s1)) {
                list1.add(suggestion);
                continue;
            }
            list.add(suggestion);
        }
        list.addAll(list1);
        return list;
    }

    public void init() {
        boolean flag;
        String s = this.inputField.method_1882();
        if (this.parseResults != null && !this.parseResults.getReader().getString().equals(s)) {
            this.parseResults = null;
        }
        if (!this.isApplyingSuggestion) {
            this.inputField.method_1887((String)null);
            this.suggestions = null;
        }
        this.exceptionList.clear();
        StringReader stringreader = new StringReader(s);
        boolean bl = flag = stringreader.canRead() && stringreader.peek() == '/';
        if (flag) {
            stringreader.skip();
        }
        boolean flag1 = this.commandsOnly || flag;
        int i = this.inputField.method_1881();
        if (flag1) {
            int j;
            CommandDispatcher commanddispatcher = this.mc.field_1724.field_3944.method_2886();
            if (this.parseResults == null) {
                this.parseResults = commanddispatcher.parse(stringreader, (Object)this.mc.field_1724.field_3944.method_2875());
            }
            int n = j = this.hasCursor ? stringreader.getCursor() : 1;
            if (!(i < j || this.suggestions != null && this.isApplyingSuggestion)) {
                this.suggestionsFuture = commanddispatcher.getCompletionSuggestions(this.parseResults, i);
                this.suggestionsFuture.thenRun(() -> {
                    if (this.suggestionsFuture.isDone()) {
                        this.recompileSuggestions();
                    }
                });
            }
        } else {
            String s1 = s.substring(0, i);
            int k = CCommandSuggestionHelper.getLastWhitespace(s1);
            Collection collection = this.mc.field_1724.field_3944.method_2875().method_9262();
            this.suggestionsFuture = class_2172.method_9265((Iterable)collection, (SuggestionsBuilder)new SuggestionsBuilder(s1, k));
        }
    }

    private static int getLastWhitespace(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    private static class_5481 parseException(CommandSyntaxException exception) {
        class_2561 itextcomponent = class_2564.method_10883((Message)exception.getRawMessage());
        String s = exception.getContext();
        return s == null ? itextcomponent.method_30937() : new class_2588("command.context.parse_error", new Object[]{itextcomponent, exception.getCursor(), s}).method_30937();
    }

    private void recompileSuggestions() {
        if (this.inputField.method_1881() == this.inputField.method_1882().length()) {
            if (this.suggestionsFuture.join().isEmpty() && !this.parseResults.getExceptions().isEmpty()) {
                int i = 0;
                for (Map.Entry entry : this.parseResults.getExceptions().entrySet()) {
                    CommandSyntaxException commandsyntaxexception = (CommandSyntaxException)entry.getValue();
                    if (commandsyntaxexception.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                        ++i;
                        continue;
                    }
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(commandsyntaxexception));
                }
                if (i > 0) {
                    this.exceptionList.add(CCommandSuggestionHelper.parseException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create()));
                }
            } else if (this.parseResults.getReader().canRead()) {
                this.exceptionList.add(CCommandSuggestionHelper.parseException(class_2170.method_23917(this.parseResults)));
            }
        }
        this.x = 0;
        this.width = this.screen.field_22789;
        if (this.exceptionList.isEmpty()) {
            this.applyFormattingToCommand(class_124.field_1080);
        }
        this.suggestions = null;
        if (this.autoSuggest && this.mc.field_1690.field_1873) {
            this.updateSuggestions(false);
        }
    }

    private void applyFormattingToCommand(class_124 formatting) {
        CommandContextBuilder commandcontextbuilder = this.parseResults.getContext();
        SuggestionContext suggestioncontext = commandcontextbuilder.findSuggestionContext(this.inputField.method_1881());
        Map map = this.mc.field_1724.field_3944.method_2886().getSmartUsage(suggestioncontext.parent, (Object)this.mc.field_1724.field_3944.method_2875());
        ArrayList list = Lists.newArrayList();
        int i = 0;
        class_2583 style = class_2583.field_24360.method_10977(formatting);
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            list.add(class_5481.method_30747((String)((String)entry.getValue()), (class_2583)style));
            i = Math.max(i, this.font.method_1727((String)entry.getValue()));
        }
        if (!list.isEmpty()) {
            this.exceptionList.addAll(list);
            this.x = class_3532.method_15340((int)this.inputField.method_1889(suggestioncontext.startPos), (int)0, (int)(this.inputField.method_1889(0) + this.inputField.method_1859() - i));
            this.width = i;
        }
    }

    private class_5481 getParsedSuggestion(String command, int maxLength) {
        return this.parseResults != null ? CCommandSuggestionHelper.getFinalSuggestion(this.parseResults, command, maxLength) : class_5481.method_30747((String)command, (class_2583)class_2583.field_24360);
    }

    @Nullable
    private static String getMatchedSuggestionText(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    private static class_5481 getFinalSuggestion(ParseResults<class_2172> provider, String command, int maxLength) {
        int i1;
        ArrayList list = Lists.newArrayList();
        int i = 0;
        int j = -1;
        CommandContextBuilder commandcontextbuilder = provider.getContext().getLastChild();
        for (ParsedArgument parsedargument : commandcontextbuilder.getArguments().values()) {
            int k;
            if (++j >= COMMAND_COLOR_STYLES.size()) {
                j = 0;
            }
            if ((k = Math.max(parsedargument.getRange().getStart() - maxLength, 0)) >= command.length()) break;
            int l = Math.min(parsedargument.getRange().getEnd() - maxLength, command.length());
            if (l <= 0) continue;
            list.add(class_5481.method_30747((String)command.substring(i, k), (class_2583)EMPTY_PASS_STYLE));
            list.add(class_5481.method_30747((String)command.substring(k, l), (class_2583)COMMAND_COLOR_STYLES.get(j)));
            i = l;
        }
        if (provider.getReader().canRead() && (i1 = Math.max(provider.getReader().getCursor() - maxLength, 0)) < command.length()) {
            int j1 = Math.min(i1 + provider.getReader().getRemainingLength(), command.length());
            list.add(class_5481.method_30747((String)command.substring(i, i1), (class_2583)EMPTY_PASS_STYLE));
            list.add(class_5481.method_30747((String)command.substring(i1, j1), (class_2583)EMPTY_ERROR_STYLE));
            i = j1;
        }
        list.add(class_5481.method_30747((String)command.substring(i), (class_2583)EMPTY_PASS_STYLE));
        return class_5481.method_30749((List)list);
    }

    public void drawSuggestionList(class_4587 PoseStack, int mouseX, int mouseY) {
        if (this.suggestions != null) {
            this.suggestions.drawSuggestions(PoseStack, mouseX, mouseY);
        } else {
            int i = 0;
            for (class_5481 FormattedCharSequence : this.exceptionList) {
                int j = this.yPos + 12 * i;
                ++i;
            }
        }
    }

    public String getSuggestionMessage() {
        return this.suggestions != null ? "\n" + this.suggestions.getCurrentSuggestionMessage() : "";
    }

    @Environment(value=EnvType.CLIENT)
    public class Suggestions {
        private final class_768 suggestionRenderBox;
        private final String originalInputText;
        private final List<Suggestion> suggestions;
        private int lowestDisplayedSuggestionIndex;
        private int selectedIndex;
        private class_241 lastMousePosition = class_241.field_1340;
        private boolean changeSelectionOnNextTabInput;
        private int lastObtainedSuggestionMessageIndex;

        private Suggestions(int x, int y, int width, List<Suggestion> suggestions, boolean narrateFirstSuggestion) {
            int i = x - 1;
            int j = CCommandSuggestionHelper.this.isChat ? y - 3 - Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12 : y;
            this.suggestionRenderBox = new class_768(i, j, width + 1, Math.min(suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered) * 12);
            this.originalInputText = CCommandSuggestionHelper.this.inputField.method_1882();
            this.lastObtainedSuggestionMessageIndex = narrateFirstSuggestion ? -1 : 0;
            this.suggestions = suggestions;
            this.selectSuggestion(0);
        }

        public void drawSuggestions(class_4587 PoseStack, int mouseX, int mouseY) {
            Message message;
            boolean flag3;
            int i = Math.min(this.suggestions.size(), CCommandSuggestionHelper.this.maxAmountRendered);
            int j = -5592406;
            boolean flag = this.lowestDisplayedSuggestionIndex > 0;
            boolean flag1 = this.suggestions.size() > this.lowestDisplayedSuggestionIndex + i;
            boolean flag2 = flag || flag1;
            boolean bl = flag3 = this.lastMousePosition.field_1343 != (float)mouseX || this.lastMousePosition.field_1342 != (float)mouseY;
            if (flag3) {
                this.lastMousePosition = new class_241((float)mouseX, (float)mouseY);
            }
            if (flag2) {
                class_332.method_25294((class_4587)PoseStack, (int)this.suggestionRenderBox.method_3321(), (int)(this.suggestionRenderBox.method_3322() - 1), (int)(this.suggestionRenderBox.method_3321() + this.suggestionRenderBox.method_3319()), (int)this.suggestionRenderBox.method_3322(), (int)CCommandSuggestionHelper.this.color);
                class_332.method_25294((class_4587)PoseStack, (int)this.suggestionRenderBox.method_3321(), (int)(this.suggestionRenderBox.method_3322() + this.suggestionRenderBox.method_3320()), (int)(this.suggestionRenderBox.method_3321() + this.suggestionRenderBox.method_3319()), (int)(this.suggestionRenderBox.method_3322() + this.suggestionRenderBox.method_3320() + 1), (int)CCommandSuggestionHelper.this.color);
                if (flag) {
                    for (int k = 0; k < this.suggestionRenderBox.method_3319(); ++k) {
                        if (k % 2 != 0) continue;
                        class_332.method_25294((class_4587)PoseStack, (int)(this.suggestionRenderBox.method_3321() + k), (int)(this.suggestionRenderBox.method_3322() - 1), (int)(this.suggestionRenderBox.method_3321() + k + 1), (int)this.suggestionRenderBox.method_3322(), (int)-1);
                    }
                }
                if (flag1) {
                    for (int i1 = 0; i1 < this.suggestionRenderBox.method_3319(); ++i1) {
                        if (i1 % 2 != 0) continue;
                        class_332.method_25294((class_4587)PoseStack, (int)(this.suggestionRenderBox.method_3321() + i1), (int)(this.suggestionRenderBox.method_3322() + this.suggestionRenderBox.method_3320()), (int)(this.suggestionRenderBox.method_3321() + i1 + 1), (int)(this.suggestionRenderBox.method_3322() + this.suggestionRenderBox.method_3320() + 1), (int)-1);
                    }
                }
            }
            boolean flag4 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestions.get(l + this.lowestDisplayedSuggestionIndex);
                class_332.method_25294((class_4587)PoseStack, (int)this.suggestionRenderBox.method_3321(), (int)(this.suggestionRenderBox.method_3322() + 12 * l), (int)(this.suggestionRenderBox.method_3321() + this.suggestionRenderBox.method_3319()), (int)(this.suggestionRenderBox.method_3322() + 12 * l + 12), (int)CCommandSuggestionHelper.this.color);
                if (mouseX > this.suggestionRenderBox.method_3321() && mouseX < this.suggestionRenderBox.method_3321() + this.suggestionRenderBox.method_3319() && mouseY > this.suggestionRenderBox.method_3322() + 12 * l && mouseY < this.suggestionRenderBox.method_3322() + 12 * l + 12) {
                    if (flag3) {
                        this.selectSuggestion(l + this.lowestDisplayedSuggestionIndex);
                    }
                    flag4 = true;
                }
                CCommandSuggestionHelper.this.font.method_1720(PoseStack, suggestion.getText(), (float)(this.suggestionRenderBox.method_3321() + 1), (float)(this.suggestionRenderBox.method_3322() + 2 + 12 * l), l + this.lowestDisplayedSuggestionIndex == this.selectedIndex ? -256 : -5592406);
            }
            if (flag4 && (message = this.suggestions.get(this.selectedIndex).getTooltip()) != null) {
                CCommandSuggestionHelper.this.screen.method_25424(PoseStack, class_2564.method_10883((Message)message), mouseX, mouseY);
            }
        }

        public boolean onClick(int mouseX, int mouseY, int mouseButton) {
            if (!this.suggestionRenderBox.method_3318(mouseX, mouseY)) {
                return false;
            }
            int i = (mouseY - this.suggestionRenderBox.method_3322()) / 12 + this.lowestDisplayedSuggestionIndex;
            if (i >= 0 && i < this.suggestions.size()) {
                this.selectSuggestion(i);
                this.applySuggestionToInput();
            }
            return true;
        }

        public boolean onScroll(double delta) {
            int j;
            int i = (int)(CCommandSuggestionHelper.this.mc.field_1729.method_1603() * (double)CCommandSuggestionHelper.this.mc.method_22683().method_4486() / (double)CCommandSuggestionHelper.this.mc.method_22683().method_4480());
            if (this.suggestionRenderBox.method_3318(i, j = (int)(CCommandSuggestionHelper.this.mc.field_1729.method_1604() * (double)CCommandSuggestionHelper.this.mc.method_22683().method_4502() / (double)CCommandSuggestionHelper.this.mc.method_22683().method_4507()))) {
                this.lowestDisplayedSuggestionIndex = class_3532.method_15340((int)((int)((double)this.lowestDisplayedSuggestionIndex - delta)), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
                return true;
            }
            return false;
        }

        public boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 265) {
                this.changeSelection(-1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 264) {
                this.changeSelection(1);
                this.changeSelectionOnNextTabInput = false;
                return true;
            }
            if (keyCode == 258) {
                if (this.changeSelectionOnNextTabInput) {
                    this.changeSelection(class_437.method_25442() ? -1 : 1);
                }
                this.applySuggestionToInput();
                return true;
            }
            if (keyCode == 256) {
                this.clearSuggestions();
                return true;
            }
            return false;
        }

        public void changeSelection(int change) {
            this.selectSuggestion(this.selectedIndex + change);
            int i = this.lowestDisplayedSuggestionIndex;
            int j = this.lowestDisplayedSuggestionIndex + CCommandSuggestionHelper.this.maxAmountRendered - 1;
            if (this.selectedIndex < i) {
                this.lowestDisplayedSuggestionIndex = class_3532.method_15340((int)this.selectedIndex, (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            } else if (this.selectedIndex > j) {
                this.lowestDisplayedSuggestionIndex = class_3532.method_15340((int)(this.selectedIndex + CCommandSuggestionHelper.this.minAmountRendered - CCommandSuggestionHelper.this.maxAmountRendered), (int)0, (int)Math.max(this.suggestions.size() - CCommandSuggestionHelper.this.maxAmountRendered, 0));
            }
        }

        public void selectSuggestion(int index) {
            this.selectedIndex = index;
            if (this.selectedIndex < 0) {
                this.selectedIndex += this.suggestions.size();
            }
            if (this.selectedIndex >= this.suggestions.size()) {
                this.selectedIndex -= this.suggestions.size();
            }
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.inputField.method_1887(CCommandSuggestionHelper.getMatchedSuggestionText(CCommandSuggestionHelper.this.inputField.method_1882(), suggestion.apply(this.originalInputText)));
            if (class_333.field_2054.method_1791() && this.lastObtainedSuggestionMessageIndex != this.selectedIndex) {
                class_333.field_2054.method_37015(this.getCurrentSuggestionMessage());
            }
        }

        public void applySuggestionToInput() {
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = true;
            CCommandSuggestionHelper.this.inputField.method_1852(suggestion.apply(this.originalInputText));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            CCommandSuggestionHelper.this.inputField.method_1875(i);
            CCommandSuggestionHelper.this.inputField.method_1884(i);
            this.selectSuggestion(this.selectedIndex);
            CCommandSuggestionHelper.this.isApplyingSuggestion = false;
            this.changeSelectionOnNextTabInput = true;
        }

        private class_2561 getCurrentSuggestionMessage() {
            this.lastObtainedSuggestionMessageIndex = this.selectedIndex;
            Suggestion suggestion = this.suggestions.get(this.selectedIndex);
            Message message = suggestion.getTooltip();
            return message != null ? new class_2588("narration.suggestion.tooltip", new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText(), message.getString()}) : new class_2588("narration.suggestion", new Object[]{this.selectedIndex + 1, this.suggestions.size(), suggestion.getText()});
        }

        public void clearSuggestions() {
            CCommandSuggestionHelper.this.suggestions = null;
        }
    }
}

