/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity;

import com.google.common.collect.Lists;
import de.namensammler.cosmicnpcs.client.renderer.entity.CustomLivingRenderer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CAbstractEyesLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CCatCollarLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CDrownedOuterLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CEnergyLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CHeldBlockLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLeatherHorseArmorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CLlamaDecorLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CMooshroomMushroomLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CPlayerItemInHandLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSaddleLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSheepWoolLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSlimeGelLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CSnowmanHeadLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CStrayClothingLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CVillagerLevelPendantLayer;
import de.namensammler.cosmicnpcs.client.renderer.entity.layers.CWolfCollarLayer;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_1000;
import net.minecraft.class_1002;
import net.minecraft.class_1004;
import net.minecraft.class_1006;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1473;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1501;
import net.minecraft.class_1560;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3304;
import net.minecraft.class_3532;
import net.minecraft.class_3680;
import net.minecraft.class_3684;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3883;
import net.minecraft.class_3885;
import net.minecraft.class_3887;
import net.minecraft.class_4073;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4999;
import net.minecraft.class_549;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_578;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_608;
import net.minecraft.class_624;
import net.minecraft.class_887;
import net.minecraft.class_890;
import net.minecraft.class_894;
import net.minecraft.class_897;
import net.minecraft.class_910;
import net.minecraft.class_921;
import net.minecraft.class_922;
import net.minecraft.class_926;
import net.minecraft.class_929;
import net.minecraft.class_933;
import net.minecraft.class_941;
import net.minecraft.class_948;
import net.minecraft.class_949;
import net.minecraft.class_950;
import net.minecraft.class_964;
import net.minecraft.class_969;
import net.minecraft.class_970;
import net.minecraft.class_974;
import net.minecraft.class_975;
import net.minecraft.class_976;
import net.minecraft.class_979;
import net.minecraft.class_980;
import net.minecraft.class_985;
import net.minecraft.class_988;
import net.minecraft.class_991;
import net.minecraft.class_992;
import net.minecraft.class_993;
import net.minecraft.class_994;
import net.minecraft.class_996;
import net.minecraft.class_997;

public class CosmicNPCRenderer
extends class_922<CosmicNPCEntity, class_591<CosmicNPCEntity>> {
    MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
    private Map<String, CustomLivingRenderer> modelRenderers = new HashMap<String, CustomLivingRenderer>();
    private static class_591<CosmicNPCEntity> player_model;
    private static class_591<CosmicNPCEntity> player_model_slim;
    private static final class_2960 STEVE_TEXTURE;
    private static final class_2960 ALEX_TEXTURE;
    private static class_5617.class_5618 renderContext;

    public CosmicNPCRenderer(class_5617.class_5618 renderContext) {
        super(renderContext, (class_583)new class_591(renderContext.method_32167(class_5602.field_27577), false), 0.5f);
        player_model = new class_591(renderContext.method_32167(class_5602.field_27577), false);
        player_model_slim = new class_591(renderContext.method_32167(class_5602.field_27581), true);
        this.method_4046((class_3887)new class_970((class_3883)this, new class_572(renderContext.method_32167(class_5602.field_27579)), new class_572(renderContext.method_32167(class_5602.field_27580))));
        this.method_4046((class_3887)new CPlayerItemInHandLayer(this));
        this.method_4046((class_3887)new class_976((class_3883)this, renderContext.method_32170()));
        this.method_4046((class_3887)new class_979((class_3883)this, renderContext.method_32170()));
        CosmicNPCRenderer.renderContext = renderContext;
    }

    protected void scale(CosmicNPCEntity entitylivingbaseIn, class_4587 poseStack, float partialTickTime) {
        poseStack.method_22905(0.9375f, 0.9375f, 0.9375f);
    }

    public class_2960 getTextureLocation(CosmicNPCEntity npc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/main/" + npc.getTextureName() + ".png");
        if (npc.getTextureName() != "default" && textureFile.exists()) {
            return new class_2960("npctextures", "textures/main/" + npc.getTextureName() + ".png");
        }
        return npc.getModel().equals((Object)new class_2960("minecraft:player_slim")) ? ALEX_TEXTURE : STEVE_TEXTURE;
    }

    public void render(CosmicNPCEntity npc, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        if (npc.getModel().equals((Object)new class_2960("minecraft:player_slim"))) {
            this.field_4737 = player_model_slim;
            this.field_4673 = 0.5f;
            this.setModelProperties(npc);
            super.method_4054((class_1309)npc, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        } else if (npc.getModel().equals((Object)new class_2960("minecraft:player"))) {
            this.field_4737 = player_model;
            this.field_4673 = 0.5f;
            this.setModelProperties(npc);
            super.method_4054((class_1309)npc, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        } else {
            class_1299.method_5898((String)npc.getModel().toString()).ifPresent(entityType -> {
                if (entityType.method_5883(npc.field_6002) instanceof class_1309) {
                    class_1309 modelEntity = (class_1309)entityType.method_5883(npc.field_6002);
                    if (this.field_4676.method_3953((class_1297)(modelEntity = this.copyEntityData(modelEntity, npc))) instanceof class_922) {
                        class_922 modelEntityRenderer = (class_922)this.field_4676.method_3953((class_1297)modelEntity);
                        class_583 model = modelEntityRenderer.method_4038();
                        if (!this.modelRenderers.containsKey(npc.getModel().toString() + npc.getSettings().toString())) {
                            this.field_4673 = this.getShadowSize((class_922<class_1309, class_583<class_1309>>)modelEntityRenderer);
                            if (npc.getSettings().method_10577("IsChild")) {
                                this.field_4673 *= 0.5f;
                            }
                            this.modelRenderers.put(npc.getModel().toString() + npc.getSettings().toString(), new CustomLivingRenderer(renderContext, (class_922<class_1309, class_583<class_1309>>)modelEntityRenderer, npc, this.getLayers(modelEntityRenderer, npc)));
                        } else {
                            CustomLivingRenderer customRenderer = this.modelRenderers.get(npc.getModel().toString() + npc.getSettings().toString());
                            customRenderer.npc = npc;
                            customRenderer.method_4054(modelEntity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
                        }
                    }
                }
            });
        }
    }

    private class_1309 copyEntityData(class_1309 modelEntity, CosmicNPCEntity npc) {
        modelEntity.field_6266 = npc.field_6266;
        modelEntity.field_6251 = npc.field_6251;
        modelEntity.field_6229 = npc.field_6229;
        modelEntity.field_6012 = npc.field_6012;
        modelEntity.method_5838(npc.method_5628());
        modelEntity.method_5641(npc.method_23317(), npc.method_23318(), npc.method_23321(), npc.method_36454(), npc.method_36455());
        modelEntity.field_5982 = npc.field_5982;
        modelEntity.field_6004 = npc.field_6004;
        modelEntity.field_6241 = npc.field_6241;
        modelEntity.field_6259 = npc.field_6259;
        modelEntity.field_6283 = npc.field_6283;
        modelEntity.field_6220 = npc.field_6220;
        modelEntity.field_6249 = npc.field_6249;
        modelEntity.field_6225 = npc.field_6225;
        modelEntity.field_6211 = npc.field_6211;
        modelEntity.field_6235 = npc.field_6235;
        modelEntity.method_5673(class_1304.field_6173, npc.method_6047());
        modelEntity.method_5673(class_1304.field_6171, npc.method_6079());
        modelEntity.method_5673(class_1304.field_6169, npc.method_6118(class_1304.field_6169));
        modelEntity.method_5673(class_1304.field_6174, npc.method_6118(class_1304.field_6174));
        modelEntity.method_5673(class_1304.field_6172, npc.method_6118(class_1304.field_6172));
        modelEntity.method_5673(class_1304.field_6166, npc.method_6118(class_1304.field_6166));
        modelEntity.method_18380(npc.method_18376());
        modelEntity.method_5660(npc.method_5715());
        modelEntity.method_5665(npc.method_5797());
        modelEntity.method_5880(npc.method_5807());
        modelEntity.method_5648(npc.method_5767());
        class_3854 type = (class_3854)class_2378.field_17166.method_10223(new class_2960(npc.getSettings().method_10558("VillagerType")));
        class_3852 profession = class_2378.field_17167.method_17966(new class_2960(npc.getSettings().method_10558("Profession"))).orElse(class_3852.field_17052);
        int profLevel = npc.getSettings().method_10550("ProfessionLevel");
        if (npc.getSettings().method_10558("Profession").equals("default") && npc.getSettings().method_10558("ProfessionLevel").equals("default")) {
            profession = class_3852.field_17051;
        }
        class_3850 data = new class_3850(type, profession, profLevel);
        if (modelEntity instanceof class_1646) {
            class_1646 villager = (class_1646)modelEntity;
            villager.method_7195(data);
            villager.method_7217(npc.getSettings().method_10577("IsChild"));
            return villager;
        }
        if (modelEntity instanceof class_1641) {
            class_1641 zVillager = (class_1641)modelEntity;
            zVillager.method_7195(data);
            return zVillager;
        }
        if (modelEntity instanceof class_1560) {
            class_1560 enderman = (class_1560)modelEntity;
            enderman.method_7032(null);
            return enderman;
        }
        if (modelEntity instanceof class_1308) {
            class_1308 mobEntity = (class_1308)modelEntity;
            mobEntity.method_7217(npc.getSettings().method_10577("IsChild"));
            if (npc.method_6047().method_7909() instanceof class_1753 && npc.method_6115()) {
                mobEntity.method_19540(true);
            }
            return mobEntity;
        }
        return modelEntity;
    }

    private List<class_3887<class_1309, class_583<class_1309>>> getLayers(class_922 renderer, CosmicNPCEntity npc) {
        List layerRenderers = Lists.newArrayList();
        ArrayList newLayerRenderers = Lists.newArrayList();
        try {
            Field layerRenderersField = null;
            layerRenderersField = class_922.class.getDeclaredField(this.resolver.mapFieldName("intermediary", this.resolver.unmapClassName("intermediary", class_922.class.getName()), "field_4738", "Ljava/util/List;"));
            layerRenderersField.setAccessible(true);
            layerRenderers = (List)layerRenderersField.get(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < layerRenderers.size(); ++i) {
            class_948 snowmanRenderer;
            class_894 endermanRenderer;
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_3885.class)) {
                newLayerRenderers.add(new CVillagerLevelPendantLayer(renderer, (class_3304)class_310.method_1551().method_1478(), "villager", npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_994.class)) {
                class_941 sheepRenderer = (class_941)renderer;
                newLayerRenderers.add(new CSheepWoolLayer(sheepRenderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_985.class)) {
                endermanRenderer = (class_894)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(endermanRenderer, npc, CAbstractEyesLayer.EyeType.ENDERMAN));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_1000.class)) {
                class_949 spiderRenderer = (class_949)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(spiderRenderer, npc, CAbstractEyesLayer.EyeType.SPIDER));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_993.class)) {
                class_933 phantomRenderer = (class_933)renderer;
                newLayerRenderers.add(new CAbstractEyesLayer(phantomRenderer, npc, CAbstractEyesLayer.EyeType.PHANTOM));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_1002.class)) {
                class_950 strayRenderer = (class_950)renderer;
                newLayerRenderers.add(new CStrayClothingLayer(strayRenderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_980.class)) {
                class_890 drownedRenderer = (class_890)renderer;
                newLayerRenderers.add(new CDrownedOuterLayer(drownedRenderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_991.class)) {
                class_926 mooshroomRenderer = (class_926)renderer;
                newLayerRenderers.add(new CMooshroomMushroomLayer(mooshroomRenderer, npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_988.class)) {
                class_921 llamaRenderer = (class_921)renderer;
                newLayerRenderers.add(new CLlamaDecorLayer((class_3883<class_1501, class_578<class_1501>>)llamaRenderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_3684.class)) {
                class_929 catRenderer = (class_929)renderer;
                newLayerRenderers.add(new CCatCollarLayer((class_3883<class_1451, class_3680<class_1451>>)catRenderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_974.class)) {
                class_887 creeperRenderer = (class_887)renderer;
                newLayerRenderers.add(new CEnergyLayer(creeperRenderer, renderContext.method_32170(), npc, CEnergyLayer.Type.CREEPER));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_1004.class)) {
                class_964 witherRenderer = (class_964)renderer;
                newLayerRenderers.add(new CEnergyLayer(witherRenderer, renderContext.method_32170(), npc, CEnergyLayer.Type.WITHER));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_4073.class)) {
                class_910 horseRenderer = (class_910)renderer;
                newLayerRenderers.add(new CLeatherHorseArmorLayer((class_3883<class_1498, class_549<class_1498>>)horseRenderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_992.class)) {
                if (renderer instanceof class_4999) {
                    newLayerRenderers.add(new CSaddleLayer(renderer, renderer.method_4038(), new class_2960("textures/entity/strider/strider_saddle.png"), npc));
                    continue;
                }
                newLayerRenderers.add(new CSaddleLayer(renderer, renderer.method_4038(), new class_2960("textures/entity/pig/pig_saddle.png"), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_997.class)) {
                newLayerRenderers.add(new CSlimeGelLayer(renderer, renderContext.method_32170(), npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_996.class)) {
                snowmanRenderer = (class_948)renderer;
                newLayerRenderers.add(new CSnowmanHeadLayer((class_3883<class_1473, class_608<class_1473>>)snowmanRenderer, npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_1006.class)) {
                snowmanRenderer = (class_969)renderer;
                newLayerRenderers.add(new CWolfCollarLayer((class_3883<class_1493, class_624<class_1493>>)snowmanRenderer, npc));
                continue;
            }
            if (((class_3887)layerRenderers.get(i)).getClass().equals(class_975.class)) {
                endermanRenderer = (class_894)renderer;
                newLayerRenderers.add(new CHeldBlockLayer(endermanRenderer));
                continue;
            }
            newLayerRenderers.add((class_3887)layerRenderers.get(i));
        }
        return newLayerRenderers;
    }

    private float getShadowSize(class_922<class_1309, class_583<class_1309>> renderer) {
        float shadowSize = 0.5f;
        try {
            Field shadowSizeField = null;
            shadowSizeField = class_897.class.getDeclaredField(this.resolver.mapFieldName("intermediary", this.resolver.unmapClassName("intermediary", class_897.class.getName()), "field_4673", "F"));
            shadowSizeField.setAccessible(true);
            shadowSize = shadowSizeField.getFloat(renderer);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return shadowSize;
    }

    private void setModelProperties(CosmicNPCEntity p_117819_) {
        class_591 playermodel = (class_591)this.method_4038();
        if (p_117819_.method_7325()) {
            playermodel.method_2805(false);
            playermodel.field_3398.field_3665 = true;
            playermodel.field_3394.field_3665 = true;
        } else {
            playermodel.method_2805(true);
            playermodel.field_3400 = p_117819_.method_18276();
            class_572.class_573 humanoidmodel$armpose = CosmicNPCRenderer.getArmPose(p_117819_, class_1268.field_5808);
            class_572.class_573 humanoidmodel$armpose1 = CosmicNPCRenderer.getArmPose(p_117819_, class_1268.field_5810);
            if (humanoidmodel$armpose.method_30156()) {
                class_572.class_573 class_5732 = humanoidmodel$armpose1 = p_117819_.method_6079().method_7960() ? class_572.class_573.field_3409 : class_572.class_573.field_3410;
            }
            if (p_117819_.method_6068() == class_1306.field_6183) {
                playermodel.field_3395 = humanoidmodel$armpose;
                playermodel.field_3399 = humanoidmodel$armpose1;
            } else {
                playermodel.field_3395 = humanoidmodel$armpose1;
                playermodel.field_3399 = humanoidmodel$armpose;
            }
        }
    }

    private static class_572.class_573 getArmPose(CosmicNPCEntity player, class_1268 handSide) {
        class_1799 itemstack = player.method_5998(handSide);
        if (itemstack.method_7960()) {
            return class_572.class_573.field_3409;
        }
        if (player.method_6058() == handSide && player.method_6014() > 0) {
            class_1839 useanim = itemstack.method_7976();
            if (useanim == class_1839.field_8949) {
                return class_572.class_573.field_3406;
            }
            if (useanim == class_1839.field_8953) {
                return class_572.class_573.field_3403;
            }
            if (useanim == class_1839.field_8951) {
                return class_572.class_573.field_3407;
            }
            if (useanim == class_1839.field_8947 && handSide == player.method_6058()) {
                return class_572.class_573.field_3405;
            }
            if (useanim == class_1839.field_27079) {
                return class_572.class_573.field_27434;
            }
        } else if (!player.field_6252 && itemstack.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)itemstack)) {
            return class_572.class_573.field_3408;
        }
        return class_572.class_573.field_3410;
    }

    protected void setupRotations(CosmicNPCEntity p_117802_, class_4587 p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        float f = p_117802_.method_6024(p_117806_);
        if (p_117802_.method_6128()) {
            super.method_4058((class_1309)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.method_6003() + p_117806_;
            float f2 = class_3532.method_15363((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.method_6123()) {
                p_117803_.method_22907(class_1160.field_20703.method_23214(f2 * (-90.0f - p_117802_.method_36455())));
            }
            class_243 vec3 = p_117802_.method_5828(p_117806_);
            class_243 vec31 = p_117802_.method_18798();
            double d0 = vec31.method_37268();
            double d1 = vec3.method_37268();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.field_1352 * vec3.field_1352 + vec31.field_1350 * vec3.field_1350) / Math.sqrt(d0 * d1);
                double d3 = vec31.field_1352 * vec3.field_1350 - vec31.field_1350 * vec3.field_1352;
                p_117803_.method_22907(class_1160.field_20705.method_23626((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.method_4058((class_1309)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f3 = p_117802_.method_5799() ? -90.0f - p_117802_.method_36455() : -90.0f;
            float f4 = class_3532.method_16439((float)f, (float)0.0f, (float)f3);
            p_117803_.method_22907(class_1160.field_20703.method_23214(f4));
            if (p_117802_.method_20232()) {
                p_117803_.method_22904(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.method_4058((class_1309)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }

    protected boolean shouldShowName(CosmicNPCEntity entity) {
        return super.method_4055((class_1309)entity) && (entity.method_5733() || entity.method_16914() && entity == this.field_4676.field_4678);
    }

    static {
        STEVE_TEXTURE = new class_2960("textures/entity/steve.png");
        ALEX_TEXTURE = new class_2960("textures/entity/alex.png");
    }
}

