/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import java.io.File;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_562;
import net.minecraft.class_583;
import net.minecraft.class_621;

@Environment(value=EnvType.CLIENT)
public class CEnergyLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M> {
    private final class_562<class_1548> creeperModel;
    private final class_621<class_1528> witherModel;
    private Type type;
    private boolean isCharged;
    private String layerTexture;

    public CEnergyLayer(class_3883<T, M> p_i50947_1_, class_5599 modelSet, CosmicNPCEntity npc, Type type) {
        super(p_i50947_1_);
        this.creeperModel = new class_562(modelSet.method_32072(class_5602.field_27700));
        this.witherModel = new class_621(modelSet.method_32072(class_5602.field_27630));
        this.type = type;
        this.isCharged = npc.getSettings().method_10577("Charged");
        this.layerTexture = npc.getSettings().method_10558("Layer");
    }

    public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.isCharged) {
            float f = (float)((class_1309)entitylivingbaseIn).field_6012 + partialTicks;
            class_583<T> entitymodel = this.model();
            entitymodel.method_2816(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.method_17165().method_17081(entitymodel);
            class_4588 ivertexbuilder = bufferIn.getBuffer(class_1921.method_23018((class_2960)this.getLayerTexture(), (float)this.xOffset(f), (float)(f * 0.01f)));
            entitymodel.method_2819(entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            entitymodel.method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    protected float xOffset(float p_225634_1_) {
        if (this.type == Type.WITHER) {
            return class_3532.method_15362((float)(p_225634_1_ * 0.02f)) * 3.0f;
        }
        return p_225634_1_ * 0.01f;
    }

    protected class_583<T> model() {
        if (this.type == Type.WITHER) {
            return this.witherModel;
        }
        return this.creeperModel;
    }

    public class_2960 getLayerTexture() {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + this.layerTexture + ".png");
        if (this.layerTexture != "default" && textureFile.exists()) {
            return new class_2960("npctextures", "textures/layers/" + this.layerTexture + ".png");
        }
        return this.type.getResourceLocation();
    }

    public static enum Type {
        CREEPER(new class_2960("textures/entity/creeper/creeper_armor.png")),
        WITHER(new class_2960("textures/entity/wither/wither_armor.png"));

        private class_2960 resourceLocation;

        private Type(class_2960 loc) {
            this.resourceLocation = loc;
        }

        private class_2960 getResourceLocation() {
            return this.resourceLocation;
        }
    }
}

