/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.client.renderer.entity.layers;

import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3532;
import net.minecraft.class_3850;
import net.minecraft.class_3851;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3883;
import net.minecraft.class_3884;
import net.minecraft.class_3887;
import net.minecraft.class_3888;
import net.minecraft.class_4013;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;

@Environment(value=EnvType.CLIENT)
public class CVillagerLevelPendantLayer<T extends class_1309, M extends class_583<T>>
extends class_3887<T, M>
implements class_4013 {
    private static final Int2ObjectMap<class_2960> LEVEL_LOCATIONS = (Int2ObjectMap)class_156.method_654((Object)new Int2ObjectOpenHashMap(), p_215348_0_ -> {
        p_215348_0_.put(1, (Object)new class_2960("stone"));
        p_215348_0_.put(2, (Object)new class_2960("iron"));
        p_215348_0_.put(3, (Object)new class_2960("gold"));
        p_215348_0_.put(4, (Object)new class_2960("emerald"));
        p_215348_0_.put(5, (Object)new class_2960("diamond"));
    });
    private final Object2ObjectMap<class_3854, class_3888.class_3889> typeHatCache = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<class_3852, class_3888.class_3889> professionHatCache = new Object2ObjectOpenHashMap();
    private final class_3304 resourceManager;
    private final String path;
    private String villagerTypeTexture;
    private String professionTexture;
    private String professionLevelTexture;

    public CVillagerLevelPendantLayer(class_3883<T, M> p_i50955_1_, class_3304 p_i50955_2_, String p_i50955_3_, CosmicNPCEntity npc) {
        super(p_i50955_1_);
        this.resourceManager = p_i50955_2_;
        this.path = p_i50955_3_;
        class_2487 settings = npc.getSettings();
        this.villagerTypeTexture = settings.method_10558("VillagerType");
        this.professionTexture = settings.method_10558("Profession");
        this.professionLevelTexture = settings.method_10558("ProfessionLevel");
        if (!settings.method_10558("Layer").equals("default")) {
            this.villagerTypeTexture = settings.method_10558("Layer");
        }
        p_i50955_2_.method_14477((class_3302)this);
    }

    public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entitylivingbaseIn.method_5767()) {
            class_3850 villagerdata = ((class_3851)entitylivingbaseIn).method_7231();
            class_3854 villagertype = villagerdata.method_16919();
            class_3852 villagerprofession = villagerdata.method_16924();
            class_3888.class_3889 villagermetadatasection$hattype = this.getHatData(this.typeHatCache, "type", class_2378.field_17166, villagertype);
            class_3888.class_3889 villagermetadatasection$hattype1 = this.getHatData(this.professionHatCache, "profession", class_2378.field_17167, villagerprofession);
            class_583 m = this.method_17165();
            ((class_3884)m).method_17150(villagermetadatasection$hattype1 == class_3888.class_3889.field_17160 || villagermetadatasection$hattype1 == class_3888.class_3889.field_17161 && villagermetadatasection$hattype != class_3888.class_3889.field_17162);
            class_2960 resourcelocation = this.getVillagerTypeTexture(this.villagerTypeTexture, class_2378.field_17166.method_10221((Object)villagertype));
            CVillagerLevelPendantLayer.method_23199((class_583)m, (class_2960)resourcelocation, (class_4587)matrixStackIn, (class_4597)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
            ((class_3884)m).method_17150(true);
            if (villagerprofession != class_3852.field_17051 && !entitylivingbaseIn.method_6109()) {
                class_2960 resourcelocation1 = this.getProfessionTexture(this.professionTexture, class_2378.field_17167.method_10221((Object)villagerprofession));
                CVillagerLevelPendantLayer.method_23199((class_583)m, (class_2960)resourcelocation1, (class_4587)matrixStackIn, (class_4597)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                if (villagerprofession != class_3852.field_17062) {
                    class_2960 resourcelocation2 = this.getProfessionLevelTexture(this.professionLevelTexture, (class_2960)LEVEL_LOCATIONS.get(class_3532.method_15340((int)villagerdata.method_16925(), (int)1, (int)LEVEL_LOCATIONS.size())));
                    CVillagerLevelPendantLayer.method_23199((class_583)m, (class_2960)resourcelocation2, (class_4587)matrixStackIn, (class_4597)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    private class_2960 getResourceLocation(String p_215351_1_, class_2960 p_215351_2_) {
        return new class_2960(p_215351_2_.method_12836(), "textures/entity/" + this.path + "/" + p_215351_1_ + "/" + p_215351_2_.method_12832() + ".png");
    }

    public <K> class_3888.class_3889 getHatData(Object2ObjectMap<K, class_3888.class_3889> p_215350_1_, String p_215350_2_, class_2348<K> p_215350_3_, K p_215350_4_) {
        return (class_3888.class_3889)p_215350_1_.computeIfAbsent(p_215350_4_, p_215349_4_ -> {
            try (class_3298 iresource = this.resourceManager.method_14486(this.getResourceLocation(p_215350_2_, p_215350_3_.method_10221(p_215350_4_)));){
                class_3888 villagermetadatasection = (class_3888)iresource.method_14481((class_3270)class_3888.field_17158);
                if (villagermetadatasection == null) return class_3888.class_3889.field_17160;
                class_3888.class_3889 class_38892 = villagermetadatasection.method_17167();
                return class_38892;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return class_3888.class_3889.field_17160;
        });
    }

    public void method_14491(class_3300 resourceManager) {
        this.professionHatCache.clear();
        this.typeHatCache.clear();
    }

    public class_2960 getVillagerTypeTexture(String layerTexture, class_2960 loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : class_2378.field_17166.method_29722()) {
            if (!((class_3854)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.getResourceLocation("type", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new class_2960("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("type", loc);
    }

    public class_2960 getProfessionTexture(String layerTexture, class_2960 loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        for (Map.Entry entry : class_2378.field_17167.method_29722()) {
            if (!((class_3852)entry.getValue()).toString().equals(layerTexture)) continue;
            return this.getResourceLocation("profession", loc);
        }
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new class_2960("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("profession", loc);
    }

    public class_2960 getProfessionLevelTexture(String layerTexture, class_2960 loc) {
        String path = "config/cosmicnpcs";
        File textureFile = new File(path + "/resources/textures/layers/" + layerTexture + ".png");
        if (!layerTexture.equals("default") && textureFile.exists()) {
            return new class_2960("npctextures", "textures/layers/" + layerTexture + ".png");
        }
        return this.getResourceLocation("profession_level", loc);
    }
}

