/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.namensammler.cosmicnpcs.common.command.argument.CEntitySummonArgument;
import de.namensammler.cosmicnpcs.common.command.argument.SuggestionProviders;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.init.EntityTypesInit;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayThread;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2487;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class NPCPlayCommand {
    static ArrayList<PlayThread> playThreads = new ArrayList();

    public static void register(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"npc-play").then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.REC_FILES).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"texture", (ArgumentType)StringArgumentType.word()).suggests(SuggestionProviders.TEXTURE_FILES).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), new class_2960("minecraft:player"), new class_2487(), (class_2168)context.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"model", (ArgumentType)CEntitySummonArgument.entitySummon()).suggests(SuggestionProviders.NPC_MODELS).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<class_2168>)context, "model"), new class_2487(), (class_2168)context.getSource()))).then(class_2170.method_9244((String)"settings", (ArgumentType)class_2179.method_9284()).executes(context -> NPCPlayCommand.play(StringArgumentType.getString((CommandContext)context, (String)"file"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"texture"), CEntitySummonArgument.getEntityId((CommandContext<class_2168>)context, "model"), class_2179.method_9285((CommandContext)context, (String)"settings"), (class_2168)context.getSource()))))))));
    }

    private static int play(String fileNameIn, String npcName, String textureName, class_2960 model, class_2487 compound, class_2168 source) {
        File file = null;
        String path = "config/cosmicnpcs";
        file = new File(path + "/recordings/" + fileNameIn + ".ccap");
        if (!file.exists()) {
            source.method_9213((class_2561)new class_2585("Can't find " + fileNameIn + ".ccap file!"));
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yawHead = 0.0f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        try {
            RandomAccessFile in = new RandomAccessFile(file, "r");
            short magic = in.readShort();
            if (magic != -5119) {
                in.close();
                source.method_9213((class_2561)new class_2585(fileNameIn + " isn't a .ccap file."));
            }
            yawHead = in.readFloat();
            yaw = in.readFloat();
            pitch = in.readFloat();
            x = in.readDouble();
            y = in.readDouble();
            z = in.readDouble();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        class_3218 world = source.method_9225();
        CosmicNPCEntity npc = (CosmicNPCEntity)EntityTypesInit.COSMIC_NPC.method_5883((class_1937)world);
        int showNameTagDefaultValue = 0;
        if (model.equals((Object)new class_2960("minecraft:player")) || model.equals((Object)new class_2960("minecraft:player_slim"))) {
            showNameTagDefaultValue = 1;
        }
        class_2487 settings = npc.getSettings();
        settings.method_10569("ShowNameTag", compound.method_10545("ShowNameTag") ? compound.method_10550("ShowNameTag") : showNameTagDefaultValue);
        settings.method_10556("Invulnerable", compound.method_10545("Invulnerable") ? compound.method_10577("Invulnerable") : false);
        settings.method_10556("UseCommands", compound.method_10545("UseCommands") ? compound.method_10577("UseCommands") : false);
        settings.method_10556("IsChild", compound.method_10545("IsChild") ? compound.method_10577("IsChild") : false);
        settings.method_10582("Layer", compound.method_10545("Layer") ? compound.method_10558("Layer").toLowerCase(Locale.ROOT) : "default");
        settings.method_10582("VillagerType", compound.method_10545("VillagerType") ? compound.method_10558("VillagerType") : "default");
        settings.method_10582("Profession", compound.method_10545("Profession") ? compound.method_10558("Profession") : "default");
        settings.method_10582("ProfessionLevel", compound.method_10545("ProfessionLevel") ? compound.method_10558("ProfessionLevel") : "default");
        if (compound.method_10573("ProfessionLevel", 99)) {
            settings.method_10569("ProfessionLevel", compound.method_10545("ProfessionLevel") ? compound.method_10550("ProfessionLevel") : 1);
        }
        settings.method_10582("Color", compound.method_10545("Color") ? compound.method_10558("Color") : "default");
        settings.method_10556("Sheared", compound.method_10545("Sheared") ? compound.method_10577("Sheared") : false);
        settings.method_10582("MushroomBlock", compound.method_10545("MushroomBlock") ? compound.method_10558("MushroomBlock") : "default");
        settings.method_10556("Charged", compound.method_10545("Charged") ? compound.method_10577("Charged") : false);
        settings.method_10582("Armor", compound.method_10545("Armor") ? compound.method_10558("Armor") : "default");
        settings.method_10556("Saddled", compound.method_10545("Saddled") ? compound.method_10577("Saddled") : false);
        settings.method_10582("Head", compound.method_10545("Head") ? compound.method_10558("Head") : "default");
        npc.method_5814(x, y, z);
        npc.field_6241 = yawHead;
        npc.method_36456(yaw);
        npc.method_36457(pitch);
        npc.setNPCName(npcName);
        npc.setTextureName(textureName);
        npc.setModel(model);
        npc.setSettings(settings);
        if (settings.method_10550("ShowNameTag") >= 1) {
            npc.method_5665((class_2561)new class_2585(npcName));
        } else {
            npc.method_5665((class_2561)((class_2554)null));
        }
        if (settings.method_10550("ShowNameTag") == 1) {
            npc.method_5880(true);
        } else {
            npc.method_5880(false);
        }
        npc.method_5684(settings.method_10577("Invulnerable"));
        world.method_8649((class_1297)npc);
        Iterator<PlayThread> iterator = playThreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        playThreads.add(new PlayThread(npc, fileNameIn));
        return 1;
    }
}

