/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.common.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.authlib.GameProfile;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import de.namensammler.cosmicnpcs.core.npcsystem.PlayThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1508;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1703;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class CosmicNPCEntity
extends class_1309 {
    public static final class_4048 STANDING_DIMENSIONS = class_4048.method_18384((float)0.6f, (float)1.8f);
    private static final Map<class_4050, class_4048> POSES = ImmutableMap.builder().put((Object)class_4050.field_18076, (Object)STANDING_DIMENSIONS).put((Object)class_4050.field_18078, (Object)field_18072).put((Object)class_4050.field_18077, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18079, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18080, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18081, (Object)class_4048.method_18384((float)0.6f, (float)1.5f)).put((Object)class_4050.field_18082, (Object)class_4048.method_18385((float)0.2f, (float)0.2f)).build();
    private static final class_2940<String> NPC_NAME = class_2945.method_12791(CosmicNPCEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> TEXTURE_NAME = class_2945.method_12791(CosmicNPCEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> MODEL_NAME = class_2945.method_12791(CosmicNPCEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> LAYER_TEXTURE = class_2945.method_12791(CosmicNPCEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<class_2487> SETTINGS = class_2945.method_12791(CosmicNPCEntity.class, (class_2941)class_2943.field_13318);
    protected class_1799 lastActiveItemStack = class_1799.field_8037;
    public ArrayList<PlayThread> playThreads;
    public String recFile = "";
    public List<NPCAction> eventsList = Collections.synchronizedList(new ArrayList());
    public class_1657 fakePlayer = new class_1657(this.field_6002, this.method_24515(), 0.0f, new GameProfile(this.field_6021, "NPCPlayer")){

        public boolean method_7325() {
            return false;
        }

        public boolean method_7337() {
            return true;
        }

        public OptionalInt method_17355(@Nullable class_3908 p_213829_1_) {
            class_1703 container;
            if (p_213829_1_ == null) {
                return OptionalInt.empty();
            }
            if (this.field_7512 != this.field_7498) {
                this.method_7346();
            }
            if ((container = p_213829_1_.createMenu(0, this.method_31548(), (class_1657)this)) == null) {
                return OptionalInt.empty();
            }
            this.field_7512 = container;
            return OptionalInt.of(0);
        }
    };
    public final class_1661 inventory = new class_1661(this.fakePlayer);

    public CosmicNPCEntity(class_1299<? extends class_1309> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6011.method_12784(NPC_NAME, (Object)"CosmicNPC");
        this.field_6011.method_12784(TEXTURE_NAME, (Object)"default");
        this.field_6011.method_12784(MODEL_NAME, (Object)"player");
        this.field_6011.method_12784(LAYER_TEXTURE, (Object)"default");
        this.field_6011.method_12784(SETTINGS, (Object)new class_2487());
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23719, (double)0.1f).method_26867(class_5134.field_23723).method_26868(class_5134.field_23717, 16.0).method_26867(class_5134.field_23722);
    }

    public void setNPCName(String npcName) {
        this.field_6011.method_12778(NPC_NAME, (Object)npcName);
    }

    public String getNPCName() {
        return (String)this.field_6011.method_12789(NPC_NAME);
    }

    public void setTextureName(String textureName) {
        this.field_6011.method_12778(TEXTURE_NAME, (Object)textureName.toLowerCase(Locale.ROOT));
    }

    public String getTextureName() {
        return (String)this.field_6011.method_12789(TEXTURE_NAME);
    }

    public void setModel(class_2960 model) {
        this.field_6011.method_12778(MODEL_NAME, (Object)model.toString());
    }

    public class_2960 getModel() {
        return new class_2960((String)this.field_6011.method_12789(MODEL_NAME));
    }

    public void setSettings(class_2487 settings) {
        this.field_6011.method_12778(SETTINGS, (Object)settings);
    }

    public class_2487 getSettings() {
        return (class_2487)this.field_6011.method_12789(SETTINGS);
    }

    public void setElytraFlying(boolean isElytraFlying) {
        this.method_5729(7, isElytraFlying);
    }

    public void startActions(ArrayList<PlayThread> playthreads, String recFile) {
        Iterator<PlayThread> iterator = playthreads.iterator();
        while (iterator.hasNext()) {
            PlayThread item = iterator.next();
            if (item.t.isAlive()) continue;
            iterator.remove();
        }
        playthreads.add(new PlayThread(this, recFile));
    }

    private void replayShootArrow(NPCAction ma) {
        float f = (float)ma.arrowCharge / 20.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
            return;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        class_1744 arrow = (class_1744)new class_1799((class_1935)class_1802.field_8107).method_7909();
        class_1665 entityarrow = arrow.method_7702(this.field_6002, this.method_6030(), (class_1309)this);
        entityarrow.method_24919((class_1297)this, this.method_36455(), this.method_36454(), 0.0f, f * 3.0f, 1.0f);
        if (f == 1.0f) {
            entityarrow.method_7439(true);
        }
        this.field_6002.method_8649((class_1297)entityarrow);
        this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14600, class_3419.field_15254, 1.0f, 1.0f / (this.field_5974.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
    }

    private void processActions(NPCAction ma) {
        switch (ma.type) {
            case 1: {
                List temp = this.field_6002.method_8503().method_3760().method_14571();
                for (class_3222 player : temp) {
                    class_2585 cmp = new class_2585("<" + this.getNPCName() + "> " + ma.message);
                    player.method_9203((class_2561)cmp, class_156.field_25140);
                }
                break;
            }
            case 2: {
                this.method_6104(class_1268.field_5808);
                class_1309 mop = this.GetTargetEntityLiving(5);
                if (mop == null) break;
                this.method_6121((class_1297)mop);
                this.attack((class_1297)mop);
                break;
            }
            case 4: {
                class_1799 loadedEquip = class_1799.method_7915((class_2487)ma.itemData);
                this.method_5673(this.getEquipmentSlotById(ma.equipmentSlot), loadedEquip);
                break;
            }
            case 3: {
                class_1799 droppedItem = class_1799.method_7915((class_2487)ma.itemData);
                double d0 = this.method_23320() - (double)0.3f;
                class_1542 itementity = new class_1542(this.field_6002, this.method_23317(), d0, this.method_23321(), droppedItem);
                itementity.method_6982(40);
                float f7 = 0.3f;
                float f8 = class_3532.method_15374((float)(this.method_36455() * ((float)Math.PI / 180)));
                float f2 = class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180)));
                float f3 = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
                float f4 = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
                float f5 = this.field_5974.nextFloat() * ((float)Math.PI * 2);
                float f6 = 0.02f * this.field_5974.nextFloat();
                itementity.method_18800((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, (double)(-f8 * 0.3f + 0.1f + (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.1f), (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
                this.field_6002.method_8649((class_1297)itementity);
                break;
            }
            case 5: {
                this.replayShootArrow(ma);
                break;
            }
            case 8: {
                class_2680 block = this.field_6002.method_8320(new class_2338(ma.xCoord, ma.yCoord, ma.zCoord));
                if (block == class_2246.field_10124.method_9564()) break;
                this.field_6002.method_20290(2001, new class_2338(ma.xCoord, ma.yCoord, ma.zCoord), class_2248.method_9507((class_2680)block));
                this.field_6002.method_8501(new class_2338(ma.xCoord, ma.yCoord, ma.zCoord), class_2246.field_10124.method_9564());
                block.method_26204().method_9576(this.field_6002, new class_2338(ma.xCoord, ma.yCoord, ma.zCoord), block, this.fakePlayer);
                break;
            }
            case 7: {
                class_2586 blockEntity;
                class_2680 block = class_2248.method_9531((int)ma.stateId);
                this.field_6002.method_8501(new class_2338(ma.xCoord, ma.yCoord, ma.zCoord), block);
                if (block.method_26204() instanceof class_2323) {
                    class_2680 upperDoor = (class_2680)block.method_11657((class_2769)class_2323.field_10946, (Comparable)class_2756.field_12609);
                    this.field_6002.method_8501(new class_2338(ma.xCoord, ma.yCoord + 1, ma.zCoord), upperDoor);
                }
                if (block.method_26204() instanceof class_2478 && (blockEntity = this.field_6002.method_8321(new class_2338(ma.xCoord, ma.yCoord, ma.zCoord))) instanceof class_2625) {
                    class_2625 sign = (class_2625)blockEntity;
                    sign.method_11014(ma.itemData);
                }
                class_2498 soundtype = block.method_26204().method_9573(block);
                this.field_6002.method_8396(null, new class_2338(ma.xCoord, ma.yCoord + 1, ma.zCoord), soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                break;
            }
            case 9: {
                class_2680 aBlock = this.field_6002.method_8320(new class_2338(ma.xCoord, ma.yCoord, ma.zCoord));
                if (aBlock == class_2246.field_10124.method_9564()) break;
                aBlock.method_26174(this.field_6002, this.fakePlayer, class_1268.field_5808, new class_3965(this.method_5720(), this.method_5735(), new class_2338(ma.xCoord, ma.yCoord, ma.zCoord), false));
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                this.method_5998(ma.handType).method_7909().method_7836(this.field_6002, this.fakePlayer, ma.handType);
                this.lastActiveItemStack = this.method_5998(ma.handType);
                break;
            }
            case 12: {
                this.lastActiveItemStack.method_7910(this.field_6002, (class_1309)this);
                this.lastActiveItemStack = class_1799.field_8037;
                break;
            }
            case 13: {
                this.lastActiveItemStack.method_7909().method_7840(this.lastActiveItemStack, this.field_6002, (class_1309)this.fakePlayer, 0);
                this.lastActiveItemStack = class_1799.field_8037;
                break;
            }
            case 14: {
                if (!this.getSettings().method_10577("UseCommands")) break;
                this.method_5682().method_3734().method_9249(this.method_5671().method_9217().method_9230(5), ma.message);
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.eventsList.size() > 0) {
            NPCAction ma = this.eventsList.remove(0);
            this.processActions(ma);
        }
        this.updatePose();
        this.method_6119();
        if (this.fakePlayer != null) {
            this.fakePlayer.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            this.fakePlayer.method_36456(this.method_36454());
            this.fakePlayer.method_36457(this.method_36455());
            this.fakePlayer.field_6241 = this.field_6241;
            this.fakePlayer.method_5673(class_1304.field_6173, this.method_6047());
            this.fakePlayer.method_5673(class_1304.field_6171, this.method_6079());
            this.fakePlayer.method_31549().field_7477 = true;
        }
    }

    public float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        switch (poseIn) {
            case field_18079: 
            case field_18077: 
            case field_18080: {
                return 0.4f;
            }
            case field_18081: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return POSES.getOrDefault(poseIn, STANDING_DIMENSIONS);
    }

    protected void updatePose() {
        if (this.method_20233(class_4050.field_18079)) {
            class_4050 pose = this.method_6128() ? class_4050.field_18077 : (this.method_6113() ? class_4050.field_18078 : (this.method_5681() ? class_4050.field_18079 : (this.method_6123() ? class_4050.field_18080 : (this.method_5715() ? class_4050.field_18081 : class_4050.field_18076))));
            class_4050 pose1 = !(this.method_7325() || this.method_5765() || this.method_20233(pose)) ? (this.method_20233(class_4050.field_18081) ? class_4050.field_18081 : class_4050.field_18079) : pose;
            this.method_18380(pose1);
        }
    }

    protected float method_6031(float f2, float f3) {
        boolean flag;
        float f = class_3532.method_15393((float)(f2 - this.field_6283));
        this.field_6283 += f * 0.3f;
        float f1 = class_3532.method_15393((float)(this.method_36454() - this.field_6283));
        boolean bl = flag = f1 < -90.0f || f1 >= 90.0f;
        if (f1 < -75.0f) {
            f1 = -75.0f;
        }
        if (f1 >= 75.0f) {
            f1 = 75.0f;
        }
        this.field_6283 = this.method_36454() - f1;
        if (f1 * f1 > 2500.0f) {
            this.field_6283 += f1 * 0.2f;
        }
        if (flag) {
            f3 *= -1.0f;
        }
        return f3;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("npc_name", this.getNPCName());
        compound.method_10582("texture_name", this.getTextureName());
        compound.method_10582("model", this.getModel().toString());
        compound.method_10566("settings", (class_2520)this.getSettings());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setNPCName(compound.method_10558("npc_name"));
        this.setTextureName(compound.method_10558("texture_name"));
        this.setModel(new class_2960(compound.method_10558("model")));
        this.setSettings(compound.method_10562("settings"));
    }

    public class_1309 GetTargetEntityLiving(int scanRadius) {
        double targetDistance = Math.pow(scanRadius, 2.0);
        class_1309 target = null;
        class_238 area = new class_238(this.method_23317() - (double)scanRadius, this.method_23318() - (double)scanRadius, this.method_23321() - (double)scanRadius, this.method_23317() + (double)scanRadius, this.method_23318() + (double)scanRadius, this.method_23321() + (double)scanRadius);
        List lst = this.field_6002.method_8335((class_1297)this, area);
        for (int i = 0; i < lst.size(); ++i) {
            class_1297 ent = (class_1297)lst.get(i);
            if (!(ent instanceof class_1309) || ent == null || ent.method_5829() == null) continue;
            float distance = this.method_5739(ent) + 0.1f;
            float angle = this.field_6241;
            float pitch = this.method_36455();
            class_243 look = this.method_5720();
            class_243 targetVec = new class_243(this.method_23317() + look.field_1352 * (double)distance, (double)(this.method_5751() / 2.0f) + this.method_23318() + look.field_1351 * (double)distance, this.method_23321() + look.field_1350 * (double)distance);
            if (!ent.method_5829().method_1006(targetVec) || !((double)distance < targetDistance) || !(distance > 0.0f)) continue;
            targetDistance = distance;
            target = (class_1309)ent;
        }
        return target;
    }

    public class_1304 getEquipmentSlotById(int Id) {
        switch (Id) {
            case 0: {
                return class_1304.field_6166;
            }
            case 1: {
                return class_1304.field_6172;
            }
            case 2: {
                return class_1304.field_6174;
            }
            case 3: {
                return class_1304.field_6169;
            }
            case 4: {
                return class_1304.field_6173;
            }
            case 5: {
                return class_1304.field_6171;
            }
        }
        return class_1304.field_6172;
    }

    public void attack(class_1297 targetEntity) {
        if (targetEntity.method_5732() && !targetEntity.method_5698((class_1297)this)) {
            float f = (float)this.method_26825(class_5134.field_23721);
            float f1 = targetEntity instanceof class_1309 ? class_1890.method_8218((class_1799)this.method_6047(), (class_1310)((class_1309)targetEntity).method_6046()) : class_1890.method_8218((class_1799)this.method_6047(), (class_1310)class_1310.field_6290);
            float f2 = 1.0f;
            f1 *= f2;
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                class_1799 itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += class_1890.method_8205((class_1309)this);
                if (this.method_5624() && flag) {
                    this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14999, this.method_5634(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && this.field_6017 > 0.0f && !this.field_5952 && !this.method_6101() && !this.method_5799() && !this.method_6059(class_1294.field_5919) && !this.method_5765() && targetEntity instanceof class_1309;
                flag2 = flag2 && !this.method_5624();
                f += f1;
                boolean flag3 = false;
                double d0 = this.field_5973 - this.field_6039;
                if (flag && !flag2 && !flag1 && this.field_5952 && d0 < (double)this.method_6029() && (itemstack = this.method_5998(class_1268.field_5808)).method_7909() instanceof class_1829) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = class_1890.method_8199((class_1309)this);
                if (targetEntity instanceof class_1309) {
                    f4 = ((class_1309)targetEntity).method_6032();
                    if (j > 0 && !targetEntity.method_5809()) {
                        flag4 = true;
                        targetEntity.method_5639(1);
                    }
                }
                class_243 vector3d = targetEntity.method_18798();
                boolean flag5 = targetEntity.method_5643(class_1282.method_5511((class_1309)this), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof class_1309) {
                            ((class_1309)targetEntity).method_6005((double)((float)i * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.method_5762((double)(-class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
                        this.method_5728(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + class_1890.method_8217((class_1309)this) * f;
                        for (class_1309 livingentity : this.field_6002.method_18467(class_1309.class, targetEntity.method_5829().method_1009(1.0, 0.25, 1.0))) {
                            if (livingentity == this || livingentity == targetEntity || this.method_5722((class_1297)livingentity) || livingentity instanceof class_1531 && ((class_1531)livingentity).method_6912() || !(this.method_5858((class_1297)livingentity) < 9.0)) continue;
                            livingentity.method_6005((double)0.4f, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                            livingentity.method_5643(class_1282.method_5511((class_1309)this), f3);
                        }
                        this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14706, this.method_5634(), 1.0f, 1.0f);
                    }
                    if (targetEntity instanceof class_3222 && targetEntity.field_6037) {
                        ((class_3222)targetEntity).field_13987.method_14364((class_2596)new class_2743(targetEntity));
                        targetEntity.field_6037 = false;
                        targetEntity.method_18799(vector3d);
                    }
                    if (flag2) {
                        this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15016, this.method_5634(), 1.0f, 1.0f);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14840, this.method_5634(), 1.0f, 1.0f);
                        } else {
                            this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14625, this.method_5634(), 1.0f, 1.0f);
                        }
                    }
                    this.method_6114(targetEntity);
                    if (targetEntity instanceof class_1309) {
                        class_1890.method_8210((class_1309)((class_1309)targetEntity), (class_1297)this);
                    }
                    class_1890.method_8213((class_1309)this, (class_1297)targetEntity);
                    class_1799 itemstack1 = this.method_6047();
                    class_1297 entity = targetEntity;
                    if (targetEntity instanceof class_1508) {
                        entity = ((class_1508)targetEntity).field_7007;
                    }
                    if (!this.field_6002.field_9236 && !itemstack1.method_7960() && entity instanceof class_1309) {
                        class_1799 copy = itemstack1.method_7972();
                        itemstack1.method_7979((class_1309)entity, this.fakePlayer);
                        if (itemstack1.method_7960()) {
                            this.method_6122(class_1268.field_5808, class_1799.field_8037);
                        }
                    }
                    if (targetEntity instanceof class_1309) {
                        float f5 = f4 - ((class_1309)targetEntity).method_6032();
                        if (j > 0) {
                            targetEntity.method_5639(j * 4);
                        }
                        if (this.field_6002 instanceof class_3218 && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11209, targetEntity.method_23317(), targetEntity.method_23323(0.5), targetEntity.method_23321(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                } else {
                    this.field_6002.method_8465((class_1657)null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14914, this.method_5634(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.method_5646();
                    }
                }
            }
        }
    }

    public Iterable<class_1799> method_5661() {
        return this.inventory.field_7548;
    }

    public class_1799 method_6118(class_1304 slotIn) {
        if (slotIn == class_1304.field_6173) {
            return this.inventory.method_7391();
        }
        if (slotIn == class_1304.field_6171) {
            return (class_1799)this.inventory.field_7544.get(0);
        }
        return slotIn.method_5925() == class_1304.class_1305.field_6178 ? (class_1799)this.inventory.field_7548.get(slotIn.method_5927()) : class_1799.field_8037;
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
        if (slotIn == class_1304.field_6173) {
            this.inventory.field_7547.set(this.inventory.field_7545, (Object)stack);
        } else if (slotIn == class_1304.field_6171) {
            this.inventory.field_7544.set(0, (Object)stack);
        } else if (slotIn.method_5925() == class_1304.class_1305.field_6178) {
            this.inventory.field_7548.set(slotIn.method_5927(), (Object)stack);
        }
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }
}

