/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.common.entity.CosmicNPCEntity;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2507;

public class PlayThread
implements Runnable {
    public Thread t;
    CosmicNPCEntity replayEntity;
    DataInputStream in;

    public PlayThread(class_1309 _player, String recfile) {
        File file = new File("config/cosmicnpcs/recordings");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.in = new DataInputStream(new FileInputStream(file.getAbsolutePath() + "/" + recfile + ".ccap"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.replayEntity = (CosmicNPCEntity)_player;
        this.t = new Thread((Runnable)this, "NPC Playback Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            short magic = this.in.readShort();
            if (magic != -5119) {
                throw new Exception("Not an ccap file.");
            }
            while (true) {
                float yawHead = this.in.readFloat();
                float yaw = this.in.readFloat();
                float pitch = this.in.readFloat();
                double x = this.in.readDouble();
                double y = this.in.readDouble();
                double z = this.in.readDouble();
                double mx = this.in.readDouble();
                double my = this.in.readDouble();
                double mz = this.in.readDouble();
                float fd = this.in.readFloat();
                Boolean iab = this.in.readBoolean();
                Boolean isn = this.in.readBoolean();
                Boolean isp = this.in.readBoolean();
                Boolean iog = this.in.readBoolean();
                Boolean ief = this.in.readBoolean();
                Boolean isSwimming = this.in.readBoolean();
                Boolean isHandActive = this.in.readBoolean();
                class_1268 handType = class_1268.values()[this.in.readInt()];
                Boolean ir = false;
                this.replayEntity.field_6007 = iab;
                this.replayEntity.method_18800(mx, my, mz);
                this.replayEntity.field_6017 = fd;
                this.replayEntity.method_5660(isn);
                this.replayEntity.method_5728(isp);
                this.replayEntity.method_24830(iog);
                this.replayEntity.setElytraFlying(ief);
                this.replayEntity.method_5641(x, y, z, yaw, pitch);
                this.replayEntity.method_5847(yawHead);
                if (isHandActive.booleanValue()) {
                    this.replayEntity.method_6019(handType);
                } else {
                    this.replayEntity.method_6021();
                }
                Boolean hasAction = this.in.readBoolean();
                if (hasAction.booleanValue()) {
                    byte type = this.in.readByte();
                    switch (type) {
                        case 1: {
                            String msg = this.in.readUTF();
                            NPCAction ma = new NPCAction(1);
                            ma.message = msg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 4: {
                            NPCAction ma = new NPCAction(4);
                            int aSlot = this.in.readInt();
                            int aId = this.in.readInt();
                            int aDmg = this.in.readInt();
                            if (aId != class_1792.method_7880((class_1792)class_1802.field_8162)) {
                                ma.itemData = class_2507.method_10627((DataInput)this.in);
                            }
                            ma.equipmentSlot = aSlot;
                            ma.itemId = aId;
                            ma.itemDmg = aDmg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 2: {
                            NPCAction ma = new NPCAction(2);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 3: {
                            NPCAction ma = new NPCAction(3);
                            ma.itemData = class_2507.method_10627((DataInput)this.in);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 5: {
                            int aCharge = this.in.readInt();
                            NPCAction ma = new NPCAction(5);
                            ma.arrowCharge = aCharge;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 8: {
                            NPCAction ma = new NPCAction(8);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 7: {
                            NPCAction ma = new NPCAction(7);
                            ma.stateId = this.in.readInt();
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            if (class_2248.method_9531((int)ma.stateId).method_26204() instanceof class_2478) {
                                ma.itemData = class_2507.method_10627((DataInput)this.in);
                            }
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 9: {
                            NPCAction ma = new NPCAction(9);
                            ma.xCoord = this.in.readInt();
                            ma.yCoord = this.in.readInt();
                            ma.zCoord = this.in.readInt();
                            ma.metaData = this.in.readInt();
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 10: {
                            NPCAction ma = new NPCAction(10);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 11: {
                            NPCAction ma = new NPCAction(11);
                            ma.handType = class_1268.values()[this.in.readByte()];
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 12: {
                            NPCAction ma = new NPCAction(12);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 13: {
                            NPCAction ma = new NPCAction(13);
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                        case 14: {
                            String msg = this.in.readUTF();
                            NPCAction ma = new NPCAction(14);
                            ma.message = msg;
                            this.replayEntity.eventsList.add(ma);
                            break;
                        }
                    }
                }
                Thread.sleep(25L);
            }
        }
        catch (EOFException magic) {
        }
        catch (Exception e) {
            System.out.println("Replay thread interrupted");
            CosmicNPCs.LOGGER.warn("Error loading ccap file, not a ccap file.");
            e.printStackTrace();
        }
        this.replayEntity.method_31472();
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

