/*
 * Decompiled with CFR 0.152.
 */
package de.namensammler.cosmicnpcs.core.npcsystem;

import de.namensammler.cosmicnpcs.CosmicNPCs;
import de.namensammler.cosmicnpcs.core.npcsystem.NPCAction;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2507;

public class RecordThread
implements Runnable {
    public Thread t;
    class_1657 player;
    public Boolean capture = false;
    RandomAccessFile in;
    Boolean lastTickSwipe = false;
    int[] itemsEquipped = new int[6];
    class_2487[] equipedItemsData = new class_2487[6];
    List<NPCAction> eventList;

    public RecordThread(class_1657 _player, String capname) {
        File file = new File("config/cosmicnpcs/recordings");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            this.in = new RandomAccessFile(file.getAbsolutePath() + "/" + capname + ".ccap", "rw");
            this.in.setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.player = _player;
        this.capture = true;
        this.eventList = CosmicNPCs.instance.getActionListForPlayer(this.player);
        this.t = new Thread((Runnable)this, "NPC Record Thread");
        this.t.start();
    }

    @Override
    public void run() {
        try {
            this.in.writeShort(60417);
            while (this.capture.booleanValue()) {
                this.trackAndWriteMovement();
                this.trackSwing();
                this.trackEquipment();
                this.writeActions();
                Thread.sleep(25L);
                if (!this.player.method_29504()) continue;
                this.capture = false;
                CosmicNPCs.instance.recordThreads.remove(this.player);
                CosmicNPCs.LOGGER.info("Stopped recording " + this.player.method_5476() + ". RIP.");
            }
            this.in.close();
        }
        catch (InterruptedException e) {
            System.out.println("Child interrupted.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Exiting child thread.");
    }

    private void trackAndWriteMovement() throws IOException {
        this.in.writeFloat(this.player.field_6241);
        this.in.writeFloat(this.player.method_36454());
        this.in.writeFloat(this.player.method_36455());
        this.in.writeDouble(this.player.method_23317());
        this.in.writeDouble(this.player.method_23318());
        this.in.writeDouble(this.player.method_23321());
        this.in.writeDouble(this.player.method_18798().field_1352);
        this.in.writeDouble(this.player.method_18798().field_1351);
        this.in.writeDouble(this.player.method_18798().field_1350);
        this.in.writeFloat(this.player.field_6017);
        this.in.writeBoolean(this.player.field_6007);
        this.in.writeBoolean(this.player.method_5715());
        this.in.writeBoolean(this.player.method_5624());
        this.in.writeBoolean(this.player.method_24828());
        this.in.writeBoolean(this.player.method_6128());
        this.in.writeBoolean(this.player.method_5681());
        if (this.player.method_6115()) {
            this.in.writeBoolean(this.player.method_6115());
            this.in.writeInt(this.player.method_6058() == class_1268.field_5808 ? 0 : 1);
        } else {
            this.in.writeBoolean(this.player.method_6115());
            this.in.writeInt(0);
        }
    }

    private void trackEquipment() {
        for (int slot = 0; slot < 6; ++slot) {
            class_1799 item = class_1799.field_8037;
            if (slot < 4) {
                item = (class_1799)this.player.method_31548().field_7548.get(slot);
            }
            if (slot == 4) {
                item = this.player.method_6047();
            }
            if (slot == 5) {
                item = this.player.method_6079();
            }
            if (class_1792.method_7880((class_1792)item.method_7909()) == this.itemsEquipped[slot] && item.method_7972().method_7948().equals((Object)this.equipedItemsData[slot])) continue;
            this.itemsEquipped[slot] = class_1792.method_7880((class_1792)item.method_7909());
            this.equipedItemsData[slot] = item.method_7972().method_7948();
            NPCAction ma = new NPCAction(4);
            ma.equipmentSlot = slot;
            ma.itemId = this.itemsEquipped[slot];
            ma.itemDmg = item.method_7919();
            item.method_7953(ma.itemData);
            this.eventList.add(ma);
        }
    }

    private void trackSwing() {
        if (this.player.field_6279 == -1 && this.player.field_6252) {
            this.eventList.add(new NPCAction(2));
        }
    }

    private void writeActions() throws IOException {
        if (this.eventList.size() > 0) {
            this.in.writeBoolean(true);
            NPCAction ma = this.eventList.get(0);
            this.in.writeByte(ma.type);
            switch (ma.type) {
                case 1: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    class_2507.method_10628((class_2487)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 4: {
                    this.in.writeInt(ma.equipmentSlot);
                    this.in.writeInt(ma.itemId);
                    this.in.writeInt(ma.itemDmg);
                    if (ma.itemId == class_1792.method_7880((class_1792)class_1802.field_8162)) break;
                    class_2507.method_10628((class_2487)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 5: {
                    this.in.writeInt(ma.arrowCharge);
                    break;
                }
                case 7: {
                    this.in.writeInt(ma.stateId);
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    if (!(class_2248.method_9531((int)ma.stateId).method_26204() instanceof class_2478)) break;
                    class_2507.method_10628((class_2487)ma.itemData, (DataOutput)this.in);
                    break;
                }
                case 8: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    break;
                }
                case 9: {
                    this.in.writeInt(ma.xCoord);
                    this.in.writeInt(ma.yCoord);
                    this.in.writeInt(ma.zCoord);
                    this.in.writeInt(ma.metaData);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    this.in.writeByte((byte)ma.handType.ordinal());
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    this.in.writeUTF(ma.message);
                    break;
                }
                case 6: {
                    CosmicNPCs.instance.recordThreads.remove(this.player);
                    CosmicNPCs.LOGGER.info("Stopped recording " + this.player.method_5476() + ". Bye!");
                    this.capture = false;
                }
            }
            this.eventList.remove(0);
        } else {
            this.in.writeBoolean(false);
        }
    }
}

