/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public final class CrosshairRenderManager {
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<class_1792> itemCooldownItems = ImmutableSet.of((Object)class_1802.field_8634, (Object)class_1802.field_8233);

    public CrosshairRenderManager() {
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(class_4587 matrixStack, CustomCrosshair crosshair, int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        CrosshairStyle calculatedStyle = class_310.method_1551().field_1690.field_1866 && (Boolean)crosshair.isKeepDebugEnabled.get() != false ? CrosshairStyle.DEBUG : (CrosshairStyle)((Object)crosshair.style.get());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ICrosshairStyle style = this.crosshairStyleFactory.from(matrixStack, calculatedStyle, crosshair);
        Boolean isItemCooldownEnabled = (Boolean)crosshair.isItemCooldownEnabled.get();
        Boolean isDotEnabled = (Boolean)crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled.booleanValue()) {
            this.drawItemCooldownIndicator(matrixStack, crosshair, computedProperties, x, y);
        }
        if (isDotEnabled.booleanValue() && crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(matrixStack, x, y, 0.5f, 1.0f, (RGBA)crosshair.dotColour.get());
        }
        this.drawDefaultAttackIndicator(matrixStack, computedProperties, x, y);
        class_4587 transformMatrixStack = calculatedStyle == CrosshairStyle.DEBUG ? RenderSystem.getModelViewStack() : matrixStack;
        int renderX = x + (Integer)crosshair.offsetX.get();
        int renderY = y + (Integer)crosshair.offsetY.get();
        this.preTransformation(transformMatrixStack, crosshair, renderX, renderY);
        style.draw(0, 0, computedProperties);
        this.postTransformation(transformMatrixStack);
    }

    private void preTransformation(class_4587 matrixStack, CustomCrosshair crosshair, int x, int y) {
        Integer rotation = (Integer)crosshair.rotation.get();
        int scale = (Integer)crosshair.scale.get() - 2;
        float windowScaling = (float)class_310.method_1551().method_22683().method_4495() / 2.0f;
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 0.0);
        matrixStack.method_22905((float)scale / 100.0f / windowScaling, (float)scale / 100.0f / windowScaling, 1.0f);
        matrixStack.method_22907(new class_1158(class_1160.field_20707, (float)rotation.intValue(), true));
        RenderSystem.applyModelViewMatrix();
    }

    private void postTransformation(class_4587 matrixStack) {
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private void drawItemCooldownIndicator(class_4587 matrixStack, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)crosshair.itemCooldownColour.get();
        Integer width = (Integer)crosshair.width.get();
        Integer height = (Integer)crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (class_1792 item : this.itemCooldownItems) {
            float cooldown = player.method_7357().method_7905(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(matrixStack, x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(class_4587 matrixStack, ComputedProperties computedProperties, int x, int y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.method_42565().method_41753() == class_4061.field_18152 && mc.field_1724 != null) {
            float f = mc.field_1724.method_7261(0.0f);
            boolean bl = false;
            if (mc.field_1692 instanceof class_1309 && f >= 1.0f) {
                bl = mc.field_1724.method_7279() > 5.0f;
                bl &= mc.field_1692.method_5805();
            }
            int j = mc.method_22683().method_4502() / 2 - 7 + 16;
            int k = mc.method_22683().method_4486() / 2 - 8;
            if (bl) {
                class_332.method_25290((class_4587)matrixStack, (int)k, (int)j, (float)68.0f, (float)94.0f, (int)16, (int)16, (int)256, (int)256);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                class_332.method_25290((class_4587)matrixStack, (int)k, (int)j, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
                class_332.method_25290((class_4587)matrixStack, (int)k, (int)j, (float)52.0f, (float)94.0f, (int)l, (int)4, (int)256, (int)256);
            }
        }
    }
}

