/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class CrosshairRenderManager {
    private static final class_2960 ICONS = new class_2960("textures/gui/icons.png");
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<class_1792> itemCooldownItems = ImmutableSet.of((Object)class_1802.field_8634, (Object)class_1802.field_8233);

    public CrosshairRenderManager() {
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(CustomCrosshair crosshair, class_332 drawContext, int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        CrosshairStyle calculatedStyle = class_310.method_1551().field_1690.field_1866 && (Boolean)crosshair.isKeepDebugEnabled.get() != false ? CrosshairStyle.DEBUG : (CrosshairStyle)((Object)crosshair.style.get());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = drawContext.method_51448();
        ICrosshairStyle style = this.crosshairStyleFactory.from(matrixStack, calculatedStyle, crosshair);
        Boolean isItemCooldownEnabled = (Boolean)crosshair.isItemCooldownEnabled.get();
        Boolean isDotEnabled = (Boolean)crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled.booleanValue()) {
            this.drawItemCooldownIndicator(matrixStack, crosshair, computedProperties, x, y);
        }
        if (isDotEnabled.booleanValue() && crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(matrixStack, x, y, 0.5f, 1.0f, (RGBA)crosshair.dotColour.get());
        }
        this.drawDefaultAttackIndicator(drawContext, computedProperties, x, y);
        class_4587 transformMatrixStack = calculatedStyle == CrosshairStyle.DEBUG ? RenderSystem.getModelViewStack() : matrixStack;
        int renderX = x + (Integer)crosshair.offsetX.get();
        int renderY = y + (Integer)crosshair.offsetY.get();
        this.drawToolDamageIndicator(drawContext, crosshair, computedProperties, renderX, renderY);
        this.preTransformation(transformMatrixStack, crosshair, renderX, renderY);
        style.draw(drawContext, 0, 0, computedProperties);
        this.postTransformation(transformMatrixStack);
    }

    private void preTransformation(class_4587 matrixStack, CustomCrosshair crosshair, int x, int y) {
        Integer rotation = (Integer)crosshair.rotation.get();
        int scale = (Integer)crosshair.scale.get() - 2;
        float windowScaling = (float)class_310.method_1551().method_22683().method_4495() / 2.0f;
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 0.0);
        matrixStack.method_22905((float)scale / 100.0f / windowScaling, (float)scale / 100.0f / windowScaling, 1.0f);
        matrixStack.method_22907(new Quaternionf((Quaternionfc)class_7833.field_40718.rotationDegrees((float)rotation.intValue())));
        RenderSystem.applyModelViewMatrix();
    }

    private void postTransformation(class_4587 matrixStack) {
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private void drawItemCooldownIndicator(class_4587 matrixStack, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)crosshair.itemCooldownColour.get();
        Integer width = (Integer)crosshair.width.get();
        Integer height = (Integer)crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (class_1792 item : this.itemCooldownItems) {
            float cooldown = player.method_7357().method_7905(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(matrixStack, x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(class_332 drawContext, ComputedProperties computedProperties, int x, int y) {
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.method_42565().method_41753() == class_4061.field_18152 && mc.field_1724 != null) {
            float f = mc.field_1724.method_7261(0.0f);
            boolean bl = false;
            if (mc.field_1692 instanceof class_1309 && f >= 1.0f) {
                bl = mc.field_1724.method_7279() > 5.0f;
                bl &= mc.field_1692.method_5805();
            }
            int j = mc.method_22683().method_4502() / 2 - 7 + 16;
            int k = mc.method_22683().method_4486() / 2 - 8;
            if (bl) {
                drawContext.method_25290(ICONS, k, j, 68.0f, 94.0f, 16, 16, 256, 256);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                drawContext.method_25290(ICONS, k, j, 36.0f, 94.0f, 16, 4, 256, 256);
                drawContext.method_25290(ICONS, k, j, 52.0f, 94.0f, l, 4, 256, 256);
            }
        }
    }

    private void drawToolDamageIndicator(class_332 drawContext, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        if (!((Boolean)crosshair.isToolDamageEnabled.get()).booleanValue()) {
            return;
        }
        int drawX = x + (Integer)crosshair.gap.get() + 5;
        int drawY = y + (Integer)crosshair.gap.get() + 5;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1724.method_6047() == null) {
            return;
        }
        class_1799 tool = mc.field_1724.method_6047();
        if (!tool.method_7963()) {
            return;
        }
        int remainingDamage = tool.method_7936() - tool.method_7919();
        if (remainingDamage > 10) {
            return;
        }
        class_918 itemRenderer = mc.method_1480();
        class_1087 model = itemRenderer.method_4019(tool, null, null, 0);
        mc.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 101.0f);
        matrixStack.method_22904(8.0, 8.0, 0.0);
        matrixStack.method_22905(1.0f, -1.0f, 1.0f);
        matrixStack.method_22905(8.0f, 8.0f, 8.0f);
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 immediate = mc.method_22940().method_23000();
        class_308.method_24210();
        itemRenderer.method_23179(tool, class_811.field_4317, false, new class_4587(), (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        matrixStack.method_22909();
        this.renderManager.drawSmallText(drawContext, "" + remainingDamage, drawX + 6, drawY, ModTheme.WHITE, true);
    }
}

