/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.component.components;

import com.wjbaker.ccm.crosshair.property.IntegerProperty;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.gui.component.components.SliderGuiComponent;
import com.wjbaker.ccm.render.gui.component.type.IBindableGuiComponent;
import com.wjbaker.ccm.render.gui.screen.GuiScreen;
import net.minecraft.class_332;

public class IntegerSliderGuiComponent
extends SliderGuiComponent
implements IBindableGuiComponent<IntegerProperty> {
    private IntegerProperty value;

    public IntegerSliderGuiComponent(GuiScreen parentGuiScreen, int x, int y, int width, String label, int minValue, int maxValue, int defaultValue) {
        super(parentGuiScreen, x, y, width, label, minValue, maxValue, defaultValue);
        this.value = new IntegerProperty("fake_value", this.defaultValue);
        this.thumbPosition = ((Integer)this.value.get() - this.minValue) * (this.width - this.thumbSize) / (this.maxValue - this.minValue);
    }

    @Override
    protected void calculateValue() {
        float positionRatio = (float)this.thumbPosition / (float)(this.width - this.thumbSize);
        int newValue = (int)((float)this.minValue + (float)(this.maxValue - this.minValue) * positionRatio);
        this.value.set(newValue);
    }

    @Override
    protected void drawLabel(class_332 drawContext) {
        int posY = this.y + 8 + this.titleSpacing;
        this.renderManager.drawText(drawContext, "" + this.value.get(), this.x + this.width + this.titleSpacing, posY + this.thumbSize / 2 - 3, ModTheme.WHITE, false);
    }

    @Override
    public void bind(IntegerProperty property) {
        this.value = property;
    }

    public int getValue() {
        return (Integer)this.value.get();
    }
}

