/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.wjbaker.ccm.crosshair.custom.CustomCrosshairDrawer;
import com.wjbaker.ccm.render.type.GuiBounds;
import com.wjbaker.ccm.render.type.IDrawInsideWindowCallback;
import com.wjbaker.ccm.type.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.lwjgl.opengl.GL11;

public final class RenderManager {
    private void setGlProperty(int property, boolean isEnabled) {
        if (isEnabled) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    private void preRender(PoseStack matrixStack) {
        matrixStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void postRender(PoseStack matrixStack) {
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        matrixStack.m_85849_();
    }

    public void drawLines(PoseStack matrixStack, float[] points, float thickness, RGBA colour) {
        this.drawLines(matrixStack, points, thickness, colour, false);
    }

    public void drawLines(PoseStack matrixStack, float[] points, float thickness, RGBA colour, boolean isBlendEnabled) {
        Tesselator tesselator = RenderSystem.m_69883_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        this.preRender(matrixStack);
        if (isBlendEnabled) {
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.m_85982_(matrixStack.m_85850_().m_85861_(), points[i], points[i + 1], 0.0f).m_6122_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).m_85977_(matrixStack.m_85850_().m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
        }
        tesselator.m_85914_();
        this.postRender(matrixStack);
    }

    public void drawFilledShape(PoseStack matrixStack, float[] points, RGBA colour) {
        this.drawFilledShape(matrixStack, points, colour, false);
    }

    public void drawFilledShape(PoseStack matrixStack, float[] points, RGBA colour, boolean isBlendEnabled) {
        this.setGlProperty(2848, false);
        Tesselator tesselator = RenderSystem.m_69883_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        this.preRender(matrixStack);
        if (isBlendEnabled) {
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.m_85982_(matrixStack.m_85850_().m_85861_(), points[i], points[i + 1], 0.0f).m_6122_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).m_5752_();
        }
        tesselator.m_85914_();
        this.postRender(matrixStack);
    }

    public void drawLine(PoseStack matrixStack, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(matrixStack, new float[]{x1, y1, x2, y2}, thickness, colour);
    }

    public void drawRectangle(PoseStack matrixStack, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(matrixStack, new float[]{x1, y1, x2, y1, x2, y1, x2, y2, x1, y2, x2, y2, x1, y1, x1, y2}, thickness, colour);
    }

    public void drawFilledRectangle(PoseStack matrixStack, float x1, float y1, float x2, float y2, RGBA colour) {
        this.drawFilledRectangle(matrixStack, x1, y1, x2, y2, colour, false);
    }

    public void drawFilledRectangle(PoseStack matrixStack, float x1, float y1, float x2, float y2, RGBA colour, boolean isBlendEnabled) {
        this.drawFilledShape(matrixStack, new float[]{x1, y1, x1, y2, x2, y2, x2, y1}, colour, isBlendEnabled);
    }

    public void drawBorderedRectangle(PoseStack matrixStack, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour) {
        this.drawBorderedRectangle(matrixStack, x1, y1, x2, y2, borderThickness, borderColour, fillColour, false);
    }

    public void drawBorderedRectangle(PoseStack matrixStack, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour, boolean isBlendEnabled) {
        this.drawFilledRectangle(matrixStack, x1, y1, x2, y2, fillColour, isBlendEnabled);
        this.drawRectangle(matrixStack, x1, y1, x2, y2, borderThickness, borderColour);
    }

    public void drawPartialCircle(PoseStack matrixStack, float x, float y, float radius, int startAngleAt, int endAngleAt, float thickness, RGBA colour) {
        this.setGlProperty(2848, true);
        int startAngle = Math.max(0, Math.min(startAngleAt, endAngleAt));
        int endAngle = Math.min(360, Math.max(startAngleAt, endAngleAt));
        RenderSystem.m_69832_((float)thickness);
        float ratio = (float)Math.PI / 180;
        Tesselator tesselator = RenderSystem.m_69883_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        this.preRender(matrixStack);
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.m_85982_(matrixStack.m_85850_().m_85861_(), x + (float)Math.cos(radians) * radius, y + (float)Math.sin(radians) * radius, 0.0f).m_6122_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).m_85977_(matrixStack.m_85850_().m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
        }
        tesselator.m_85914_();
        this.postRender(matrixStack);
    }

    public void drawCircle(PoseStack matrixStack, float x, float y, float radius, float thickness, RGBA colour) {
        this.drawPartialCircle(matrixStack, x, y, radius, 0, 360, thickness, colour);
    }

    public void drawFilledCircle(PoseStack matrixStack, float x, float y, float radius, RGBA colour) {
        float[] points = new float[722];
        float ratio = (float)Math.PI / 180;
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            points[i * 2] = x + (float)Math.cos(radians) * radius;
            points[i * 2 + 1] = y + (float)Math.sin(radians) * radius;
        }
        this.drawFilledShape(matrixStack, points, colour);
    }

    public void drawTorus(PoseStack matrixStack, int x, int y, int innerRadius, int outerRadius, RGBA colour) {
        this.setGlProperty(2848, true);
        float ratio = (float)Math.PI / 180;
        Tesselator tesselator = RenderSystem.m_69883_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        this.preRender(matrixStack);
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.m_85982_(matrixStack.m_85850_().m_85861_(), (float)x + (float)Math.cos(radians) * (float)innerRadius, (float)y + (float)Math.sin(radians) * (float)innerRadius, 0.0f).m_6122_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).m_85977_(matrixStack.m_85850_().m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
            bufferBuilder.m_85982_(matrixStack.m_85850_().m_85861_(), (float)x + (float)Math.cos(radians) * (float)outerRadius, (float)y + (float)Math.sin(radians) * (float)outerRadius, 0.0f).m_6122_(colour.getRed(), colour.getGreen(), colour.getBlue(), colour.getOpacity()).m_85977_(matrixStack.m_85850_().m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
        }
        tesselator.m_85914_();
        this.postRender(matrixStack);
    }

    public void drawImage(PoseStack matrixStack, int x, int y, CustomCrosshairDrawer image, RGBA colour, boolean isCentered) {
        float offsetX = isCentered ? (float)image.getWidth() / 2.0f : 0.0f;
        float offsetY = isCentered ? (float)image.getHeight() / 2.0f : 0.0f;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int imageX = 0; imageX < width; ++imageX) {
            for (int imageY = 0; imageY < height; ++imageY) {
                if (image.getAt(imageX, imageY) != 1) continue;
                float drawX = (float)(x + imageX) - offsetX;
                float drawY = (float)(y + imageY) - offsetY;
                this.drawFilledRectangle(matrixStack, drawX, drawY, drawX + 1.0f, drawY + 1.0f, colour);
            }
        }
    }

    public void drawText(PoseStack matrixStack, String text, int x, int y, RGBA colour, boolean hasShadow) {
        int colourAsInt = this.rgbaAsInt(colour);
        if (hasShadow) {
            Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, text, (float)x, (float)y, colourAsInt);
        } else {
            Minecraft.m_91087_().f_91062_.m_92883_(matrixStack, text, (float)x, (float)y, colourAsInt);
        }
    }

    public void drawSmallText(PoseStack matrixStack, String text, int x, int y, RGBA colour, boolean hasShadow) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        RenderSystem.m_157182_();
        this.drawText(matrixStack, text, x * 2, y * 2, colour, hasShadow);
        matrixStack.m_85849_();
    }

    public void drawBigText(PoseStack matrixStack, String text, int x, int y, RGBA colour, boolean hasShadow) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(1.5f, 1.5f, 1.0f);
        RenderSystem.m_157182_();
        this.drawText(matrixStack, text, (int)((float)x * 0.666f), (int)((float)y * 0.666f), colour, hasShadow);
        matrixStack.m_85849_();
    }

    private int rgbaAsInt(RGBA colour) {
        return (colour.getOpacity() << 24) + (colour.getRed() << 16) + (colour.getGreen() << 8) + colour.getBlue();
    }

    public int textWidth(String text) {
        return Minecraft.m_91087_().f_91062_.m_92895_(text);
    }

    public void drawInsideBounds(GuiBounds bounds, IDrawInsideWindowCallback callback) {
        this.setGlProperty(3089, true);
        Window window = Minecraft.m_91087_().m_91268_();
        double scale = window.m_85449_();
        GL11.glScissor((int)((int)Math.round((double)bounds.x() * scale)), (int)((int)Math.round((double)window.m_85442_() - (double)bounds.y() * scale - (double)bounds.height() * scale)), (int)((int)Math.round((double)bounds.width() * scale)), (int)((int)Math.round((double)bounds.height() * scale)));
        callback.draw();
        this.setGlProperty(3089, false);
    }
}

