/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.screen;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.helper.ExternalHelper;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.render.gui.component.GuiComponent;
import com.wjbaker.ccm.render.gui.component.GuiComponentWithComponents;
import com.wjbaker.ccm.render.gui.component.components.ButtonGuiComponent;
import com.wjbaker.ccm.render.gui.component.event.IOnClickEvent;
import com.wjbaker.ccm.render.gui.screen.GuiScreenAdapter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public abstract class GuiScreen
extends GuiScreenAdapter {
    protected final RenderManager renderManager = new RenderManager();
    protected final GuiScreen parentGuiScreen;
    protected final List<GuiComponent> components;
    protected final int headerHeight;
    private final ButtonGuiComponent newVersionButton;
    private final ButtonGuiComponent patreonButton;
    private final ButtonGuiComponent paypalButton;

    public GuiScreen(String title) {
        this(title, null);
    }

    public GuiScreen(String title, GuiScreen parentGuiScreen) {
        super(title);
        this.parentGuiScreen = parentGuiScreen;
        this.components = new ArrayList<GuiComponent>();
        this.headerHeight = 35;
        this.newVersionButton = new ButtonGuiComponent(this, -1, -1, 125, 25, "New Version Available!");
        this.newVersionButton.setBaseBackgroundColour(ModTheme.TERTIARY);
        this.newVersionButton.setHoverBackgroundColour(ModTheme.TERTIARY_DARK);
        this.newVersionButton.setBaseTextColour(ModTheme.BLACK);
        this.newVersionButton.setHoverTextColour(ModTheme.BLACK);
        this.newVersionButton.addEvent(IOnClickEvent.class, () -> {
            if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
                new ExternalHelper().openInBrowser("https://www.curseforge.com/projects/242995/");
            }
        });
        this.patreonButton = new ButtonGuiComponent(this, -1, -1, 125, 25, "Support via Patreon!");
        this.patreonButton.setBaseBackgroundColour(ModTheme.SECONDARY);
        this.patreonButton.setHoverBackgroundColour(ModTheme.PRIMARY);
        this.patreonButton.setBaseTextColour(ModTheme.WHITE);
        this.patreonButton.setHoverTextColour(ModTheme.WHITE);
        this.patreonButton.addEvent(IOnClickEvent.class, () -> new ExternalHelper().openInBrowser("https://www.patreon.com/bePatron?u=66431720"));
        this.paypalButton = new ButtonGuiComponent(this, -1, -1, 125, 25, "Support via PayPal!");
        this.paypalButton.setBaseBackgroundColour(ModTheme.SECONDARY);
        this.paypalButton.setHoverBackgroundColour(ModTheme.PRIMARY);
        this.paypalButton.setBaseTextColour(ModTheme.WHITE);
        this.paypalButton.setHoverTextColour(ModTheme.WHITE);
        this.paypalButton.addEvent(IOnClickEvent.class, () -> new ExternalHelper().openInBrowser("https://www.paypal.com/cgi-bin/webscr?return=https://www.curseforge.com/projects/242995&cn=Add+special+instructions+to+the+addon+author()&business=sparkless101%40gmail.com&bn=PP-DonationsBF:btn_donateCC_LG.gif:NonHosted&cancel_return=https://www.curseforge.com/projects/242995&lc=US&item_name=Custom+Crosshair+Mod+(from+curseforge.com)&cmd=_donations&rm=1&no_shipping=1&currency_code=USD"));
    }

    @Override
    public void update() {
        this.components.forEach(GuiComponent::update);
        int x = this.field_22789;
        this.newVersionButton.setPosition(x -= this.newVersionButton.getWidth() + 5, this.headerHeight / 2 - this.newVersionButton.getHeight() / 2);
        this.patreonButton.setPosition(x -= this.patreonButton.getWidth() + 5, this.headerHeight / 2 - this.patreonButton.getHeight() / 2);
        this.paypalButton.setPosition(x -= this.paypalButton.getWidth() + 5, this.headerHeight / 2 - this.paypalButton.getHeight() / 2);
    }

    @Override
    public void draw(class_332 drawContext) {
        class_4587 matrixStack = drawContext.method_51448();
        this.renderManager.drawFilledRectangle(matrixStack, 0.0f, 0.0f, this.field_22789, this.field_22790, ModTheme.BLACK.setOpacity(140));
        this.components.forEach(x -> x.draw(drawContext));
        this.drawHeader(drawContext);
    }

    private void drawHeader(class_332 drawContext) {
        class_4587 matrixStack = drawContext.method_51448();
        this.renderManager.drawFilledRectangle(matrixStack, 0.0f, 0.0f, this.field_22789, this.headerHeight, ModTheme.PRIMARY);
        this.renderManager.drawLine(matrixStack, 0.0f, this.headerHeight, this.field_22789, this.headerHeight, 2.0f, ModTheme.DARK_GREY);
        int titleWidth = this.renderManager.textWidth("Custom Crosshair Mod");
        int centreY = this.headerHeight / 2 - 3;
        this.renderManager.drawText(drawContext, "Custom Crosshair Mod", 5, centreY, ModTheme.WHITE, true);
        this.renderManager.drawSmallText(drawContext, "v1.5.3-fabric", 8 + titleWidth, this.headerHeight / 2, ModTheme.DARK_GREY, false);
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
            this.newVersionButton.draw(drawContext);
        }
        this.patreonButton.draw(drawContext);
        this.paypalButton.draw(drawContext);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        this.components.stream().filter(x -> x.isInsideComponent(mouseX, mouseY)).forEach(x -> x.onMouseDown(mouseX, mouseY, button));
        this.newVersionButton.onMouseDown(mouseX, mouseY, button);
        this.patreonButton.onMouseDown(mouseX, mouseY, button);
        this.paypalButton.onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.components.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
        this.newVersionButton.onMouseUp(mouseX, mouseY, button);
        this.patreonButton.onMouseUp(mouseX, mouseY, button);
        this.paypalButton.onMouseUp(mouseX, mouseY, button);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseMove(mouseX, mouseY));
        this.newVersionButton.onMouseMove(mouseX, mouseY);
        this.patreonButton.onMouseMove(mouseX, mouseY);
        this.paypalButton.onMouseMove(mouseX, mouseY);
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseDrag(startX, startY, mouseX, mouseY));
    }

    @Override
    public void onMouseScrollUp() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollUp);
    }

    @Override
    public void onMouseScrollDown() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollDown);
    }

    @Override
    public void onKeyDown(int keyCode) {
        if (keyCode == 256 && this.parentGuiScreen != null) {
            class_310.method_1551().method_1507((class_437)this.parentGuiScreen);
        }
    }

    @Override
    public void onKeyUp(int keyCode) {
    }

    @Override
    public void method_25419() {
        CustomCrosshairMod.INSTANCE.configManager().write();
        super.method_25419();
    }
}

