/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm;

import com.wjbaker.ccm.config.ConfigManager;
import com.wjbaker.ccm.config.GlobalProperties;
import com.wjbaker.ccm.helper.RequestHelper;
import com.wjbaker.ccm.render.gui.screen.screens.editCrosshair.EditCrosshairGuiScreen;
import com.wjbaker.ccm.translations.ModTranslations;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CustomCrosshairMod
implements ModInitializer {
    public static CustomCrosshairMod INSTANCE;
    public static final String TITLE = "Custom Crosshair Mod";
    public static final String VERSION = "1.5.3-fabric";
    public static final String MC_VERSION = "1.20.4-fabric";
    public static final String CURSEFORGE_PAGE = "https://www.curseforge.com/projects/242995/";
    public static final String MC_FORUMS_PAGE = "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    public static final String PATREON_PAGE = "https://www.patreon.com/bePatron?u=66431720";
    public static final String PAYPAL_PAGE = "https://www.paypal.com/cgi-bin/webscr?return=https://www.curseforge.com/projects/242995&cn=Add+special+instructions+to+the+addon+author()&business=sparkless101%40gmail.com&bn=PP-DonationsBF:btn_donateCC_LG.gif:NonHosted&cancel_return=https://www.curseforge.com/projects/242995&lc=US&item_name=Custom+Crosshair+Mod+(from+curseforge.com)&cmd=_donations&rm=1&no_shipping=1&currency_code=USD";
    private final Logger logger = LogManager.getLogger(CustomCrosshairMod.class);
    private final class_310 mc = class_310.method_1551();
    private final GlobalProperties properties = new GlobalProperties();
    private ConfigManager configManager;

    public void onInitialize() {
        INSTANCE = this;
        this.loadConfig();
        this.checkVersionAsync();
        this.loadKeyBindings();
        this.properties.getCustomCrosshairDrawer().loadImage();
    }

    private void loadConfig() {
        this.configManager = new ConfigManager("crosshair_config.ccmcfg", this.properties.getCrosshair(), this.properties.getIsModEnabled());
        if (!this.configManager.read() && !this.configManager.write()) {
            this.error("Config Manager (Load)", "Unable to load or write config.", new Object[0]);
        }
    }

    private void checkVersionAsync() {
        Executors.newSingleThreadExecutor().submit(this::checkVersion);
    }

    private void checkVersion() {
        try (BufferedReader reader = new RequestHelper().get("https://pastebin.com/raw/B2sL8QCh");){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                String[] lineSplit = currentLine.split(" ");
                if (lineSplit.length != 2) continue;
                String mcVersion = lineSplit[0];
                String expectedModVersion = lineSplit[1];
                if (!mcVersion.equals(MC_VERSION) || expectedModVersion.equals(VERSION)) continue;
                this.log("Version Checker", "Not using latest version of Customer Crosshair Mod.", new Object[0]);
                this.properties.setLatestVersion(false);
            }
        }
        catch (IOException e) {
            this.error("Version Checker", "Unable to check the version.", new Object[0]);
        }
    }

    private void loadKeyBindings() {
        class_304 editCrosshair = new class_304(ModTranslations.KEYBIND_OPEN_EDIT_CROSSHAIR_GUI.method_11022(), class_3675.class_307.field_1668, 96, ModTranslations.GUI_MOD_KEYBINDS_CATEGORY.method_11022());
        KeyBindingHelper.registerKeyBinding((class_304)editCrosshair);
        ClientTickEvents.END_CLIENT_TICK.register(e -> {
            if (this.mc.field_1755 == null && editCrosshair.method_1434()) {
                this.mc.method_1507((class_437)new EditCrosshairGuiScreen(this.properties.getCrosshair()));
            }
        });
    }

    public GlobalProperties properties() {
        return this.properties;
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public void log(String action, String message, Object ... values) {
        this.logger.info(String.format("[%s] %s", action, message), values);
    }

    public void error(String action, String message, Object ... values) {
        this.logger.error(String.format("[%s] %s", action, message), values);
    }
}

