/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.type.RGBA;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5498;
import net.minecraft.class_746;

public final class ComputedProperties {
    private final class_310 mc;
    private final CustomCrosshair crosshair;
    private final int gap;
    private final RGBA colour;
    private final boolean isVisible;
    private final Set<class_1792> rangedWeapons = ImmutableSet.of((Object)class_1802.field_8102, (Object)class_1802.field_8547, (Object)class_1802.field_8399);
    private final Set<class_1792> throwableItems = ImmutableSet.of((Object)class_1802.field_8634, (Object)class_1802.field_8449);
    private final Map<class_1792, Float> usageItemsDurations = ImmutableMap.of((Object)class_1802.field_8102, (Object)Float.valueOf(20.0f), (Object)class_1802.field_8547, (Object)Float.valueOf(10.0f), (Object)class_1802.field_8399, (Object)Float.valueOf(0.0f));

    public ComputedProperties(CustomCrosshair crosshair) {
        this.mc = class_310.method_1551();
        this.crosshair = crosshair;
        this.gap = this.calculateGap();
        this.colour = this.calculateColour();
        this.isVisible = this.calculateIsVisible();
    }

    public int gap() {
        return this.gap;
    }

    public RGBA colour() {
        return this.colour;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    private int calculateGap() {
        Integer baseGap = (Integer)this.crosshair.gap.get();
        if (this.mc.field_1724 == null) {
            return baseGap;
        }
        boolean isSpectator = this.mc.field_1724.method_7325();
        boolean isHoldingItem = !this.mc.field_1724.method_5998(class_1268.field_5810).method_7960() || !this.mc.field_1724.method_5998(class_1268.field_5808).method_7960();
        Boolean isDynamicBowEnabled = (Boolean)this.crosshair.isDynamicBowEnabled.get();
        Boolean isDynamicAttackIndicatorEnabled = (Boolean)this.crosshair.isDynamicAttackIndicatorEnabled.get();
        if (isSpectator || !isHoldingItem || !isDynamicAttackIndicatorEnabled.booleanValue() && !isDynamicBowEnabled.booleanValue()) {
            return baseGap;
        }
        int gapModifier = 2;
        Float usageItemDuration = this.usageItemsDurations.get(this.mc.field_1724.method_6030().method_7909());
        if (isDynamicBowEnabled.booleanValue() && usageItemDuration != null) {
            if (this.mc.field_1724.method_6030().method_7909() == class_1802.field_8399) {
                usageItemDuration = Float.valueOf(class_1764.method_7775((class_1799)this.mc.field_1724.method_6030()));
            }
            float progress = Math.min(usageItemDuration.floatValue(), (float)this.mc.field_1724.method_6048());
            return baseGap + Math.round((usageItemDuration.floatValue() - progress) * (float)gapModifier);
        }
        if (isDynamicAttackIndicatorEnabled.booleanValue()) {
            boolean hasAttackSpeedModifier = this.mc.field_1724.method_6047().method_7909().method_7844(class_1304.field_6173).entries().stream().anyMatch(x -> ((class_1320)x.getKey()).equals(class_5134.field_23723));
            if (!hasAttackSpeedModifier) {
                return baseGap;
            }
            float currentAttackUsage = this.mc.field_1724.method_7261(1.0f);
            float maxAttackUsage = 1.0f;
            if (this.mc.field_1724.method_7279() > 5.0f && currentAttackUsage < maxAttackUsage) {
                return baseGap + Math.round((maxAttackUsage - currentAttackUsage) * (float)gapModifier * 20.0f);
            }
        }
        return baseGap;
    }

    private RGBA calculateColour() {
        class_1297 target = this.mc.field_1692;
        Boolean isHighlightPlayersEnabled = (Boolean)this.crosshair.isHighlightPlayersEnabled.get();
        if (isHighlightPlayersEnabled.booleanValue() && target instanceof class_1657) {
            return (RGBA)this.crosshair.highlightPlayersColour.get();
        }
        Boolean isHighlightHostilesEnabled = (Boolean)this.crosshair.isHighlightHostilesEnabled.get();
        if (isHighlightHostilesEnabled.booleanValue() && (target instanceof class_1569 || target instanceof class_5354)) {
            return (RGBA)this.crosshair.highlightHostilesColour.get();
        }
        Boolean isHighlightPassivesEnabled = (Boolean)this.crosshair.isHighlightPassivesEnabled.get();
        if (isHighlightPassivesEnabled.booleanValue() && target instanceof class_1296) {
            return (RGBA)this.crosshair.highlightPassivesColour.get();
        }
        if (((Boolean)this.crosshair.isRainbowEnabled.get()).booleanValue()) {
            return this.getRainbowColour();
        }
        return (RGBA)this.crosshair.colour.get();
    }

    private RGBA getRainbowColour() {
        int ticks = (Integer)this.crosshair.rainbowTicks.get() + 1;
        if (ticks > 125000) {
            ticks = 0;
        }
        this.crosshair.rainbowTicks.set(ticks);
        int opacity = ((RGBA)this.crosshair.colour.get()).getOpacity();
        Integer speed = (Integer)this.crosshair.rainbowSpeed.get();
        return new RGBA(255, 255, 255, opacity).setRed(this.getRainbowColourComponent(ticks, 0.0f, speed)).setGreen(this.getRainbowColourComponent(ticks, 2.0f, speed)).setBlue(this.getRainbowColourComponent(ticks, 4.0f, speed));
    }

    private int getRainbowColourComponent(int ticks, float offset, int speed) {
        return (int)(Math.sin((float)(ticks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }

    private boolean calculateIsVisible() {
        boolean isThirdPerson;
        if (this.mc.field_1724 == null) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleDefault.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHiddenGui.get()).booleanValue() && this.mc.field_1690.field_1842) {
            return false;
        }
        class_5498 pov = this.mc.field_1690.method_31044();
        boolean bl = isThirdPerson = pov == class_5498.field_26665 || pov == class_5498.field_26666;
        if (!((Boolean)this.crosshair.isVisibleThirdPerson.get()).booleanValue() && isThirdPerson) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleDebug.get()).booleanValue() && this.mc.field_1705.method_53531().method_53536()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleSpectator.get()).booleanValue() && this.mc.field_1724.method_7325()) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHoldingRangedWeapon.get()).booleanValue() && this.isHoldingItem(this.mc.field_1724, this.rangedWeapons)) {
            return false;
        }
        if (!((Boolean)this.crosshair.isVisibleHoldingThrowableItem.get()).booleanValue() && this.isHoldingItem(this.mc.field_1724, this.throwableItems)) {
            return false;
        }
        return (Boolean)this.crosshair.isVisibleUsingSpyglass.get() != false || !this.mc.field_1724.method_31550();
    }

    private boolean isHoldingItem(class_746 player, Set<class_1792> items) {
        class_1799 mainHandItem = player.method_6047();
        boolean isMainHand = items.contains(mainHandItem.method_7909());
        boolean isOffhand = items.contains(player.method_6079().method_7909());
        return isMainHand || isOffhand && mainHandItem.method_7960();
    }
}

