/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm;

import com.wjbaker.ccm.config.ConfigManager;
import com.wjbaker.ccm.config.GlobalProperties;
import com.wjbaker.ccm.crosshair.render.CrosshairRenderManager;
import com.wjbaker.ccm.helper.RequestHelper;
import com.wjbaker.ccm.render.gui.screen.screens.editCrosshair.EditCrosshairGuiScreen;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="custom_crosshair_mod")
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class CustomCrosshairMod {
    public static CustomCrosshairMod INSTANCE;
    public static final String TITLE = "Custom Crosshair Mod";
    public static final String VERSION = "1.5.3-forge";
    public static final String MC_VERSION = "1.19.4-forge";
    public static final String CURSEFORGE_PAGE = "https://www.curseforge.com/projects/242995/";
    public static final String MC_FORUMS_PAGE = "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    public static final String PATREON_PAGE = "https://www.patreon.com/bePatron?u=66431720";
    public static final String PAYPAL_PAGE = "https://www.paypal.com/cgi-bin/webscr?return=https://www.curseforge.com/projects/242995&cn=Add+special+instructions+to+the+addon+author()&business=sparkless101%40gmail.com&bn=PP-DonationsBF:btn_donateCC_LG.gif:NonHosted&cancel_return=https://www.curseforge.com/projects/242995&lc=US&item_name=Custom+Crosshair+Mod+(from+curseforge.com)&cmd=_donations&rm=1&no_shipping=1&currency_code=USD";
    private static final KeyMapping editCrosshairKeyBinding;
    private final Logger logger = LogManager.getLogger(CustomCrosshairMod.class);
    private final GlobalProperties properties = new GlobalProperties();
    private final CrosshairRenderManager crosshairRenderManager = new CrosshairRenderManager(false);
    private ConfigManager configManager;

    public CustomCrosshairMod() {
        INSTANCE = this;
        this.loadConfig();
        this.checkVersionAsync();
        this.properties.getCustomCrosshairDrawer().loadImage();
    }

    private void loadConfig() {
        this.configManager = new ConfigManager("crosshair_config.ccmcfg", this.properties.getCrosshair(), this.properties.getIsModEnabled());
        if (!this.configManager.read() && !this.configManager.write()) {
            this.error("Config Manager (Load)", "Unable to load or write config.", new Object[0]);
        }
    }

    private void checkVersionAsync() {
        Executors.newSingleThreadExecutor().submit(this::checkVersion);
    }

    private void checkVersion() {
        try (BufferedReader reader = new RequestHelper().get("https://pastebin.com/raw/B2sL8QCh");){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                String[] lineSplit = currentLine.split(" ");
                if (lineSplit.length != 2) continue;
                String mcVersion = lineSplit[0];
                String expectedModVersion = lineSplit[1];
                if (!mcVersion.equals(MC_VERSION) || expectedModVersion.equals(VERSION)) continue;
                this.log("Version Checker", "Not using latest version of Customer Crosshair Mod.", new Object[0]);
                this.properties.setLatestVersion(false);
            }
        }
        catch (IOException e) {
            this.error("Version Checker", "Unable to check the version.", new Object[0]);
        }
    }

    private static String identifier(String id) {
        return String.format("key.custom-crosshair-mod.%s", id);
    }

    @SubscribeEvent
    public static void onRegisterKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(editCrosshairKeyBinding);
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91080_ == null && editCrosshairKeyBinding.m_90857_()) {
            Minecraft.m_91087_().m_91152_((Screen)new EditCrosshairGuiScreen(CustomCrosshairMod.INSTANCE.properties.getCrosshair()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderCrosshair(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id() != VanillaGuiOverlay.CROSSHAIR.id()) {
            return;
        }
        event.setCanceled(((Boolean)CustomCrosshairMod.INSTANCE.properties.getIsModEnabled().get()).booleanValue());
    }

    @SubscribeEvent
    public static void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties.getIsModEnabled().get()).booleanValue()) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ != null && !(Minecraft.m_91087_().f_91080_ instanceof ChatScreen)) {
            return;
        }
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int x = Math.round((float)width / 2.0f);
        int y = Math.round((float)height / 2.0f);
        CustomCrosshairMod.INSTANCE.crosshairRenderManager.draw(CustomCrosshairMod.INSTANCE.properties.getCrosshair(), x, y);
    }

    public GlobalProperties properties() {
        return this.properties;
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public void log(String action, String message, Object ... values) {
        this.logger.info(String.format("[%s] %s", action, message), values);
    }

    public void error(String action, String message, Object ... values) {
        this.logger.error(String.format("[%s] %s", action, message), values);
    }

    static {
        editCrosshairKeyBinding = new KeyMapping(CustomCrosshairMod.identifier("edit_crosshair"), 96, CustomCrosshairMod.identifier("category"));
    }
}

