/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class CrosshairRenderManager {
    private final boolean isForGui;
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<Item> itemCooldownItems = ImmutableSet.of((Object)Items.f_42584_, (Object)Items.f_42730_);

    public CrosshairRenderManager(boolean isForGui) {
        this.isForGui = isForGui;
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(CustomCrosshair crosshair, int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        PoseStack matrixStack = new PoseStack();
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Pre(Minecraft.m_91087_().m_91268_(), matrixStack, 1.0f, VanillaGuiOverlay.CROSSHAIR.type()));
        CrosshairStyle calculatedStyle = Minecraft.m_91087_().f_91066_.f_92063_ && (Boolean)crosshair.isKeepDebugEnabled.get() != false ? CrosshairStyle.DEBUG : (CrosshairStyle)((Object)crosshair.style.get());
        ICrosshairStyle style = this.crosshairStyleFactory.from(calculatedStyle, crosshair);
        boolean isItemCooldownEnabled = (Boolean)crosshair.isItemCooldownEnabled.get();
        boolean isDotEnabled = (Boolean)crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled) {
            this.drawItemCooldownIndicator(matrixStack, crosshair, computedProperties, x, y);
        }
        if (isDotEnabled && crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(matrixStack, x, y, 0.5f, 1.0f, (RGBA)crosshair.dotColour.get());
        }
        this.drawDefaultAttackIndicator(matrixStack, computedProperties, x, y);
        PoseStack transformMatrixStack = calculatedStyle == CrosshairStyle.DEBUG ? RenderSystem.m_157191_() : matrixStack;
        int renderX = x + (Integer)crosshair.offsetX.get();
        int renderY = y + (Integer)crosshair.offsetY.get();
        this.drawToolDamageIndicator(transformMatrixStack, crosshair, computedProperties, renderX, renderY);
        this.preTransformation(transformMatrixStack, crosshair, renderX, renderY);
        style.draw(transformMatrixStack, 0, 0, computedProperties);
        this.postTransformation(transformMatrixStack);
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(Minecraft.m_91087_().m_91268_(), matrixStack, 1.0f, VanillaGuiOverlay.CROSSHAIR.type()));
    }

    private void preTransformation(PoseStack matrixStack, CustomCrosshair crosshair, int x, int y) {
        Integer rotation = (Integer)crosshair.rotation.get();
        int scale = (Integer)crosshair.scale.get() - 2;
        float windowScaling = (float)Minecraft.m_91087_().m_91268_().m_85449_() / 2.0f;
        float z = this.isForGui ? 0.0f : 1000.0f - ForgeHooksClient.getGuiFarPlane();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)x, (float)y, z);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)rotation.intValue()));
        matrixStack.m_85841_((float)scale / 100.0f / windowScaling, (float)scale / 100.0f / windowScaling, 1.0f);
        RenderSystem.m_157182_();
    }

    private void postTransformation(PoseStack matrixStack) {
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void drawItemCooldownIndicator(PoseStack matrixStack, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)crosshair.itemCooldownColour.get();
        int width = (Integer)crosshair.width.get();
        int height = (Integer)crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (Item item : this.itemCooldownItems) {
            float cooldown = player.m_36335_().m_41521_(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(matrixStack, x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(PoseStack matrixStack, ComputedProperties computedProperties, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.CROSSHAIR && mc.f_91074_ != null) {
            float f = mc.f_91074_.m_36403_(0.0f);
            boolean flag = false;
            if (mc.f_91076_ instanceof LivingEntity && f < 1.0f) {
                flag = mc.f_91074_.m_36333_() > 5.0f;
                flag &= mc.f_91076_.m_6084_();
            }
            int j = mc.m_91268_().m_85446_() / 2 - 7 + 16;
            int k = mc.m_91268_().m_85445_() / 2 - 8;
            if (flag) {
                GuiComponent.m_93143_((PoseStack)matrixStack, (int)k, (int)j, (int)0, (float)68.0f, (float)94.0f, (int)16, (int)16, (int)256, (int)256);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                GuiComponent.m_93143_((PoseStack)matrixStack, (int)k, (int)j, (int)0, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
                GuiComponent.m_93143_((PoseStack)matrixStack, (int)k, (int)j, (int)0, (float)52.0f, (float)94.0f, (int)l, (int)4, (int)256, (int)256);
            }
        }
    }

    private void drawToolDamageIndicator(PoseStack matrixStackP, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        if (!((Boolean)crosshair.isToolDamageEnabled.get()).booleanValue()) {
            return;
        }
        int drawX = x + (Integer)crosshair.gap.get() + 5;
        int drawY = y + (Integer)crosshair.gap.get() + 5;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack tool = mc.f_91074_.m_21205_();
        if (!tool.m_41763_()) {
            return;
        }
        int remainingDamage = tool.m_41776_() - tool.m_41773_();
        if (remainingDamage > 10) {
            return;
        }
        ItemRenderer itemRenderer = mc.m_91291_();
        BakedModel model = itemRenderer.m_174264_(tool, null, null, 0);
        mc.m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = RenderSystem.m_157191_();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)x, (float)y, 101.0f);
        matrixStack.m_85837_(8.0, 8.0, 0.0);
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        matrixStack.m_85841_(8.0f, 8.0f, 8.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(tool, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, model);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        Lighting.m_84931_();
        matrixStack.m_85849_();
        this.renderManager.drawSmallText(matrixStackP, "" + remainingDamage, drawX + 6, drawY, ModTheme.WHITE, true);
    }
}

