/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.component;

import com.wjbaker.ccm.render.gui.component.GuiComponent;
import com.wjbaker.ccm.render.gui.component.GuiComponentTheme;
import com.wjbaker.ccm.render.gui.event.IMouseEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public abstract class GuiComponentWithComponents
extends GuiComponentTheme
implements IMouseEvents {
    protected List<GuiComponent> components = new ArrayList<GuiComponent>();

    public void clearComponents() {
        this.components.clear();
    }

    public void draw(GuiGraphics guiGraphics) {
        this.components.forEach(x -> x.draw(guiGraphics));
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        this.components.stream().filter(x -> x.isInsideComponent(mouseX, mouseY)).forEach(x -> x.onMouseDown(mouseX, mouseY, button));
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.components.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseMove(mouseX, mouseY));
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseDrag(startX, startY, mouseX, mouseY));
    }

    @Override
    public void onMouseScrollUp() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollUp);
    }

    @Override
    public void onMouseScrollDown() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollDown);
    }
}

