/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.component.components;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.property.RGBAProperty;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.gui.component.GuiComponent;
import com.wjbaker.ccm.render.gui.component.type.IBindableGuiComponent;
import com.wjbaker.ccm.render.gui.screen.GuiScreen;
import com.wjbaker.ccm.render.gui.screen.screens.editColour.EditColourGuiScreen;
import com.wjbaker.ccm.type.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;

public final class ColourPickerGuiComponent
extends GuiComponent
implements IBindableGuiComponent<RGBAProperty> {
    private final int labelSpacing;
    private final int boxSize;
    private final String label;
    private final CustomCrosshair crosshair;
    private RGBAProperty colour;
    private boolean isMouseOverBox;

    public ColourPickerGuiComponent(GuiScreen parentGuiScreen, CustomCrosshair crosshair, int x, int y, String label) {
        super(parentGuiScreen, x, y, -1, 25);
        this.crosshair = crosshair;
        this.labelSpacing = 3;
        this.boxSize = 25;
        this.label = label;
        this.colour = new RGBAProperty("fake_colour", ModTheme.WHITE);
        this.isMouseOverBox = false;
        this.width = this.boxSize + this.labelSpacing + this.renderManager.textWidth(this.label);
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        super.draw(guiGraphics);
        this.renderManager.drawBorderedRectangle(guiGraphics.m_280168_(), this.x, this.y, this.x + this.boxSize, this.y + this.boxSize, 2.0f, this.currentBorderColour, this.currentBackgroundColour);
        this.renderManager.drawFilledRectangle(guiGraphics.m_280168_(), this.x + 2, this.y + 2, this.x + this.boxSize - 2, this.y + this.boxSize - 2, (RGBA)this.colour.get());
        this.renderManager.drawText(guiGraphics, this.label, this.x + this.boxSize + this.labelSpacing, this.y + this.boxSize / 2 - 3, ModTheme.WHITE, false);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        super.onMouseMove(mouseX, mouseY);
        this.currentBackgroundColour = this.isInsideBox(mouseX, mouseY) ? this.hoverBackgroundColour : this.baseBackgroundColour;
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        this.isMouseDownInside = this.isInsideBox(mouseX, mouseY);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        if (!this.isMouseDownInside) {
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new EditColourGuiScreen(this.crosshair, this.colour));
        this.isMouseDownInside = false;
    }

    private boolean isInsideBox(int mouseX, int mouseY) {
        return mouseX > this.x && mouseX <= this.x + this.boxSize && mouseY > this.y && mouseY <= this.y + this.boxSize;
    }

    @Override
    public void bind(RGBAProperty property) {
        this.colour = property;
    }
}

