/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival;

import by.jackraidenph.dragonsurvival.PacketProxy;
import by.jackraidenph.dragonsurvival.capability.Capabilities;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.config.ConfigHandler;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import by.jackraidenph.dragonsurvival.handlers.DragonFoodHandler;
import by.jackraidenph.dragonsurvival.handlers.SpecificsHandler;
import by.jackraidenph.dragonsurvival.handlers.WingObtainmentController;
import by.jackraidenph.dragonsurvival.nest.DismantleNest;
import by.jackraidenph.dragonsurvival.nest.NestBlock;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.nest.SleepInNest;
import by.jackraidenph.dragonsurvival.nest.ToggleRegeneration;
import by.jackraidenph.dragonsurvival.network.DiggingStatus;
import by.jackraidenph.dragonsurvival.network.GiveNest;
import by.jackraidenph.dragonsurvival.network.IMessage;
import by.jackraidenph.dragonsurvival.network.OpenCrafting;
import by.jackraidenph.dragonsurvival.network.OpenDragonInventory;
import by.jackraidenph.dragonsurvival.network.PacketSyncCapabilityMovement;
import by.jackraidenph.dragonsurvival.network.PacketSyncPredatorStats;
import by.jackraidenph.dragonsurvival.network.PacketSyncXPDevour;
import by.jackraidenph.dragonsurvival.network.RefreshDragons;
import by.jackraidenph.dragonsurvival.network.SetFlyState;
import by.jackraidenph.dragonsurvival.network.StartJump;
import by.jackraidenph.dragonsurvival.network.SyncCapabilityDebuff;
import by.jackraidenph.dragonsurvival.network.SyncSize;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import by.jackraidenph.dragonsurvival.network.SynchronizeNest;
import by.jackraidenph.dragonsurvival.network.ToggleWings;
import by.jackraidenph.dragonsurvival.registration.BlockInit;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import by.jackraidenph.dragonsurvival.util.BiomeDictionaryHelper;
import by.jackraidenph.dragonsurvival.util.DragonLevel;
import by.jackraidenph.dragonsurvival.util.DragonType;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="dragonsurvival")
public class DragonSurvivalMod {
    public static final String MODID = "dragonsurvival";
    public static final Logger LOGGER = LogManager.getLogger((String)"Dragon Survival");
    private static final String PROTOCOL_VERSION = "2";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dragonsurvival", "main"), () -> "2", "2"::equals, "2"::equals);
    private static int nextPacketId = 0;

    public DragonSurvivalMod() {
        GeckoLib.initialize();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigHandler.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHandler.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigHandler.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DragonFoodHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SpecificsHandler());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::biomeLoadingEvent);
        MinecraftForge.EVENT_BUS.addListener(this::serverRegisterCommandsEvent);
    }

    private static <T> void register(Class<T> clazz, IMessage<T> message) {
        CHANNEL.registerMessage(nextPacketId++, clazz, message::encode, message::decode, message::handle);
    }

    private void setup(FMLCommonSetupEvent event) {
        WingObtainmentController.loadDragonPhrases();
        Capabilities.register();
        LOGGER.info("Successfully registered capabilities!");
        DragonSurvivalMod.register(PacketSyncCapabilityMovement.class, new PacketSyncCapabilityMovement());
        DragonSurvivalMod.register(SyncCapabilityDebuff.class, new SyncCapabilityDebuff());
        DragonSurvivalMod.register(PacketSyncXPDevour.class, new PacketSyncXPDevour());
        DragonSurvivalMod.register(PacketSyncPredatorStats.class, new PacketSyncPredatorStats());
        DragonSurvivalMod.register(SynchronizeNest.class, new SynchronizeNest());
        DragonSurvivalMod.register(OpenDragonInventory.class, new OpenDragonInventory());
        DragonSurvivalMod.register(SyncSize.class, new SyncSize());
        DragonSurvivalMod.register(ToggleWings.class, new ToggleWings());
        DragonSurvivalMod.register(OpenCrafting.class, new OpenCrafting());
        CHANNEL.registerMessage(nextPacketId++, SynchronizeDragonCap.class, (synchronizeDragonCap, packetBuffer) -> {
            packetBuffer.writeInt(synchronizeDragonCap.playerId);
            packetBuffer.writeByte(synchronizeDragonCap.dragonType.ordinal());
            packetBuffer.writeBoolean(synchronizeDragonCap.hiding);
            packetBuffer.writeFloat(synchronizeDragonCap.size);
            packetBuffer.writeBoolean(synchronizeDragonCap.hasWings);
            packetBuffer.writeInt(synchronizeDragonCap.lavaAirSupply);
            packetBuffer.writeInt(synchronizeDragonCap.passengerId);
        }, packetBuffer -> {
            int id = packetBuffer.readInt();
            DragonType type = DragonType.values()[packetBuffer.readByte()];
            boolean hiding = packetBuffer.readBoolean();
            float size = packetBuffer.readFloat();
            boolean hasWings = packetBuffer.readBoolean();
            int lavaAirSupply = packetBuffer.readInt();
            int passengerId = packetBuffer.readInt();
            return new SynchronizeDragonCap(id, hiding, type, size, hasWings, lavaAirSupply, passengerId);
        }, (synchronizeDragonCap, contextSupplier) -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.SERVER) {
                CHANNEL.send(PacketDistributor.ALL.noArg(), synchronizeDragonCap);
                ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                DragonStateProvider.getCap((Entity)serverPlayerEntity).ifPresent(dragonStateHandler -> {
                    dragonStateHandler.setIsHiding(synchronizeDragonCap.hiding);
                    dragonStateHandler.setType(synchronizeDragonCap.dragonType);
                    dragonStateHandler.setSize(synchronizeDragonCap.size, (PlayerEntity)serverPlayerEntity);
                    dragonStateHandler.setHasWings(synchronizeDragonCap.hasWings);
                    dragonStateHandler.setLavaAirSupply(synchronizeDragonCap.lavaAirSupply);
                    dragonStateHandler.setPassengerId(synchronizeDragonCap.passengerId);
                    serverPlayerEntity.setForcedPose(null);
                    serverPlayerEntity.func_213323_x_();
                });
            } else {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DragonSurvivalMod.lambda$null$4(synchronizeDragonCap, (Supplier)contextSupplier));
            }
        });
        CHANNEL.registerMessage(nextPacketId++, ToggleRegeneration.class, (toggleRegeneration, packetBuffer) -> {
            packetBuffer.func_179255_a(toggleRegeneration.nestPos);
            packetBuffer.writeBoolean(toggleRegeneration.state);
        }, packetBuffer -> new ToggleRegeneration(packetBuffer.func_179259_c(), packetBuffer.readBoolean()), (toggleRegeneration, contextSupplier) -> {
            ServerWorld serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().func_71121_q();
            TileEntity tileEntity = serverWorld.func_175625_s(toggleRegeneration.nestPos);
            if (tileEntity instanceof NestEntity) {
                ((NestEntity)tileEntity).regenerationMode = toggleRegeneration.state;
                tileEntity.func_70296_d();
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        CHANNEL.registerMessage(nextPacketId++, DismantleNest.class, (dismantleNest, packetBuffer) -> packetBuffer.func_179255_a(dismantleNest.nestPos), packetBuffer -> new DismantleNest(packetBuffer.func_179259_c()), (dismantleNest, contextSupplier) -> {
            ServerWorld serverWorld = ((NetworkEvent.Context)contextSupplier.get()).getSender().func_71121_q();
            TileEntity tileEntity = serverWorld.func_175625_s(dismantleNest.nestPos);
            if (tileEntity instanceof NestEntity) {
                serverWorld.func_175655_b(dismantleNest.nestPos, true);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        CHANNEL.registerMessage(nextPacketId++, SleepInNest.class, (sleepInNest, packetBuffer) -> packetBuffer.func_179255_a(sleepInNest.nestPos), packetBuffer -> new SleepInNest(packetBuffer.func_179259_c()), (sleepInNest, contextSupplier) -> {
            ServerPlayerEntity serverPlayerEntity = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (serverPlayerEntity.func_71121_q().func_226690_K_()) {
                serverPlayerEntity.func_213819_a(sleepInNest.nestPos);
                serverPlayerEntity.func_242111_a(serverPlayerEntity.func_71121_q().func_234923_W_(), sleepInNest.nestPos, 0.0f, false, true);
            }
        });
        CHANNEL.registerMessage(nextPacketId++, GiveNest.class, (giveNest, packetBuffer) -> packetBuffer.func_179249_a((Enum)giveNest.dragonType), packetBuffer -> new GiveNest((DragonType)packetBuffer.func_179257_a(DragonType.class)), (giveNest, contextSupplier) -> {
            NestBlock item;
            ServerPlayerEntity playerEntity = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            switch (giveNest.dragonType) {
                case CAVE: {
                    item = BlockInit.smallCaveNest;
                    break;
                }
                case FOREST: {
                    item = BlockInit.smallForestNest;
                    break;
                }
                case SEA: {
                    item = BlockInit.smallSeaNest;
                    break;
                }
                default: {
                    item = null;
                }
            }
            ItemStack itemStack = new ItemStack((IItemProvider)item);
            if (playerEntity.func_184592_cb().func_190926_b()) {
                playerEntity.func_184611_a(Hand.OFF_HAND, itemStack);
            } else {
                ItemStack stack = playerEntity.func_184592_cb().func_77946_l();
                playerEntity.func_184611_a(Hand.OFF_HAND, itemStack);
                if (!playerEntity.field_71071_by.func_70441_a(stack)) {
                    playerEntity.func_146097_a(stack, false, false);
                }
            }
        });
        CHANNEL.registerMessage(nextPacketId++, SetFlyState.class, (setFlyState, packetBuffer) -> {
            packetBuffer.writeInt(setFlyState.playerid);
            packetBuffer.writeBoolean(setFlyState.flying);
        }, packetBuffer -> new SetFlyState(packetBuffer.readInt(), packetBuffer.readBoolean()), (setFlyState, contextSupplier) -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientEvents.dragonsFlying.put(setFlyState.playerid, setFlyState.flying);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        CHANNEL.registerMessage(nextPacketId++, DiggingStatus.class, (diggingStatus, packetBuffer) -> {
            packetBuffer.writeInt(diggingStatus.playerId);
            packetBuffer.writeBoolean(diggingStatus.status);
        }, packetBuffer -> new DiggingStatus(packetBuffer.readInt(), packetBuffer.readBoolean()), (diggingStatus, contextSupplier) -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                Minecraft minecraft = Minecraft.func_71410_x();
                Entity entity = minecraft.field_71441_e.func_73045_a(diggingStatus.playerId);
                if (entity instanceof PlayerEntity) {
                    ClientEvents.dragonsDigging.put(entity.func_145782_y(), diggingStatus.status);
                }
            }
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        });
        CHANNEL.registerMessage(nextPacketId++, StartJump.class, (startJump, packetBuffer) -> {
            packetBuffer.writeInt(startJump.playerId);
            packetBuffer.writeByte(startJump.ticks);
        }, packetBuffer -> new StartJump(packetBuffer.readInt(), packetBuffer.readByte()), (startJump, contextSupplier) -> {
            Entity entity;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(startJump.playerId)) instanceof PlayerEntity) {
                ClientEvents.dragonsJumpingTicks.put(entity.func_145782_y(), startJump.ticks);
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        CHANNEL.registerMessage(nextPacketId++, RefreshDragons.class, (refreshDragons, packetBuffer) -> packetBuffer.writeInt(refreshDragons.playerId), packetBuffer -> new RefreshDragons(packetBuffer.readInt()), (refreshDragons, contextSupplier) -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                Thread thread = new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ClientPlayerEntity myPlayer = Minecraft.func_71410_x().field_71439_g;
                    ClientEvents.dummyDragon2.getAndSet((DragonEntity)EntityTypesInit.DRAGON.func_200721_a(myPlayer.field_70170_p));
                    ClientEvents.dummyDragon2.get().player = myPlayer.func_145782_y();
                    PlayerEntity thatPlayer = (PlayerEntity)myPlayer.field_70170_p.func_73045_a(refreshDragons.playerId);
                    if (thatPlayer != null) {
                        DragonEntity dragonEntity = (DragonEntity)EntityTypesInit.DRAGON.func_200721_a(myPlayer.field_70170_p);
                        dragonEntity.player = thatPlayer.func_145782_y();
                        ClientEvents.playerDragonHashMap.computeIfAbsent(thatPlayer.func_145782_y(), integer -> new AtomicReference<DragonEntity>(dragonEntity)).getAndSet(dragonEntity);
                    }
                });
                thread.start();
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        });
        LOGGER.info("Successfully registered packets!");
    }

    @SubscribeEvent
    public void biomeLoadingEvent(BiomeLoadingEvent event) {
        List<BiomeDictionary.Type> includeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigHandler.COMMON.predatorBiomesInclude.get()));
        List<BiomeDictionary.Type> excludeList = Arrays.asList(BiomeDictionaryHelper.toBiomeTypeArray((List)ConfigHandler.COMMON.predatorBiomesExclude.get()));
        List spawns = event.getSpawns().getSpawner(EntityClassification.MONSTER);
        ResourceLocation biomeName = event.getName();
        if (biomeName == null) {
            return;
        }
        RegistryKey biome = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)biomeName);
        Set biomeTypes = BiomeDictionary.getTypes((RegistryKey)biome);
        if (spawns.stream().anyMatch(x -> x.field_242588_c.func_220339_d() == EntityClassification.MONSTER) && biomeTypes.stream().anyMatch(x -> {
            if (!includeList.contains(x)) return false;
            if (!biomeTypes.stream().noneMatch(excludeList::contains)) return false;
            return true;
        })) {
            spawns.add(new MobSpawnInfo.Spawners(EntityTypesInit.MAGICAL_BEAST, ((Integer)ConfigHandler.COMMON.predatorSpawnWeight.get()).intValue(), ((Integer)ConfigHandler.COMMON.minPredatorSpawn.get()).intValue(), ((Integer)ConfigHandler.COMMON.maxPredatorSpawn.get()).intValue()));
        }
    }

    @SubscribeEvent
    public void serverRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        RootCommandNode rootCommandNode = commandDispatcher.getRoot();
        LiteralCommandNode dragon = ((LiteralArgumentBuilder)Commands.func_197057_a((String)"dragon").requires(commandSource -> commandSource.func_197034_c(2))).build();
        ArgumentCommandNode dragonType = Commands.func_197056_a((String)"dragon_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197008_a((String[])new String[]{"cave", "sea", "forest"}, (SuggestionsBuilder)builder)).build();
        ArgumentCommandNode dragonStage = Commands.func_197056_a((String)"dragon_stage", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).build();
        ArgumentCommandNode giveWings = ((RequiredArgumentBuilder)Commands.func_197056_a((String)"wings", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            int stage = (Integer)context.getArgument("dragon_stage", Integer.TYPE);
            boolean wings = (Boolean)context.getArgument("wings", Boolean.TYPE);
            ServerPlayerEntity serverPlayerEntity = ((CommandSource)context.getSource()).func_197035_h();
            serverPlayerEntity.getCapability(DragonStateProvider.DRAGON_CAPABILITY).ifPresent(dragonStateHandler -> {
                DragonType dragonType1 = DragonType.valueOf(type.toUpperCase());
                dragonStateHandler.setType(dragonType1);
                DragonLevel dragonLevel = DragonLevel.values()[stage - 1];
                dragonStateHandler.setHasWings(wings);
                dragonStateHandler.setSize(dragonLevel.size, (PlayerEntity)serverPlayerEntity);
                dragonStateHandler.setPassengerId(0);
                CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> serverPlayerEntity), (Object)new SynchronizeDragonCap(serverPlayerEntity.func_145782_y(), false, dragonType1, dragonLevel.size, wings, (Integer)ConfigHandler.SERVER.caveLavaSwimmingTicks.get(), dragonStateHandler.getPassengerId()));
                serverPlayerEntity.func_213323_x_();
            });
            return 1;
        })).build();
        rootCommandNode.addChild((CommandNode)dragon);
        dragon.addChild((CommandNode)dragonType);
        dragonType.addChild((CommandNode)dragonStage);
        dragonStage.addChild((CommandNode)giveWings);
        LOGGER.info("Registered commands");
    }

    private static /* synthetic */ Runnable lambda$null$4(SynchronizeDragonCap synchronizeDragonCap, Supplier contextSupplier) {
        return new PacketProxy().refreshInstances(synchronizeDragonCap, contextSupplier);
    }
}

