/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival;

import by.jackraidenph.dragonsurvival.capability.DragonStateHandler;
import by.jackraidenph.dragonsurvival.capability.DragonStateProvider;
import by.jackraidenph.dragonsurvival.entity.MagicalPredatorEntity;
import by.jackraidenph.dragonsurvival.gecko.DragonEntity;
import by.jackraidenph.dragonsurvival.handlers.ClientEvents;
import by.jackraidenph.dragonsurvival.handlers.ClientFlightHandler;
import by.jackraidenph.dragonsurvival.nest.NestEntity;
import by.jackraidenph.dragonsurvival.network.PacketSyncCapabilityMovement;
import by.jackraidenph.dragonsurvival.network.PacketSyncPredatorStats;
import by.jackraidenph.dragonsurvival.network.PacketSyncXPDevour;
import by.jackraidenph.dragonsurvival.network.SyncCapabilityDebuff;
import by.jackraidenph.dragonsurvival.network.SyncSize;
import by.jackraidenph.dragonsurvival.network.SynchronizeDragonCap;
import by.jackraidenph.dragonsurvival.network.SynchronizeNest;
import by.jackraidenph.dragonsurvival.registration.EntityTypesInit;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketProxy {
    public DistExecutor.SafeRunnable handleCapabilityDebuff(SyncCapabilityDebuff syncCapabilityDebuff, Supplier<NetworkEvent.Context> supplier) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            context.enqueueWork(() -> this.handleDebuffs(syncCapabilityDebuff, context));
        };
    }

    private void handleDebuffs(SyncCapabilityDebuff syncCapabilityDebuff, NetworkEvent.Context context) {
        ClientPlayerEntity thisPlayer = Minecraft.func_71410_x().field_71439_g;
        if (thisPlayer != null) {
            World world = thisPlayer.field_70170_p;
            Entity entity = world.func_73045_a(syncCapabilityDebuff.playerId);
            if (entity instanceof PlayerEntity) {
                DragonStateProvider.getCap(entity).ifPresent(dragonStateHandler -> dragonStateHandler.setDebuffData(syncCapabilityDebuff.timeWithoutWater, syncCapabilityDebuff.timeInDarkness));
            }
            context.setPacketHandled(true);
        }
    }

    public DistExecutor.SafeRunnable handleCapabilityMovement(PacketSyncCapabilityMovement syncCapabilityMovement, Supplier<NetworkEvent.Context> supplier) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            context.enqueueWork(() -> this.handleMovement(syncCapabilityMovement, context));
        };
    }

    private void handleMovement(PacketSyncCapabilityMovement syncCapabilityMovement, NetworkEvent.Context context) {
        World world;
        Entity entity;
        ClientPlayerEntity thisPlayer = Minecraft.func_71410_x().field_71439_g;
        if (thisPlayer != null && (entity = (world = thisPlayer.field_70170_p).func_73045_a(syncCapabilityMovement.playerId)) instanceof PlayerEntity) {
            DragonStateProvider.getCap(entity).ifPresent(arg_0 -> PacketProxy.lambda$handleMovement$3(entity, (PlayerEntity)thisPlayer, syncCapabilityMovement, arg_0));
        }
        context.setPacketHandled(true);
    }

    public DistExecutor.SafeRunnable updateSize(SyncSize syncSize, Supplier<NetworkEvent.Context> contextSupplier) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            Minecraft minecraft = Minecraft.func_71410_x();
            Entity entity = minecraft.field_71441_e.func_73045_a(syncSize.playerId);
            if (entity instanceof PlayerEntity) {
                DragonStateProvider.getCap(entity).ifPresent(dragonStateHandler -> dragonStateHandler.setSize(syncSize.size, (PlayerEntity)entity));
                ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
            }
        };
    }

    public DistExecutor.SafeRunnable refreshInstances(SynchronizeDragonCap synchronizeDragonCap, Supplier<NetworkEvent.Context> context) {
        return (DistExecutor.SafeRunnable & Serializable)() -> {
            ClientPlayerEntity myPlayer = Minecraft.func_71410_x().field_71439_g;
            if (myPlayer != null) {
                PlayerEntity thatPlayer;
                World world = myPlayer.field_70170_p;
                if (ClientEvents.dummyDragon2 != null) {
                    ClientEvents.dummyDragon2.get().player = myPlayer.func_145782_y();
                }
                if ((thatPlayer = (PlayerEntity)world.func_73045_a(synchronizeDragonCap.playerId)) != null) {
                    DragonStateProvider.getCap((Entity)thatPlayer).ifPresent(dragonStateHandler -> {
                        dragonStateHandler.setType(synchronizeDragonCap.dragonType);
                        dragonStateHandler.setIsHiding(synchronizeDragonCap.hiding);
                        dragonStateHandler.setHasWings(synchronizeDragonCap.hasWings);
                        dragonStateHandler.setSize(synchronizeDragonCap.size);
                        dragonStateHandler.setLavaAirSupply(synchronizeDragonCap.lavaAirSupply);
                        dragonStateHandler.setPassengerId(synchronizeDragonCap.passengerId);
                        if (!dragonStateHandler.hasWings() && thatPlayer == myPlayer) {
                            ClientFlightHandler.wingsEnabled = false;
                        }
                    });
                    if (thatPlayer != myPlayer) {
                        DragonEntity dragonEntity = (DragonEntity)EntityTypesInit.DRAGON.func_200721_a(world);
                        dragonEntity.player = thatPlayer.func_145782_y();
                        ClientEvents.playerDragonHashMap.computeIfAbsent(thatPlayer.func_145782_y(), integer -> new AtomicReference<DragonEntity>(dragonEntity)).getAndSet(dragonEntity);
                    }
                    thatPlayer.setForcedPose(null);
                    thatPlayer.func_213323_x_();
                }
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        };
    }

    public void syncXpDevour(PacketSyncXPDevour m, Supplier<NetworkEvent.Context> supplier) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            ExperienceOrbEntity xpOrb = (ExperienceOrbEntity)world.func_73045_a(m.xp);
            MagicalPredatorEntity entity = (MagicalPredatorEntity)world.func_73045_a(m.entity);
            if (xpOrb != null && entity != null) {
                entity.size += (float)xpOrb.func_70526_d() / 100.0f;
                entity.size = MathHelper.func_76131_a((float)entity.size, (float)0.95f, (float)1.95f);
                world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, xpOrb.func_226277_ct_(), xpOrb.func_226278_cu_(), xpOrb.func_226281_cx_(), 0.0, (double)(world.func_201674_k().nextFloat() / 12.5f), 0.0);
                xpOrb.func_70106_y();
                supplier.get().setPacketHandled(true);
            }
        }
    }

    public void syncPredatorStats(PacketSyncPredatorStats m, Supplier<NetworkEvent.Context> supplier) {
        Entity entity;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && (entity = world.func_73045_a(m.id)) != null) {
            ((MagicalPredatorEntity)entity).size = m.size;
            ((MagicalPredatorEntity)entity).field_200606_g = m.type;
            supplier.get().setPacketHandled(true);
        }
    }

    public void syncNest(SynchronizeNest synchronizeNest, Supplier<NetworkEvent.Context> contextSupplier) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        TileEntity entity = world.func_175625_s(synchronizeNest.pos);
        if (entity instanceof NestEntity) {
            NestEntity nestEntity = (NestEntity)entity;
            nestEntity.energy = synchronizeNest.health;
            nestEntity.damageCooldown = synchronizeNest.cooldown;
            nestEntity.func_70296_d();
            if (nestEntity.energy <= 0) {
                world.func_184133_a((PlayerEntity)player, synchronizeNest.pos, SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                world.func_184133_a((PlayerEntity)player, synchronizeNest.pos, SoundEvents.field_187767_eL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            contextSupplier.get().setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handleMovement$3(Entity entity, PlayerEntity thisPlayer, PacketSyncCapabilityMovement syncCapabilityMovement, DragonStateHandler dragonStateHandler) {
        if ((PlayerEntity)entity == thisPlayer) {
            dragonStateHandler.setMovementData(syncCapabilityMovement.bodyYaw, ((PlayerEntity)entity).field_70759_as, entity.field_70125_A, syncCapabilityMovement.bite);
        } else {
            dragonStateHandler.setMovementData(syncCapabilityMovement.bodyYaw, syncCapabilityMovement.headYaw, syncCapabilityMovement.headPitch, syncCapabilityMovement.bite);
        }
    }
}

