/*
 * Decompiled with CFR 0.152.
 */
package by.jackraidenph.dragonsurvival.blocks;

import by.jackraidenph.dragonsurvival.Functions;
import by.jackraidenph.dragonsurvival.gui.DragonAltarGUI;
import by.jackraidenph.dragonsurvival.registration.TileEntityTypesInit;
import by.jackraidenph.dragonsurvival.tiles.AltarEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DragonAltarBlock
extends Block {
    private final VoxelShape SHAPE = VoxelShapes.func_197868_b();
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public DragonAltarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }

    public ActionResultType func_225533_a_(BlockState blockState, World worldIn, BlockPos blockPos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        TileEntity tileEntity = worldIn.func_175625_s(blockPos);
        if (tileEntity instanceof AltarEntity) {
            AltarEntity altarEntity = (AltarEntity)tileEntity;
            int cooldown = altarEntity.usageCooldowns.getOrDefault(player.func_110124_au(), 0);
            if (cooldown > 0) {
                if (worldIn.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("ds.cooldown.active").func_240702_b_(": " + Functions.ticksToSeconds(cooldown)), player.func_110124_au());
                }
                return ActionResultType.CONSUME;
            }
            if (worldIn.field_72995_K) {
                this.openGUi();
            }
            altarEntity.usageCooldowns.put(player.func_110124_au(), Functions.secondsToTicks(1));
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGUi() {
        Minecraft.func_71410_x().func_147108_a((Screen)new DragonAltarGUI((ITextComponent)new TextComponent(){

            public String func_150261_e() {
                return "Dragon altar";
            }

            public TextComponent func_230531_f_() {
                return this;
            }
        }));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityTypesInit.altarEntityTile.func_200968_a();
    }
}

